/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.io.StreamAssembler;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.text.TextException;
import org.plasma.text.lang3gl.DefaultLang3GLAssembler;
import org.plasma.text.lang3gl.Lang3GLAssembler;
import org.plasma.text.lang3gl.Lang3GLFactory;
import org.plasma.text.lang3gl.Lang3GLOperation;

public abstract class DefaultStreamAssembler
extends DefaultLang3GLAssembler
implements StreamAssembler,
Lang3GLAssembler {
    private static Log log = LogFactory.getLog(DefaultStreamAssembler.class);
    protected File dest;
    protected boolean indent = false;
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final String FILE_SEP = System.getProperty("file.separator");
    protected Map<String, Class> classMap = new HashMap<String, Class>();
    protected int resultInterfacesCount;
    protected int resultClassesCount;
    protected int resultEnumerationsCount;

    public DefaultStreamAssembler(Model packages, Lang3GLFactory factory, Lang3GLOperation operation, File dest) {
        super(packages, factory, operation);
        if (this.packages == null) {
            throw new IllegalArgumentException("expected 'packages' argument");
        }
        if (this.factory == null) {
            throw new IllegalArgumentException("expected 'factory' argument");
        }
        if (this.operation == null) {
            throw new IllegalArgumentException("expected 'operation' argument");
        }
        this.dest = dest;
        if (this.dest == null) {
            throw new IllegalArgumentException("expected 'dest' argument");
        }
    }

    public void start() {
        try {
            for (Package pkg : this.packages.getPackages()) {
                for (Class clss : pkg.getClazzs()) {
                    this.classMap.put(clss.getUri() + "#" + clss.getName(), clss);
                }
            }
            switch (this.operation) {
                case create: {
                    this.createEnumerationClasses();
                    this.createInterfaceClasses();
                    this.createInterfacePackageDocs();
                    this.createImplementationClasses();
                }
            }
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public String getIndentationToken() {
        return "\t";
    }

    public void setIndentationToken(String indentationToken) {
    }

    public int getResultInterfacesCount() {
        return this.resultInterfacesCount;
    }

    public int getResultClassesCount() {
        return this.resultClassesCount;
    }

    public int getResultEnumerationsCount() {
        return this.resultEnumerationsCount;
    }
}

