/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.text.lang3gl.ClassFactory;
import org.plasma.text.lang3gl.DefaultStreamAssembler;
import org.plasma.text.lang3gl.Lang3GLFactory;
import org.plasma.text.lang3gl.Lang3GLOperation;

public class DSLAssembler
extends DefaultStreamAssembler {
    private static Log log = LogFactory.getLog(DSLAssembler.class);

    public DSLAssembler(Model packages, Lang3GLFactory factory, Lang3GLOperation operation, File dest) {
        super(packages, factory, operation, dest);
    }

    @Override
    public void createEnumerationClasses() throws IOException {
    }

    @Override
    public void createInterfaceClasses() throws IOException {
    }

    @Override
    public void createImplementationClasses() throws IOException {
        ClassFactory classFactory = this.factory.getClassFactory();
        for (Package pkg : this.packages.getPackages()) {
            File dir = new File(this.dest, classFactory.createDirectoryName(pkg));
            log.debug((Object)("processing package: " + dir.getAbsolutePath()));
            for (Class clss : pkg.getClazzs()) {
                if (!PlasmaConfig.getInstance().generateQueryDSL(clss.getUri(), clss.getName())) continue;
                if (!dir.exists()) {
                    if (!dir.mkdirs()) {
                        throw new IllegalArgumentException("package directory '" + dir.getAbsolutePath() + "' could not be created");
                    }
                    log.debug((Object)("created package: " + dir.getAbsolutePath()));
                }
                File file = new File(dir, classFactory.createFileName(clss));
                log.debug((Object)("creating file: " + file.getAbsolutePath()));
                FileOutputStream stream = new FileOutputStream(file);
                StringBuilder buf = new StringBuilder();
                buf.append(classFactory.createContent(pkg, clss));
                stream.write(buf.toString().getBytes());
                stream.flush();
                stream.close();
                ++this.resultClassesCount;
            }
        }
    }

    @Override
    public void createInterfacePackageDocs() throws IOException {
    }
}

