/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.adapter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.provisioning.Alias;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.Enumeration;
import org.plasma.provisioning.EnumerationRef;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.PropertyNameCollisionException;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.TypeNameCollisionException;
import org.plasma.provisioning.TypeRef;
import org.plasma.provisioning.adapter.TypeAdapter;

public class ModelAdapter {
    private static Log log = LogFactory.getLog(ModelAdapter.class);
    private Model model;
    private Map<String, TypeAdapter> typeMap = new HashMap<String, TypeAdapter>();

    private ModelAdapter() {
    }

    public ModelAdapter(Model model) {
        this.model = model;
        this.construct();
    }

    public Model getModel() {
        return this.model;
    }

    public Collection<TypeAdapter> getTypes() {
        return this.typeMap.values();
    }

    public TypeAdapter[] getTypesArray() {
        TypeAdapter[] result = new TypeAdapter[this.typeMap.size()];
        this.typeMap.values().toArray(result);
        return result;
    }

    public TypeAdapter findType(String key) {
        TypeAdapter result = this.typeMap.get(key);
        return result;
    }

    private void construct() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"constructing...");
        }
        for (Package pkg : this.model.getPackages()) {
            this.mapEnumerations(pkg);
        }
        for (Package pkg : this.model.getPackages()) {
            this.mapClasses(pkg);
        }
        for (TypeAdapter adapter : this.typeMap.values()) {
            if (!(adapter.getType() instanceof Class)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("constructing class: " + adapter.getKey()));
            }
            this.construct(adapter, null);
        }
        for (TypeAdapter adapter : this.typeMap.values()) {
            if (!(adapter.getType() instanceof Class)) continue;
            for (ClassRef baseClassRef : ((Class)adapter.getType()).getSuperClasses()) {
                String key = baseClassRef.getUri() + "#" + baseClassRef.getName();
                TypeAdapter baseAdapter = this.typeMap.get(key);
                if (baseAdapter == null) {
                    throw new IllegalStateException("no mapping found for base type: " + key);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("construct deep: " + adapter.getKey()));
                }
                this.constructDeep(adapter, baseAdapter);
            }
        }
    }

    private void mapEnumerations(Package pkg) {
        for (Enumeration enm : pkg.getEnumerations()) {
            String key = enm.getUri() + "#" + enm.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("mapping enumeration: " + key));
            }
            if (this.typeMap.get(key) != null) {
                throw new TypeNameCollisionException("detected multiple types named '" + enm.getName() + "' under the same URI '" + enm.getUri() + "'");
            }
            this.typeMap.put(key, new TypeAdapter(enm));
        }
    }

    private void mapClasses(Package pkg) {
        for (Class cls : pkg.getClazzs()) {
            String key = cls.getUri() + "#" + cls.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("mapping class: " + key));
            }
            if (this.typeMap.get(key) != null) {
                throw new TypeNameCollisionException("detected multiple types named '" + cls.getName() + "' under the same URI '" + cls.getUri() + "'");
            }
            TypeAdapter adapter = new TypeAdapter(cls);
            this.typeMap.put(key, adapter);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("map: " + adapter.getKey()));
        }
    }

    private void construct(TypeAdapter adapter, TypeAdapter source) {
        for (Property prop : ((Class)adapter.getType()).getProperties()) {
            if (adapter.getDeclaredProperty(prop.getName()) != null) {
                throw new PropertyNameCollisionException("detected multiple properties with the same logical name '" + prop.getName() + "' defined for class '" + adapter.getKey() + "' the set of logical names for a class " + "must be unique");
            }
            adapter.putDeclaredProperty(prop.getName(), prop);
            adapter.putProperty(prop.getName(), prop);
            if (prop.getAlias() == null) continue;
            Alias alias = prop.getAlias();
            if (alias.getPhysicalName() != null && alias.getPhysicalName().trim().length() > 0) {
                String physicalName = alias.getPhysicalName().trim();
                if (adapter.getAliasedProperty(physicalName) != null) {
                    throw new PropertyNameCollisionException("detected multiple properties with the same physical name '" + alias + "' defined for class '" + adapter.getKey() + "' the set of physical names for a class " + "must be unique");
                }
                adapter.putAliasedProperty(physicalName, prop);
            }
            if (alias.getLocalName() == null || alias.getLocalName().trim().length() <= 0) continue;
            String localName = prop.getAlias().getLocalName().trim();
            if (adapter.getAliasedProperty(localName) != null) {
                throw new PropertyNameCollisionException("detected multiple properties with the same local name '" + alias + "' defined for class '" + adapter.getKey() + "' the set of local names for a class " + "must be unique");
            }
            adapter.putAliasedProperty(localName, prop);
        }
    }

    private void constructDeep(TypeAdapter adapter, TypeAdapter baseAdapter) {
        for (Property prop : ((Class)baseAdapter.getType()).getProperties()) {
            if (adapter.getProperty(prop.getName()) != null) {
                throw new PropertyNameCollisionException("detected multiple properties with the same logical name '" + prop.getName() + "' defined for class '" + adapter.getKey() + "' as well as its superclass '" + baseAdapter.getKey() + "' - the set of logical names for a class and " + "superclasses must be unique");
            }
            this.validate(baseAdapter, adapter, prop);
            adapter.putProperty(prop.getName(), prop);
            if (prop.getAlias() == null || prop.getAlias().getPhysicalName() == null || prop.getAlias().getPhysicalName().trim().length() <= 0) continue;
            String alias = prop.getAlias().getPhysicalName().trim();
            if (adapter.getAliasedProperty(alias) != null) {
                throw new PropertyNameCollisionException("detected multiple properties with the same physical name '" + alias + "' defined for class '" + adapter.getKey() + "' as well as its superclass '" + baseAdapter.getKey() + "' - the set of logical names for a class and " + "superclasses must be unique");
            }
            adapter.putAliasedProperty(alias, prop);
        }
        for (ClassRef baseClassRef : ((Class)baseAdapter.getType()).getSuperClasses()) {
            String key2 = baseClassRef.getUri() + "#" + baseClassRef.getName();
            TypeAdapter baseTypeAdapter = this.typeMap.get(key2);
            if (baseTypeAdapter == null) {
                throw new IllegalStateException("no mapping found for base type: " + key2);
            }
            this.constructDeep(adapter, baseTypeAdapter);
        }
    }

    private void validate(TypeAdapter adapter, TypeAdapter source, Property prop) {
        String refkey;
        TypeRef ref;
        if (prop.getType() instanceof ClassRef) {
            Class oppositeClass;
            Property oppositeProperty;
            ref = (ClassRef)prop.getType();
            refkey = ref.getUri() + "#" + ref.getName();
            if (this.typeMap.get(refkey) == null) {
                throw new ProvisioningException("invalid type reference detected for property '" + adapter.getKey() + "." + prop.getName() + "' no class or enumeration '" + refkey + "' is defined");
            }
            if (prop.getOpposite() != null && (oppositeProperty = this.findPropertyByName(oppositeClass = (Class)this.typeMap.get(refkey).getType(), prop.getOpposite())) == null) {
                throw new ProvisioningException("invalid opposite reference detected for property '" + adapter.getKey() + "." + prop.getName() + "' no opposite property '" + prop.getOpposite() + "' is defined for class '" + refkey + "'");
            }
        }
        if (prop.getType() instanceof EnumerationRef && this.typeMap.get(refkey = (ref = (EnumerationRef)prop.getType()).getUri() + "#" + ref.getName()) == null) {
            throw new ProvisioningException("invalid type reference detected for property '" + prop.getName() + "' defined for class '" + adapter.getKey() + "'");
        }
    }

    private Property findPropertyByName(Class clss, String name) {
        for (Property prop : clss.getProperties()) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }
}

