/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PathAssembler;
import org.plasma.sdo.PlasmaNode;

public class CorePathAssembler
implements PathAssembler {
    private static Log log = LogFactory.getFactory().getInstance(CorePathAssembler.class);
    public static String PATH_PREFIX = "#/namespace:";
    public static String PATH_DELIM = "/";
    public static String PATH_INDEX_RIGHT = "[";
    public static String PATH_INDEX_LEFT = "]";
    private PlasmaNode pathTarget;
    private Stack<PathNode> currentPath = new Stack();
    private List<Stack<PathNode>> pathList = new ArrayList<Stack<PathNode>>();

    private CorePathAssembler() {
    }

    public CorePathAssembler(DataObject pathTarget) {
        this.pathTarget = (PlasmaNode)((Object)pathTarget);
        DataObject root = this.pathTarget.getDataObject().getDataGraph().getRootObject();
        if (log.isDebugEnabled()) {
            log.debug((Object)("finding paths from root: " + root.getType().getName() + "(" + ((PlasmaNode)((Object)root)).getUUIDAsString() + ") to target " + this.pathTarget.getDataObject().getType().getName() + "(" + this.pathTarget.getUUIDAsString() + ")"));
        }
    }

    @Override
    public void visit(DataObject target, DataObject source, String propertyName, int level) {
        Property sourceProperty = null;
        if (source != null) {
            sourceProperty = source.getType().getProperty(propertyName);
        } else {
            DataObject root = this.pathTarget.getDataObject().getDataGraph().getRootObject();
            if (!target.equals(root)) {
                throw new IllegalArgumentException("expected data graph root as traversal root");
            }
        }
        if (log.isDebugEnabled()) {
            if (source == null) {
                log.debug((Object)("visit: " + target.getType().getName() + "(" + ((PlasmaNode)((Object)target)).getUUIDAsString() + ")"));
            } else {
                log.debug((Object)("visit: " + source.getType().getName() + "(" + ((PlasmaNode)((Object)source)).getUUIDAsString() + ")." + sourceProperty.getName() + "->" + target.getType().getName() + "(" + ((PlasmaNode)((Object)target)).getUUIDAsString() + ")"));
            }
        }
        if (level == this.currentPath.size()) {
            this.currentPath.push(new PathNode(target, 0, source, sourceProperty));
            if (target.equals(this.pathTarget)) {
                Stack<PathNode> path = new Stack<PathNode>();
                path.addAll(this.currentPath);
                this.pathList.add(path);
            }
        } else {
            PathNode pathNode = null;
            while (this.currentPath.size() > level) {
                pathNode = this.currentPath.pop();
            }
            if (this.currentPath.size() != level) {
                throw new IllegalStateException("unexpected path size, " + this.currentPath.size() + " and traversal level, " + level);
            }
            int siblingIndex = 0;
            if (pathNode.getSource().equals(source) && pathNode.getSourceProperty().getName().equals(sourceProperty.getName())) {
                siblingIndex = pathNode.getIndex() + 1;
            }
            this.currentPath.push(new PathNode(target, siblingIndex, source, sourceProperty));
            if (target.equals(this.pathTarget)) {
                Stack<PathNode> path = new Stack<PathNode>();
                path.addAll(this.currentPath);
                this.pathList.add(path);
            }
        }
    }

    @Override
    public String getMinimumPathString() {
        Stack<PathNode> path = this.getMinimumPath();
        Stack clone = (Stack)path.clone();
        String result = this.getPathString(clone);
        return result;
    }

    @Override
    public int getMinimumPathDepth() {
        return this.getMinimumPath().size();
    }

    private Stack<PathNode> getMinimumPath() {
        if (this.pathList.size() == 0) {
            DataObject root = this.pathTarget.getDataObject().getDataGraph().getRootObject();
            throw new IllegalStateException("no paths from root data-object, " + root.getType().getURI() + "#" + root.getType().getName() + " (" + ((PlasmaNode)((Object)root)).getUUIDAsString() + ") " + "to target, " + this.pathTarget.getDataObject().getType().getURI() + "#" + this.pathTarget.getDataObject().getType().getName() + " (" + this.pathTarget.getUUIDAsString() + ")");
        }
        Stack<PathNode> minPath = null;
        for (Stack<PathNode> path : this.pathList) {
            if (minPath != null && path.size() >= minPath.size()) continue;
            minPath = path;
        }
        return minPath;
    }

    @Override
    public int getPathCount() {
        return this.pathList.size();
    }

    @Override
    public String[] getAllPaths() {
        String[] result = new String[this.pathList.size()];
        for (int i = 0; i < this.pathList.size(); ++i) {
            result[i] = this.getPathString(this.pathList.get(i));
        }
        return result;
    }

    private String getPathString(Stack<PathNode> path) {
        PathNode pathNode = null;
        int size = path.size();
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            pathNode = path.pop();
            if (pathNode.getSource() == null) continue;
            if (i > 0) {
                tokens.add(PATH_DELIM);
            }
            if (pathNode.getSourceProperty().isMany()) {
                tokens.add(pathNode.getSourceProperty().getName() + PATH_INDEX_RIGHT + String.valueOf(pathNode.getIndex()) + PATH_INDEX_LEFT);
                continue;
            }
            tokens.add(pathNode.getSourceProperty().getName());
        }
        tokens.add(PATH_PREFIX);
        StringBuffer buf = new StringBuffer();
        for (int i = tokens.size() - 1; i >= 0; --i) {
            buf.append((String)tokens.get(i));
        }
        return buf.toString();
    }

    class PathNode {
        private DataObject target;
        private DataObject source;
        private Property sourceProperty;
        private int index = -1;

        private PathNode() {
        }

        public PathNode(DataObject target, int index, DataObject source, Property sourceProperty) {
            this.target = target;
            this.index = index;
            this.source = source;
            this.sourceProperty = sourceProperty;
        }

        public DataObject getTarget() {
            return this.target;
        }

        public DataObject getSource() {
            return this.source;
        }

        public Property getSourceProperty() {
            return this.sourceProperty;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

