/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.Type;
import fUML.Syntax.Classes.Kernel.VisibilityKind;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.PropertyBinding;
import org.plasma.config.TypeBinding;
import org.plasma.sdo.Alias;
import org.plasma.sdo.Concurrent;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.EnumerationConstraint;
import org.plasma.sdo.Key;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.Sort;
import org.plasma.sdo.Temporal;
import org.plasma.sdo.UniqueConstraint;
import org.plasma.sdo.ValueConstraint;
import org.plasma.sdo.ValueSetConstraint;
import org.plasma.sdo.XmlProperty;
import org.plasma.sdo.core.CoreType;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.profile.SDOAlias;
import org.plasma.sdo.profile.SDOConcurrent;
import org.plasma.sdo.profile.SDOKey;
import org.plasma.sdo.profile.XmlNodeType;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.Enumeration;
import org.plasma.sdo.repository.Property;

public class CoreProperty
implements PlasmaProperty {
    private CoreType type;
    private Property property;
    private String name;
    private QName qname;
    private int qnameHashCode;
    private String physicalName;
    private String localName;
    private CoreType containingType;
    private Map<commonj.sdo.Property, Object> instanceProperties;

    private CoreProperty() {
    }

    private CoreProperty(String name, CoreType type, CoreType containingType) {
        this.type = type;
        if (this.type == null) {
            throw new IllegalArgumentException("expected type argument");
        }
        if (!this.type.isDataType()) {
            throw new IllegalArgumentException("expected datatype not, " + this.type.getName());
        }
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException("expected name argument");
        }
        if (containingType != null) {
            PropertyBinding binding = PlasmaConfig.getInstance().findPropertyBinding(containingType.getURI(), containingType.getName(), name);
            if (binding != null) {
                if (binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                    this.name = binding.getLogicalName().trim();
                }
                if (binding.getPhysicalName() != null && binding.getPhysicalName().trim().length() > 0) {
                    this.physicalName = binding.getPhysicalName().trim();
                }
                if (binding.getLocalName() != null && binding.getLocalName().trim().length() > 0) {
                    this.localName = binding.getLocalName().trim();
                }
            }
            this.containingType = containingType;
            this.qname = new QName(this.containingType.getName(), this.name);
            this.qnameHashCode = this.qname.hashCode();
        } else {
            this.qname = new QName(this.name);
            this.qnameHashCode = this.qname.hashCode();
        }
    }

    public CoreProperty(CoreType type, Property property, CoreType containingType) {
        Long max;
        PropertyBinding binding;
        this.type = type;
        if (this.type == null) {
            throw new IllegalArgumentException("expected type argument");
        }
        this.property = property;
        this.name = this.property.getName();
        if (this.name == null || this.name.trim().length() == 0) {
            if (this.type.isDataType()) {
                throw new IllegalArgumentException("expected reference (non-datatype) property type not, " + this.type.getName());
            }
            this.name = this.getDerivedName(this.type);
        }
        if ((binding = PlasmaConfig.getInstance().findPropertyBinding(containingType.getURI(), containingType.getName(), this.name)) != null) {
            if (binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                this.name = binding.getLogicalName().trim();
            }
            if (binding.getPhysicalName() != null && binding.getPhysicalName().trim().length() > 0) {
                this.physicalName = binding.getPhysicalName().trim();
            }
            if (binding.getLocalName() != null && binding.getLocalName().trim().length() > 0) {
                this.localName = binding.getLocalName().trim();
            }
        }
        this.containingType = containingType;
        this.qname = new QName(this.containingType.getName(), this.name);
        this.qnameHashCode = this.qname.hashCode();
        this.instanceProperties = new HashMap<commonj.sdo.Property, Object>();
        if (this.property.getComments() != null) {
            this.instanceProperties.put(INSTANCE_PROPERTY_OBJECT_DESCRIPTION, this.property.getComments());
        }
        VisibilityKind visibility = VisibilityKind.public_;
        if (this.property.getVisibility() != null) {
            visibility = this.property.getVisibility();
        }
        this.instanceProperties.put(INSTANCE_PROPERTY_OBJECT_VISIBILITY, visibility);
        String physicalName = this.property.findPhysicalName();
        if (physicalName != null) {
            this.instanceProperties.put(INSTANCE_PROPERTY_STRING_PHYSICAL_NAME, physicalName);
        }
        if (this.property.getIsUnique()) {
            this.instanceProperties.put(INSTANCE_PROPERTY_BOOLEAN_ISUNIQUE, new Boolean(true));
        }
        if (this.property.isDataType() && (max = this.property.getMaxLength()) != null) {
            this.instanceProperties.put(INSTANCE_PROPERTY_INT_MAXLENGTH, max);
        }
    }

    public int hashCode() {
        return this.qnameHashCode;
    }

    public boolean equals(Object other) {
        if (other != null) {
            CoreProperty otherType = (CoreProperty)other;
            return this.qnameHashCode == otherType.hashCode();
        }
        return false;
    }

    private String getDerivedName(PlasmaType type) {
        return this.getDerivedName(type.getName());
    }

    private String getDerivedName(String typeName) {
        return typeName.substring(0, 1).toLowerCase() + typeName.substring(1);
    }

    public static PlasmaProperty createInstanceProperty(String name, DataType dataType) {
        CoreType type = (CoreType)PlasmaTypeHelper.INSTANCE.getType(PlasmaConfig.getInstance().getSDO().getDefaultNamespace().getUri(), dataType.name());
        CoreProperty property = new CoreProperty(name, type, null);
        return property;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataFlavor getDataFlavor() {
        if (!this.getType().isDataType()) {
            throw new UnsupportedOperationException("property " + this.getContainingType().getURI() + "#" + this.getContainingType().getName() + "." + this.getName() + " is not a data type property");
        }
        DataType dataType = DataType.valueOf(this.getType().getName());
        switch (dataType) {
            case Decimal: 
            case Double: 
            case Float: {
                return DataFlavor.real;
            }
            case Boolean: 
            case Int: 
            case Integer: 
            case Long: 
            case Short: {
                return DataFlavor.integral;
            }
            case Character: 
            case String: 
            case Strings: {
                return DataFlavor.string;
            }
            case Date: 
            case Duration: 
            case DateTime: 
            case Day: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Time: {
                return DataFlavor.temporal;
            }
        }
        return DataFlavor.other;
    }

    @Override
    public List<Comment> getDescription() {
        return (List)this.get(INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
    }

    @Override
    public String getDescriptionText() {
        StringBuilder buf = new StringBuilder();
        List list = (List)this.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
        if (list != null) {
            for (Comment comment : list) {
                buf.append(comment.getBody());
            }
        }
        return buf.toString();
    }

    @Override
    public String getPhysicalName() {
        if (this.physicalName != null) {
            return this.physicalName;
        }
        SDOAlias alias = this.property.findAlias();
        if (alias != null && alias.getPhysicalName() != null) {
            return alias.getPhysicalName();
        }
        return null;
    }

    @Override
    public byte[] getNameBytes() {
        byte[] result = (byte[])this.instanceProperties.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES);
        if (result == null) {
            result = this.getName().getBytes(Charset.forName("UTF-8"));
            this.instanceProperties.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public byte[] getPhysicalNameBytes() {
        String name;
        byte[] result = (byte[])this.instanceProperties.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES);
        if (result == null && (name = this.getPhysicalName()) != null) {
            result = name.getBytes(Charset.forName("UTF-8"));
            this.instanceProperties.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        SDOAlias alias = this.property.findAlias();
        if (alias != null && alias.getLocalName() != null) {
            return alias.getLocalName();
        }
        return this.name;
    }

    @Override
    public byte[] getLocalNameBytes() {
        byte[] result = (byte[])this.instanceProperties.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES);
        if (result == null) {
            result = this.getLocalName().getBytes(Charset.forName("UTF-8"));
            this.instanceProperties.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public Alias getAlias() {
        return this.property.findAlias();
    }

    @Override
    public Key getKey() {
        return this.property.findKey();
    }

    @Override
    public boolean isKey() {
        SDOKey key = this.property.findKey();
        return key != null;
    }

    @Override
    public boolean isKey(KeyType keyType) {
        SDOKey key = this.property.findKey();
        if (key == null) {
            return false;
        }
        return key.getType().ordinal() == keyType.ordinal();
    }

    @Override
    public Concurrent getConcurrent() {
        return this.property.findConcurrent();
    }

    @Override
    public boolean isConcurrent() {
        SDOConcurrent concurrent = this.property.findConcurrent();
        return concurrent != null;
    }

    @Override
    public boolean isConcurrent(ConcurrencyType type, ConcurrentDataFlavor dataFlavor) {
        SDOConcurrent concurrent = this.property.findConcurrent();
        if (concurrent == null) {
            return false;
        }
        return concurrent.getType().ordinal() == type.ordinal() && concurrent.getDataFlavor().ordinal() == dataFlavor.ordinal();
    }

    @Override
    public Temporal getTemporal() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findTemporal();
    }

    @Override
    public EnumerationConstraint getEnumerationConstraint() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findEnumerationConstraint();
    }

    @Override
    public ValueSetConstraint getValueSetConstraint() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findValueSetConstraint();
    }

    @Override
    public ValueConstraint getValueConstraint() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findValueConstraint();
    }

    @Override
    public Sort getSort() {
        return this.property.findSort();
    }

    @Override
    public UniqueConstraint getUniqueConstraint() {
        return this.property.findUniqueConstraint();
    }

    @Override
    public XmlProperty getXmlProperty() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.findXmlProperty();
    }

    @Override
    public Enumeration getRestriction() {
        if (!this.property.isDataType()) {
            throw new IllegalArgumentException("property " + this.getType().getURI() + "#" + this.getType().getName() + "." + this.getName() + " is not a datatype property");
        }
        return this.property.getRestriction();
    }

    @Override
    public long getMaxLength() {
        Long maxlen = (Long)this.get(INSTANCE_PROPERTY_INT_MAXLENGTH);
        if (maxlen != null) {
            return maxlen;
        }
        return -1L;
    }

    @Override
    public boolean isXMLAttribute() {
        if (!this.getType().isDataType()) {
            return false;
        }
        XmlProperty xmlPropery = this.getXmlProperty();
        if (xmlPropery != null) {
            return xmlPropery.getNodeType().ordinal() == XmlNodeType.attribute.ordinal();
        }
        DataType datatype = DataType.valueOf(this.getType().getName());
        switch (datatype) {
            case Decimal: 
            case Double: 
            case Float: 
            case Boolean: 
            case Int: 
            case Integer: 
            case Long: 
            case Short: 
            case Character: 
            case Date: 
            case Duration: 
            case DateTime: 
            case Day: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: 
            case Time: 
            case Byte: 
            case URI: {
                return true;
            }
            case Bytes: 
            case Object: {
                return false;
            }
            case String: 
            case Strings: {
                if (this.getEnumerationConstraint() != null) {
                    return true;
                }
                if (this.getValueConstraint() != null) {
                    return true;
                }
                if (this.getMaxLength() == -1L || this.getMaxLength() > 20L) {
                    return false;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("unknown datatype, " + datatype.toString());
    }

    @Override
    public Object get(commonj.sdo.Property property) {
        Object result = null;
        if (this.instanceProperties != null && (result = this.instanceProperties.get(property)) == null) {
            result = this.instanceProperties.get(property.getName());
        }
        return result;
    }

    @Override
    public List getInstanceProperties() {
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>();
        if (this.instanceProperties != null) {
            Iterator<commonj.sdo.Property> iter = this.instanceProperties.keySet().iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    @Override
    public List<String> getAliasNames() {
        ArrayList<String> aliasList = new ArrayList<String>();
        SDOAlias alias = this.property.findAlias();
        if (alias != null) {
            if (alias.getPhysicalName() != null) {
                aliasList.add(alias.getPhysicalName());
            }
            if (alias.getLocalName() != null) {
                aliasList.add(alias.getLocalName());
            }
            if (alias.getBusinessName() != null) {
                aliasList.add(alias.getBusinessName());
            }
        }
        return aliasList;
    }

    @Override
    public Object getDefault() {
        return this.property.findPropertyDefault();
    }

    @Override
    public commonj.sdo.Property getOpposite() {
        if (!this.getType().isDataType()) {
            org.modeldriven.fuml.repository.Property oppositeProperty = this.property.getOpposite();
            if (oppositeProperty != null) {
                Class_ oppositeClass = oppositeProperty.getClass_();
                String oppositeClassNamespaceURI = this.property.getNamespaceURI((Classifier)oppositeClass);
                String oppositeTypeName = oppositeClass.getName();
                TypeBinding binding = PlasmaConfig.getInstance().findTypeBinding(oppositeClassNamespaceURI, oppositeClass.getName());
                if (binding != null && binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                    oppositeTypeName = binding.getLogicalName().trim();
                }
                Type oppositeType = PlasmaTypeHelper.INSTANCE.getType(oppositeClassNamespaceURI, oppositeTypeName);
                String oppositePropertyName = oppositeProperty.getName();
                PropertyBinding propertyBinding = PlasmaConfig.getInstance().findPropertyBinding(oppositeClassNamespaceURI, oppositeClass.getName(), oppositeProperty.getName());
                if (propertyBinding != null && propertyBinding.getLogicalName() != null && propertyBinding.getLogicalName().trim().length() > 0) {
                    oppositePropertyName = propertyBinding.getLogicalName().trim();
                }
                if (oppositePropertyName != null && oppositePropertyName.trim().length() > 0) {
                    return oppositeType.getProperty(oppositePropertyName);
                }
                oppositePropertyName = this.getDerivedName(oppositeProperty.getType().getName());
                return oppositeType.getProperty(oppositePropertyName);
            }
            return null;
        }
        throw new PlasmaDataObjectException("cannot return opposite property for datatype property " + this.getType().getName() + "." + this.getName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isContainment() {
        return !this.property.isDataType();
    }

    @Override
    public Type getContainingType() {
        return this.containingType;
    }

    @Override
    public boolean isMany() {
        return this.property.isMany();
    }

    @Override
    public boolean isNullable() {
        return this.property.isNullable();
    }

    @Override
    public boolean isOpenContent() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.property.getIsReadonly();
    }

    public String toString() {
        if (this.containingType != null) {
            return this.containingType.toString() + "." + this.getName();
        }
        return this.getName();
    }
}

