/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository;

import fUML.Syntax.Classes.Kernel.Element;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.PackageableElement;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Extension;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.RepositorylException;
import org.modeldriven.fuml.repository.Stereotype;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.config.Artifact;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.profile.SDONamespace;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.RelationCache;
import org.plasma.sdo.repository.Repository;
import org.plasma.sdo.repository.RepositoryException;

public class PlasmaRepository
implements Repository {
    private static Repository instance;
    private static org.modeldriven.fuml.repository.Repository delegate;
    private RelationCache relationCache = new RelationCache();

    private PlasmaRepository() {
    }

    public static Repository getInstance() throws RepositoryException {
        if (instance == null) {
            PlasmaRepository.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws RepositorylException {
        if (instance == null) {
            for (Artifact artifact : PlasmaConfig.getInstance().getRepository().getArtifacts()) {
                InputStream stream = PlasmaConfig.class.getResourceAsStream(artifact.getUrn());
                if (stream == null) {
                    stream = PlasmaConfig.class.getClassLoader().getResourceAsStream(artifact.getUrn());
                }
                if (stream == null) {
                    throw new PlasmaRuntimeException("could not find artifact resource '" + artifact.getUrn() + "' on the current classpath");
                }
                Fuml.load((ResourceArtifact)new ResourceArtifact(artifact.getUrn(), artifact.getNamespaceUri(), stream));
            }
            delegate = org.modeldriven.fuml.repository.Repository.INSTANCE;
            instance = new PlasmaRepository();
        }
    }

    @Override
    public List<String> getAllNamespaceUris() {
        ArrayList<String> result = new ArrayList<String>();
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            result.add(namespace.getUri());
        }
        return result;
    }

    @Override
    public List<Namespace> getAllNamespaces() {
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            Package pkg = namespace.getBase_Package();
            org.modeldriven.fuml.repository.Package repoPkg = (org.modeldriven.fuml.repository.Package)delegate.getElementById(pkg.getXmiId());
            result.add(new Namespace(repoPkg));
        }
        return result;
    }

    public Namespace getNamespaceForUri(String uri) {
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            if (!namespace.getUri().equals(uri)) continue;
            String packageXmiId = namespace.getBase_Package().getXmiId();
            org.modeldriven.fuml.repository.Package pkg = (org.modeldriven.fuml.repository.Package)delegate.findElementById(packageXmiId);
            return new Namespace(pkg);
        }
        return null;
    }

    @Override
    public List<Classifier> getClassifiers(String uri) {
        ArrayList<Classifier> result = new ArrayList<Classifier>();
        List list = delegate.getStereotypes(SDONamespace.class);
        for (Stereotype s : list) {
            SDONamespace namespace = (SDONamespace)s.getDelegate();
            if (!uri.equals(namespace.getUri())) continue;
            this.addClassifiers(namespace.getBase_Package(), result);
            return result;
        }
        return result;
    }

    private void addClassifiers(Package pkg, List<Classifier> result) {
        for (PackageableElement pe : pkg.packagedElement) {
            if (pe instanceof Package) {
                this.addClassifiers((Package)pe, result);
                continue;
            }
            if (!(pe instanceof fUML.Syntax.Classes.Kernel.Class_)) continue;
            Classifier classifier = (Classifier)this.getElementById(pe.getXmiId());
            result.add(classifier);
        }
    }

    public org.modeldriven.fuml.repository.Element getElementById(String id) {
        return delegate.getElementById(id);
    }

    public Classifier getClassifier(String name) {
        Classifier result = delegate.getClassifier(name);
        if (result == null) {
            throw new RepositoryException("no classifier defined for qualified name, " + name);
        }
        return result;
    }

    public List<Stereotype> getStereotypes(org.modeldriven.fuml.repository.Element element) {
        return delegate.getStereotypes(element);
    }

    public Classifier findClassifier(String name) {
        return delegate.findClassifier(name);
    }

    public org.modeldriven.fuml.repository.Element findElementById(String id) {
        return delegate.findElementById(id);
    }

    public org.modeldriven.fuml.repository.Element findElementByName(String name) {
        return delegate.findElementByName(name);
    }

    public org.modeldriven.fuml.repository.Element findElementByQualifiedName(String qualifiedName) {
        return delegate.findElementByQualifiedName(qualifiedName);
    }

    public String findJavaPackageNamePackageForClass(Classifier classifier) {
        throw new RepositoryException("not implemented");
    }

    public List<Stereotype> getAllStereotypes() {
        return delegate.getAllStereotypes();
    }

    public Classifier getClassifierByName(String name) {
        return delegate.getClassifierByName(name);
    }

    public Classifier getClassifierByQualifiedName(String qualifiedName) {
        return delegate.getClassifierByQualifiedName(qualifiedName);
    }

    public String getDefaultUMLNamespaceURI() {
        return delegate.getDefaultUMLNamespaceURI();
    }

    public org.modeldriven.fuml.repository.Element getElementByName(String name) {
        return delegate.getElementByName(name);
    }

    public org.modeldriven.fuml.repository.Element getElementByQualifiedName(String qualifiedName) {
        return delegate.getElementByQualifiedName(qualifiedName);
    }

    public int getElementCount(Class<? extends Element> clss) {
        throw new RepositoryException("not implemented");
    }

    public String[] getElementNames(Class<? extends Element> clss) {
        throw new RepositoryException("not implemented");
    }

    public List<Extension> getExtensions(org.modeldriven.fuml.repository.Element element) {
        return delegate.getExtensions(element);
    }

    public String getJavaPackageNameForClass(Classifier classifier) {
        throw new RepositoryException("not implemented");
    }

    public RepositoryMapping getMapping() {
        throw new RepositoryException("not implemented");
    }

    public org.modeldriven.fuml.repository.Package getPackageByQualifiedName(String qualifiedName) {
        throw new RepositoryException("not implemented");
    }

    public List<Stereotype> getStereotypes(Class<?> clss) {
        return delegate.getStereotypes(clss);
    }

    public boolean isIgnoredClassifier(Classifier classifier) {
        throw new RepositoryException("not implemented");
    }

    public void loadClass(Class_ clss) {
        throw new RepositoryException("not implemented");
    }

    @Override
    public RelationCache getRelationCache() {
        return this.relationCache;
    }

    public List<Classifier> getSpecializations(Classifier classifier) {
        return delegate.getSpecializations(classifier);
    }
}

