/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Property;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.Repository;

public class RelationCache {
    private static Log log = LogFactory.getFactory().getInstance(RelationCache.class);
    private Map<String, RelationPathResult> map = new HashMap<String, RelationPathResult>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRelation(Classifier target, Classifier source, AssociationPath relation) {
        switch (relation) {
            case singular: {
                String key = this.createHashKey(target, source);
                RelationPathResult result = this.map.get(key);
                if (result == null) {
                    boolean isRelated = this.isLateralSingularRelation(target, source, null, new HashMap<String, Integer>());
                    result = new RelationPathResult(AssociationPath.singular, isRelated);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cacheing (" + isRelated + ") lateral-singular relation: " + target.getName() + "/" + source.getName()));
                    }
                    Map<String, RelationPathResult> map = this.map;
                    synchronized (map) {
                        this.map.put(key, result);
                    }
                }
                return result.isRelated();
            }
        }
        return false;
    }

    public void clear() {
        this.map.clear();
    }

    private String createHashKey(Classifier targetType, Classifier sourceType) {
        return targetType.getId() + "/" + sourceType.getId();
    }

    private String createHashKey(Property target, Property source) {
        return target.getXmiId() + "/" + source.getXmiId();
    }

    private boolean isLateralSingularRelation(Classifier targetType, Classifier sourceType, Property traversalSourceProperty, Map<String, Integer> visited) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing " + targetType.getName() + "/" + sourceType.getName()));
        }
        for (Property targetProperty : targetType.getAllProperties()) {
            org.modeldriven.fuml.repository.Classifier targetClassifier;
            if (targetProperty.getType().isDataType() || !targetProperty.isSingular()) continue;
            if (traversalSourceProperty != null) {
                String linkKey = this.createHashKey(targetProperty, traversalSourceProperty);
                Integer count = null;
                count = visited.get(linkKey);
                if (count == null) {
                    visited.put(linkKey, 1);
                } else {
                    Property opposite = targetProperty.getOpposite();
                    if (opposite != null && opposite.isSingular()) {
                        log.warn((Object)("singular property " + targetType.getName() + "." + (targetProperty.getName() == null ? targetProperty.getXmiId() : targetProperty.getName()) + " has opposite " + opposite.getClass_().getName() + "." + (opposite.getName() == null ? opposite.getXmiId() : opposite.getName()) + " which is also singular"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("exiting - visited " + targetType.getName() + "." + targetProperty.getName()));
                    }
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing " + targetType.getName() + "." + targetProperty.getName()));
            }
            if (targetProperty.getType().getXmiId().equals(sourceType.getId())) {
                if (targetType.getId().equals(sourceType.getId())) {
                    log.warn((Object)("potential circular reference: " + targetType.getNamespaceURI() + "#" + targetType.getName() + "." + targetProperty.getName() + "->" + sourceType.getNamespaceURI() + "#" + sourceType.getName()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found child link property " + targetType.getName() + "." + targetProperty.getName() + "->" + sourceType.getName()));
                }
                return true;
            }
            if (targetProperty.getType().getXmiId().equals(targetType.getId())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("traversing " + targetType.getName() + "." + targetProperty.getName()));
            }
            if (!this.isLateralSingularRelation(new Classifier(targetClassifier = (org.modeldriven.fuml.repository.Classifier)Repository.INSTANCE.getElementById(targetProperty.getType().getXmiId())), sourceType, targetProperty, visited)) continue;
            return true;
        }
        return false;
    }

    class RelationPathResult {
        private AssociationPath relationPath;
        private boolean related;

        private RelationPathResult() {
        }

        public RelationPathResult(AssociationPath relationPath, boolean related) {
            this.relationPath = relationPath;
            this.related = related;
        }

        public AssociationPath getRelationPath() {
            return this.relationPath;
        }

        public boolean isRelated() {
            return this.related;
        }
    }
}

