/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.Locale;
import java.util.TreeMap;
import org.plasma.common.WordWrap;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.Documentation;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.text.lang3gl.InterfaceFactory;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.JDODefaultFactory;
import org.plasma.text.lang3gl.java.JDOInterfaceNameResolver;
import org.plasma.text.lang3gl.java.TypeClassInfo;

public class JDOInterfaceFactory
extends JDODefaultFactory
implements InterfaceFactory {
    public JDOInterfaceFactory(Lang3GLContext context) {
        super(context);
    }

    @Override
    public String createContent(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.createPackageDeclaration(pkg));
        buf.append(LINE_SEP);
        buf.append(this.createInterfaceReferenceImportDeclarations(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(LINE_SEP);
        buf.append(this.createTypeDeclaration(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.createMethodDeclarations(clss));
        for (Property field : clss.getProperties()) {
            buf.append(LINE_SEP);
            buf.append(this.createMethodDeclarations(clss, field));
        }
        buf.append(LINE_SEP);
        buf.append(this.endBody());
        return buf.toString();
    }

    protected String createThirdPartyImportDeclarations(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        return buf.toString();
    }

    protected String createStaticFieldDeclarations(Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.indent(1));
        buf.append("/** The SDO namespace URI associated with the SDO Type for this class */");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("public static final String NAMESPACE_URI = \"");
        buf.append(clss.getUri());
        buf.append("\";");
        buf.append(LINE_SEP);
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("public static final String ETY_");
        buf.append(this.toConstantName(clss.getName()));
        buf.append(" \t= \"");
        buf.append(clss.getName());
        buf.append("\";");
        for (Property field : clss.getProperties()) {
            buf.append(LINE_SEP);
            String javadoc = this.createStaticFieldDeclarationJavadoc(clss, field);
            buf.append(javadoc);
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append("public static final String PTY_");
            buf.append(this.toConstantName(field.getName()));
            buf.append(" \t= \"");
            buf.append(field.getName());
            buf.append("\";");
        }
        return buf.toString();
    }

    private String createStaticFieldDeclarationJavadoc(Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("/**");
        if (field.getDocumentations() != null) {
            for (Documentation doc : field.getDocumentations()) {
                String[] docLines;
                String docText = doc.getBody().getValue().trim();
                String wrappedDoc = WordWrap.wordWrap((String)docText, (int)60, (Locale)Locale.ENGLISH);
                for (String line : docLines = wrappedDoc.split("\n")) {
                    buf.append(LINE_SEP);
                    buf.append(this.indent(1));
                    buf.append(" * ");
                    buf.append(line);
                }
            }
        } else {
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append(" * The logical property <b>");
            buf.append(field.getName());
            buf.append("</b> which is part of the SDO Type <b>");
            buf.append(clss.getUri() + "#" + clss.getName());
            buf.append("</b>.");
        }
        if (clss.getAlias() != null && clss.getAlias().getPhysicalName() != null && field.getAlias() != null && field.getAlias().getPhysicalName() != null) {
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append(" *");
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append(" * <p></p>");
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append(" * <b>Data Store Mapping:</b>");
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append(" * Corresponds to the physical data store field <b>");
            buf.append(clss.getAlias().getPhysicalName() + "." + field.getAlias().getPhysicalName());
            buf.append("</b>.");
            buf.append(LINE_SEP);
            buf.append(this.indent(1));
            buf.append(" * <p></p>");
        }
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(" */");
        return buf.toString();
    }

    protected String createTypeDeclaration(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        JDOInterfaceNameResolver itfNameResolver = new JDOInterfaceNameResolver();
        String javadoc = this.createTypeDeclarationJavadoc(pkg, clss);
        buf.append(javadoc);
        buf.append(LINE_SEP);
        buf.append("public interface ");
        buf.append(itfNameResolver.getName(clss));
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            buf.append(" extends ");
            int i = 0;
            for (ClassRef ref : clss.getSuperClasses()) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(ref.getName());
                ++i;
            }
        }
        return buf.toString();
    }

    private String createTypeDeclarationJavadoc(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append("/**");
        if (clss.getDocumentations() != null) {
            for (Documentation doc : clss.getDocumentations()) {
                String[] docLines;
                String docText = doc.getBody().getValue().trim();
                String wrappedDoc = WordWrap.wordWrap((String)docText, (int)60, (Locale)Locale.ENGLISH);
                for (String line : docLines = wrappedDoc.split("\n")) {
                    buf.append(LINE_SEP);
                    buf.append(" * ");
                    buf.append(line);
                }
            }
        } else {
            buf.append(LINE_SEP);
            buf.append(" * An SDO interface representing <b>");
            buf.append(clss.getName());
            buf.append("</b> which is part of the SDO namespace <b>");
            buf.append(clss.getUri());
            buf.append("</b>.");
        }
        if (clss.getAlias() != null && clss.getAlias().getPhysicalName() != null) {
            buf.append(LINE_SEP);
            buf.append(" *");
            buf.append(LINE_SEP);
            buf.append(" * <p></p>");
            buf.append(LINE_SEP);
            buf.append(" * <b>Data Store Mapping:</b>");
            buf.append(LINE_SEP);
            buf.append(" * Corresponds to the physical data store entity <b>");
            buf.append(clss.getAlias().getPhysicalName());
            buf.append("</b>.");
            buf.append(LINE_SEP);
            buf.append(" * <p></p>");
            buf.append(LINE_SEP);
            buf.append(" *");
        }
        TreeMap<String, Class> classMap = new TreeMap<String, Class>();
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            this.collectProvisioningSuperclasses(pkg, clss, classMap);
        }
        this.collectProvisioningClasses(pkg, clss, classMap);
        for (Class refClass : classMap.values()) {
            Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(refClass.getUri());
            String packageName = sdoNamespace.getProvisioning().getPackageName();
            String packageQualifiedName = packageName + "." + refClass.getName();
            buf.append(LINE_SEP);
            buf.append(" * @see ");
            buf.append(packageQualifiedName);
            buf.append(" ");
            buf.append(refClass.getName());
        }
        buf.append(LINE_SEP);
        buf.append(" */");
        return buf.toString();
    }

    protected String createMethodDeclarations(Class clss) {
        return "";
    }

    protected String createMethodDeclarations(Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        TypeClassInfo typeClassName = this.getTypeClassName(field.getType());
        if (!field.isMany()) {
            buf.append(LINE_SEP);
            this.createSingularGetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createSingularSetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
        } else {
            buf.append(LINE_SEP);
            this.createManyGetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyIndexGetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyCountDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManySetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyAdderDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyRemoverDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
        }
        return buf.toString();
    }

    @Override
    public String createFileName(Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(clss.getName());
        buf.append(".java");
        return buf.toString();
    }
}

