/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.provisioning.Alias;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.Documentation;
import org.plasma.provisioning.DocumentationType;
import org.plasma.provisioning.NameUtils;
import org.plasma.provisioning.xsd.AbstractAssembler;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.xml.schema.ComplexRestrictionType;
import org.plasma.xml.schema.ComplexType;
import org.plasma.xml.schema.Element;
import org.plasma.xml.schema.ExtensionType;
import org.plasma.xml.schema.SchemaUtil;

public class ClassAssembler
extends AbstractAssembler {
    private static Log log = LogFactory.getLog(ClassAssembler.class);

    public ClassAssembler(ConverterSupport converterSupport, String destNamespaceURI, String destNamespacePrefix) {
        super(destNamespaceURI, destNamespacePrefix, converterSupport);
    }

    public Class buildClass(ComplexType complexType) {
        Class clss = new Class();
        clss.setId(UUID.randomUUID().toString());
        clss.setUri(this.destNamespaceURI);
        Alias alias = new Alias();
        clss.setAlias(alias);
        alias.setLocalName(complexType.getName());
        String name = this.formatLocalClassName(complexType.getName());
        clss.setName(name);
        String physicalNameAlias = NameUtils.toAbbreviatedName(name);
        alias.setPhysicalName(physicalNameAlias);
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent(complexType));
        clss.getDocumentations().add(documentation);
        if (complexType.getComplexContent() != null) {
            QName base;
            ComplexRestrictionType restriction;
            QName base2;
            ExtensionType extension = complexType.getComplexContent().getExtension();
            if (extension != null && (base2 = extension.getBase()) != null && !base2.getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
                ClassRef baseRef = new ClassRef();
                String formattedClassName = this.formatLocalClassName(base2.getLocalPart());
                baseRef.setName(formattedClassName);
                baseRef.setUri(this.destNamespaceURI);
                clss.getSuperClasses().add(baseRef);
            }
            if ((restriction = complexType.getComplexContent().getRestriction()) != null && (base = restriction.getBase()) != null && !base.getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
                ClassRef baseRef = new ClassRef();
                String formattedClassName = this.formatLocalClassName(base.getLocalPart());
                baseRef.setName(formattedClassName);
                baseRef.setUri(this.destNamespaceURI);
                clss.getSuperClasses().add(baseRef);
            }
        }
        return clss;
    }

    public Class buildClass(Element element) {
        QName base;
        Class clss = new Class();
        clss.setId(UUID.randomUUID().toString());
        clss.setUri(this.destNamespaceURI);
        Alias alias = new Alias();
        clss.setAlias(alias);
        alias.setLocalName(element.getName());
        String name = this.formatLocalClassName(element.getName());
        clss.setName(name);
        String physicalNameAlias = NameUtils.toAbbreviatedName(name);
        alias.setPhysicalName(physicalNameAlias);
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent(element));
        clss.getDocumentations().add(documentation);
        if (element.getComplexType() != null && element.getComplexType().getComplexContent() != null) {
            ExtensionType baseType = element.getComplexType().getComplexContent().getExtension();
            QName base2 = baseType.getBase();
            if (!base2.getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
                ClassRef baseRef = new ClassRef();
                String formattedClassName = this.formatLocalClassName(base2.getLocalPart());
                baseRef.setName(formattedClassName);
                baseRef.setUri(this.destNamespaceURI);
                clss.getSuperClasses().add(baseRef);
            }
        } else if (element.getSubstitutionGroup() != null && !(base = element.getSubstitutionGroup()).getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
            ClassRef baseRef = new ClassRef();
            String formattedClassName = this.formatLocalClassName(base.getLocalPart());
            baseRef.setName(formattedClassName);
            baseRef.setUri(this.destNamespaceURI);
            clss.getSuperClasses().add(baseRef);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created class: " + clss.getUri() + "#" + clss.getName()));
        }
        return clss;
    }
}

