/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.Change;
import org.plasma.sdo.ChangeType;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.core.CorePathAssembler;
import org.plasma.sdo.core.CoreSetting;

public class CoreChange
implements Change,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getFactory().getInstance(Change.class);
    private static List<ChangeSummary.Setting> emptySettingList = new ArrayList<ChangeSummary.Setting>();
    private DataObject dataObject;
    private ChangeType changeType;
    private Map<String, List<ChangeSummary.Setting>> settings;
    private String pathFromRoot;
    private int pathDepthFromRoot;

    public CoreChange(DataObject dataObject, ChangeType changeType, Map<UUID, CoreChange> changes) {
        this.dataObject = dataObject;
        this.changeType = changeType;
        PlasmaDataObject root = (PlasmaDataObject)dataObject.getDataGraph().getRootObject();
        if (root.equals(dataObject)) {
            this.pathFromRoot = CorePathAssembler.PATH_PREFIX;
            this.pathDepthFromRoot = 0;
        } else if (root.contains(dataObject)) {
            this.initializePath(root, null, dataObject);
        } else {
            PlasmaDataObject container = (PlasmaDataObject)dataObject.getContainer();
            CoreChange containerChange = changes.get(container.getUUID());
            if (containerChange != null) {
                this.initializePath(container, containerChange, dataObject);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("calculating min path for graph: " + ((PlasmaDataObject)dataObject.getDataGraph().getRootObject()).dump()));
                }
                CorePathAssembler visitor = new CorePathAssembler(dataObject);
                root.accept(visitor);
                this.pathFromRoot = visitor.getMinimumPathString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("selected min path: " + this.pathFromRoot));
                }
                this.pathDepthFromRoot = visitor.getMinimumPathDepth();
            }
        }
    }

    private void initializePath(DataObject source, CoreChange sourceChange, DataObject target) {
        StringBuilder buf = new StringBuilder();
        if (sourceChange == null) {
            buf.append(CorePathAssembler.PATH_PREFIX);
            this.pathDepthFromRoot = 1;
        } else {
            buf.append(sourceChange.getPathFromRoot());
            buf.append(CorePathAssembler.PATH_DELIM);
            this.pathDepthFromRoot = sourceChange.getPathDepthFromRoot() + 1;
        }
        if (target.getContainmentProperty() == null) {
            throw new IllegalStateException("data-object, " + target.toString() + " has no containment property");
        }
        if (!target.getContainmentProperty().isMany()) {
            buf.append(target.getContainmentProperty().getName());
        } else {
            List list = source.getList(target.getContainmentProperty());
            int index = -1;
            for (int i = 0; i < list.size(); ++i) {
                if (!((DataObject)list.get(i)).equals(target)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                throw new IllegalStateException("expected data-object, " + target.getType().toString() + " (" + ((PlasmaNode)((Object)target)).getUUIDAsString() + ") " + "as contained by root, " + source.getType().toString() + " (" + ((PlasmaNode)((Object)source)).getUUIDAsString() + ") through containment property, " + target.getContainmentProperty().getName());
            }
            buf.append(target.getContainmentProperty().getName());
            buf.append(CorePathAssembler.PATH_INDEX_RIGHT);
            buf.append(String.valueOf(index));
            buf.append(CorePathAssembler.PATH_INDEX_LEFT);
        }
        this.pathFromRoot = buf.toString();
    }

    public boolean equals(Object obj) {
        CoreChange other = (CoreChange)obj;
        return this.dataObject.equals(other.dataObject);
    }

    public int hashCode() {
        return this.dataObject.hashCode();
    }

    @Override
    public DataObject getDataObject() {
        return this.dataObject;
    }

    @Override
    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public List<ChangeSummary.Setting> getSettings(String propertyName) {
        if (this.settings == null || this.settings.size() == 0) {
            return emptySettingList;
        }
        return this.settings.get(propertyName);
    }

    @Override
    public void add(Property property, Object value) {
        List<ChangeSummary.Setting> dataObjectPropertySettings;
        if (this.settings == null) {
            this.settings = new HashMap<String, List<ChangeSummary.Setting>>();
        }
        if ((dataObjectPropertySettings = this.settings.get(property.getName())) == null) {
            dataObjectPropertySettings = new ArrayList<ChangeSummary.Setting>();
            this.settings.put(property.getName(), dataObjectPropertySettings);
        }
        dataObjectPropertySettings.add(new CoreSetting(this.dataObject, property, value));
    }

    @Override
    public List<ChangeSummary.Setting> getAllSettings() {
        if (this.settings == null || this.settings.size() == 0) {
            return emptySettingList;
        }
        ArrayList<ChangeSummary.Setting> result = new ArrayList<ChangeSummary.Setting>();
        Iterator<String> iter = this.settings.keySet().iterator();
        while (iter.hasNext()) {
            List<ChangeSummary.Setting> propertySettings = this.settings.get(iter.next());
            for (ChangeSummary.Setting setting : propertySettings) {
                result.add(setting);
            }
        }
        return result;
    }

    @Override
    public String getPathFromRoot() {
        return this.pathFromRoot;
    }

    @Override
    public int getPathDepthFromRoot() {
        return this.pathDepthFromRoot;
    }
}

