/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xml;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.XMLDocument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaDataGraphEventVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.sdo.helper.PlasmaXSDHelper;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.xml.Marshaller;
import org.plasma.sdo.xml.MarshallerException;
import org.plasma.sdo.xml.MarshallerFlavor;
import org.plasma.sdo.xml.MarshallerRuntimeException;
import org.plasma.sdo.xml.XMLOptions;
import org.plasma.xml.schema.SchemaUtil;

public class StreamMarshaller
extends Marshaller {
    private static Log log = LogFactory.getFactory().getInstance(StreamMarshaller.class);
    private XMLOutputFactory factory;
    private String namespacePrefix = "tns";
    private PlasmaXSDHelper helper = PlasmaXSDHelper.INSTANCE;
    private PropertyComparator comparator = new PropertyComparator();

    public StreamMarshaller(XMLDocument document) {
        super(MarshallerFlavor.STAX, document);
        this.construct();
    }

    public StreamMarshaller(XMLDocument document, XMLOptions options) {
        super(document, options);
        this.construct();
    }

    private void construct() {
        this.factory = XMLOutputFactory.newInstance();
    }

    private void setup() {
        if (this.getOptions() != null && this.getOptions().getRootNamespacePrefix() != null && this.getOptions().getRootNamespacePrefix().length() > 0) {
            this.namespacePrefix = this.getOptions().getRootNamespacePrefix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(OutputStream stream) throws XMLStreamException, MarshallerException {
        String encoding = this.findEncoding();
        XMLStreamWriter writer = null;
        writer = encoding != null ? this.factory.createXMLStreamWriter(stream, encoding) : this.factory.createXMLStreamWriter(stream);
        writer = new IndentingXMLStreamWriter(writer);
        try {
            this.write(writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Writer outputWriter) throws XMLStreamException, MarshallerException {
        XMLStreamWriter writer = this.factory.createXMLStreamWriter(outputWriter);
        writer = new IndentingXMLStreamWriter(writer);
        try {
            this.write(writer);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Result outputResult) throws XMLStreamException, MarshallerException {
        XMLStreamWriter writer = this.factory.createXMLStreamWriter(outputResult);
        writer = new IndentingXMLStreamWriter(writer);
        try {
            this.write(writer);
        }
        finally {
            writer.close();
        }
    }

    private void writeRootAttributes(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("xmlns", this.document.getRootElementURI(), this.namespacePrefix, this.document.getRootElementURI());
        writer.writeAttribute("xmlns", "http://www.w3.org/2001/XMLSchema", "xs", "http://www.w3.org/2001/XMLSchema");
        writer.writeAttribute("xmlns", "http://www.w3.org/2001/XMLSchema-instance", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.document.getSchemaLocation() != null) {
            writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.document.getSchemaLocation());
        }
    }

    private String findEncoding() {
        if (this.document.getEncoding() != null) {
            return this.document.getEncoding();
        }
        if (this.getOptions() != null && this.getOptions().getEncoding() != null) {
            return this.getOptions().getEncoding();
        }
        return null;
    }

    private void write(XMLStreamWriter writer) throws XMLStreamException {
        this.setup();
        if (this.document.isXMLDeclaration()) {
            String encoding = this.findEncoding();
            if (encoding != null) {
                writer.writeStartDocument(encoding, this.document.getXMLVersion());
            } else {
                writer.writeStartDocument(this.document.getXMLVersion());
            }
        }
        if (this.document.getRootElementName() != null) {
            writer.writeStartElement(this.namespacePrefix, this.document.getRootElementName(), this.document.getRootElementURI());
            this.writeRootAttributes(writer);
        }
        EventVisitor visitor = new EventVisitor(writer);
        ((PlasmaDataObject)this.document.getRootObject()).accept(visitor);
        if (this.document.getRootElementName() != null) {
            writer.writeEndElement();
        }
        writer.writeEndDocument();
    }

    @Override
    protected String fromObject(Type sourceType, Object value) {
        return DataConverter.INSTANCE.toString(sourceType, value);
    }

    private void writeNonContainmentReferenceContent(XMLStreamWriter writer, DataObject dataObject, DataObject source, Property sourceProperty, PlasmaType targetType, PlasmaType sourceType, int level) throws IOException, XMLStreamException {
        writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", this.namespacePrefix + ":" + SchemaUtil.getNonContainmentReferenceName(targetType));
        writer.writeAttribute(SchemaUtil.getSerializationAttributeName(), ((PlasmaDataObject)dataObject).getUUIDAsString());
    }

    private void writeContent(XMLStreamWriter writer, DataObject dataObject, DataObject source, Property sourceProperty, PlasmaType targetType, PlasmaType sourceType, int level) throws IOException, XMLStreamException {
        PlasmaProperty prop;
        int externKeyCount = 0;
        for (Property property : targetType.getProperties()) {
            prop = (PlasmaProperty)property;
            if (!prop.isKey(KeyType.external)) continue;
            ++externKeyCount;
        }
        if (externKeyCount > 0) {
            writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", this.namespacePrefix + ":" + SchemaUtil.getContainmentReferenceName(targetType));
        }
        writer.writeAttribute(SchemaUtil.getSerializationAttributeName(), ((PlasmaDataObject)dataObject).getUUIDAsString());
        for (Property property : targetType.getProperties()) {
            Object value;
            prop = (PlasmaProperty)property;
            if (!prop.getType().isDataType() || !prop.isXMLAttribute() || (value = dataObject.get(prop)) == null) continue;
            writer.writeAttribute(this.helper.getLocalName(prop), this.fromObject(prop.getType(), value));
        }
        List<Property> list = targetType.getProperties();
        PlasmaProperty[] properties = new PlasmaProperty[list.size()];
        list.toArray(properties);
        Arrays.sort(properties, this.comparator);
        for (PlasmaProperty property : properties) {
            Object value;
            PlasmaProperty prop2 = property;
            if (!prop2.getType().isDataType() || prop2.isXMLAttribute() || (value = dataObject.get(prop2)) == null) continue;
            writer.writeStartElement(this.helper.getLocalName(prop2));
            writer.writeCharacters(this.fromObject(prop2.getType(), value));
            writer.writeEndElement();
        }
    }

    class PropertyComparator
    implements Comparator<PlasmaProperty> {
        PropertyComparator() {
        }

        @Override
        public int compare(PlasmaProperty p1, PlasmaProperty p2) {
            if (p1.getSort() != null && p2.getSort() != null) {
                return p1.getSort().getKey().compareTo(p2.getSort().getKey());
            }
            return p1.getName().compareTo(p2.getName());
        }
    }

    class EventVisitor
    implements PlasmaDataGraphEventVisitor {
        private XMLStreamWriter writer;
        private HashSet<PlasmaDataObject> nonContainmentObjects = new HashSet();

        public EventVisitor(XMLStreamWriter writer) {
            this.writer = writer;
        }

        @Override
        public void start(PlasmaDataObject target, PlasmaDataObject source, String sourcePropertyName, int level) {
            try {
                PlasmaType sourceType = null;
                PlasmaProperty sourceProperty = null;
                if (source != null) {
                    if (this.nonContainmentObjects.contains(source)) {
                        this.nonContainmentObjects.add(target);
                        return;
                    }
                    sourceType = (PlasmaType)source.getType();
                    sourceProperty = (PlasmaProperty)sourceType.getProperty(sourcePropertyName);
                }
                PlasmaType targetType = (PlasmaType)target.getType();
                if (log.isDebugEnabled()) {
                    if (source == null) {
                        log.debug((Object)("start: " + targetType.getName() + "(" + ((PlasmaNode)((Object)target)).getUUIDAsString() + ")"));
                    } else {
                        log.debug((Object)("start: " + sourceType.getName() + "(" + ((PlasmaNode)((Object)source)).getUUIDAsString() + ")." + sourceProperty.getName() + "->" + targetType.getName() + "(" + ((PlasmaNode)((Object)target)).getUUIDAsString() + ")"));
                    }
                }
                if (source != null) {
                    this.writer.writeStartElement(StreamMarshaller.this.helper.getLocalName(sourceProperty));
                } else if (StreamMarshaller.this.document.getRootElementName() == null) {
                    this.writer.writeStartElement(StreamMarshaller.this.namespacePrefix, StreamMarshaller.this.helper.getLocalName(targetType), StreamMarshaller.this.document.getRootElementURI());
                    StreamMarshaller.this.writeRootAttributes(this.writer);
                } else {
                    this.writer.writeStartElement(StreamMarshaller.this.helper.getLocalName(targetType));
                }
                if (source == null || source.contains(target)) {
                    StreamMarshaller.this.writeContent(this.writer, target, source, sourceProperty, targetType, sourceType, level);
                } else {
                    this.nonContainmentObjects.add(target);
                    StreamMarshaller.this.writeNonContainmentReferenceContent(this.writer, target, source, sourceProperty, targetType, sourceType, level);
                }
            }
            catch (XMLStreamException e) {
                throw new MarshallerRuntimeException(e);
            }
            catch (IOException e) {
                throw new MarshallerRuntimeException(e);
            }
        }

        @Override
        public void end(PlasmaDataObject target, PlasmaDataObject source, String sourcePropertyName, int level) {
            try {
                if (source != null && this.nonContainmentObjects.contains(source)) {
                    this.nonContainmentObjects.remove(target);
                    return;
                }
                this.writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new MarshallerRuntimeException(e);
            }
        }
    }
}

