/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.SchemaConverter;
import org.plasma.provisioning.xsd.SDOXSchemaConverter;
import org.plasma.provisioning.xsd.XSDSchemaConverter;
import org.plasma.xml.schema.OpenAttrs;
import org.plasma.xml.schema.Schema;

public class SchemaProvisioningModelAssembler {
    private static Log log = LogFactory.getLog(SchemaProvisioningModelAssembler.class);
    private SchemaConverter processor;

    private SchemaProvisioningModelAssembler() {
    }

    public SchemaProvisioningModelAssembler(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        QName sdoxNamespace = this.findOpenAttributeQNameByValue("commonj.sdo/xml", schema);
        this.processor = sdoxNamespace != null ? new SDOXSchemaConverter(schema, destNamespaceURI, destNamespacePrefix) : new XSDSchemaConverter(schema, destNamespaceURI, destNamespacePrefix);
    }

    private QName findOpenAttributeQNameByValue(String value, OpenAttrs attrs) {
        for (QName key : attrs.getOtherAttributes().keySet()) {
            String s = attrs.getOtherAttributes().get(key);
            if (s == null || !s.equals(value)) continue;
            return key;
        }
        return null;
    }

    public Model getModel() {
        return this.processor.buildModel();
    }
}

