/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.plasma.query.QueryException;
import org.plasma.query.model.Clause;
import org.plasma.query.model.From;
import org.plasma.query.model.GroupBy;
import org.plasma.query.model.OrderBy;
import org.plasma.query.model.Select;
import org.plasma.query.model.Where;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Query", propOrder={"clauses", "startRange", "endRange"})
@XmlRootElement(name="Query")
public class Query
implements org.plasma.query.Query {
    @XmlElement(name="Clause", required=true)
    protected List<Clause> clauses;
    @XmlElement(namespace="", defaultValue="0")
    protected Integer startRange;
    @XmlElement(namespace="", defaultValue="0")
    protected Integer endRange;
    @XmlAttribute
    protected String name;

    public Query() {
    }

    public Query(Select select, From from) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
    }

    public Query(Select select, From from, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(groupBy));
    }

    public Query(Select select, From from, Where where) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
    }

    public Query(Select select, From from, Where where, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
        this.getClauses().add(new Clause(groupBy));
    }

    public Query(Select select, From from, OrderBy orderBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(orderBy));
    }

    public Query(Select select, From from, OrderBy orderBy, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(orderBy));
        this.getClauses().add(new Clause(groupBy));
    }

    public Query(Select select, From from, Where where, OrderBy orderBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
        this.getClauses().add(new Clause(orderBy));
    }

    public Query(Select select, From from, Where where, OrderBy orderBy, GroupBy groupBy) {
        this();
        this.getClauses().add(new Clause(select));
        this.getClauses().add(new Clause(from));
        this.getClauses().add(new Clause(where));
        this.getClauses().add(new Clause(orderBy));
        this.getClauses().add(new Clause(groupBy));
    }

    @Override
    public Query getModel() {
        return this;
    }

    public List<Clause> getClauses() {
        if (this.clauses == null) {
            this.clauses = new ArrayList<Clause>();
        }
        return this.clauses;
    }

    @Override
    public Integer getStartRange() {
        if (this.startRange != null) {
            return this.startRange;
        }
        return null;
    }

    @Override
    public void setStartRange(Integer value) {
        this.startRange = value;
    }

    @Override
    public Integer getEndRange() {
        if (this.endRange != null) {
            return this.endRange;
        }
        return null;
    }

    @Override
    public void setEndRange(Integer value) {
        this.endRange = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            for (int i = 0; i < this.getClauses().size(); ++i) {
                this.getClauses().get(i).accept(visitor);
            }
        }
        visitor.end(this);
    }

    @Override
    public Select getSelectClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Select select = this.getClauses().get(i).getSelect();
            if (select == null) continue;
            return select;
        }
        throw new QueryException("could not get Select clause");
    }

    @Override
    public From getFromClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            From from = this.getClauses().get(i).getFrom();
            if (from == null) continue;
            return from;
        }
        throw new QueryException("could not get From clause");
    }

    @Override
    public Where getWhereClause() {
        Where result = this.findWhereClause();
        if (result == null) {
            throw new QueryException("could not get Where clause");
        }
        return result;
    }

    @Override
    public Where findWhereClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            Where where = this.getClauses().get(i).getWhere();
            if (where == null) continue;
            return where;
        }
        return null;
    }

    @Override
    public void clearOrderByClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            OrderBy orderBy = this.getClauses().get(i).getOrderBy();
            if (orderBy == null) continue;
            this.getClauses().remove(this.getClauses().get(i));
        }
    }

    @Override
    public OrderBy findOrderByClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            OrderBy orderBy = this.getClauses().get(i).getOrderBy();
            if (orderBy == null) continue;
            return orderBy;
        }
        return null;
    }

    @Override
    public GroupBy findGroupByClause() {
        for (int i = 0; i < this.getClauses().size(); ++i) {
            GroupBy groupBy = this.getClauses().get(i).getGroupBy();
            if (groupBy == null) continue;
            return groupBy;
        }
        return null;
    }
}

