/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.client;

import commonj.sdo.DataGraph;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.exception.UserException;
import org.plasma.query.MaxWildcardsExceededException;
import org.plasma.query.Query;
import org.plasma.sdo.access.InvalidSnapshotException;
import org.plasma.sdo.access.LockedEntityException;
import org.plasma.sdo.access.MaxResultsExceededException;
import org.plasma.sdo.access.client.DataAccessClient;
import org.plasma.sdo.access.client.PojoDataAccessClient;

public class SDODataAccessClient
implements DataAccessClient {
    private static Log log = LogFactory.getLog(SDODataAccessClient.class);
    private DataAccessClient serviceProxy;

    public SDODataAccessClient() {
        this.serviceProxy = new PojoDataAccessClient();
    }

    public SDODataAccessClient(DataAccessClient proxy) {
        this.serviceProxy = proxy;
    }

    @Override
    public DataGraph[] find(Query query) {
        DataGraph[] results = null;
        try {
            results = this.serviceProxy.find(query);
        }
        catch (MaxResultsExceededException e) {
            throw new UserException("error_severity_fatal", "error_type_user_input", "error_message_max_results_exceeded", new Object[]{new Integer(e.getMaxResults())}, "max results exceeded");
        }
        catch (MaxWildcardsExceededException e) {
            throw new UserException("error_severity_fatal", "error_type_user_input", "error_message_max_wildcards_exceeded", "max wildcards exceeded");
        }
        return results;
    }

    @Override
    public DataGraph[] find(Query query, int maxResults) {
        DataGraph[] results = null;
        try {
            results = this.serviceProxy.find(query, maxResults);
        }
        catch (MaxResultsExceededException e) {
            throw new UserException("error_severity_fatal", "error_type_user_input", "error_message_max_results_exceeded", new Object[]{new Integer(e.getMaxResults())}, "max results exceeded");
        }
        catch (MaxWildcardsExceededException e) {
            throw new UserException("error_severity_fatal", "error_type_user_input", "error_message_max_wildcards_exceeded", "max wildcards exceeded");
        }
        return results;
    }

    @Override
    public List<DataGraph[]> find(Query[] queries) {
        List<DataGraph[]> valueList = null;
        try {
            valueList = this.serviceProxy.find(queries);
        }
        catch (MaxResultsExceededException e) {
            throw new UserException("error_severity_fatal", "error_type_user_input", "error_message_max_results_exceeded", new Object[]{new Integer(e.getMaxResults())}, "max results exceeded");
        }
        catch (MaxWildcardsExceededException e) {
            throw new UserException("error_severity_fatal", "error_type_user_input", "error_message_max_wildcards_exceeded", "max wildcards exceeded");
        }
        return valueList;
    }

    @Override
    public int count(Query query) {
        return this.serviceProxy.count(query);
    }

    @Override
    public int[] count(Query[] queries) {
        return this.serviceProxy.count(queries);
    }

    @Override
    public void commit(DataGraph dataGraph, String username) {
        try {
            this.serviceProxy.commit(dataGraph, username);
        }
        catch (LockedEntityException e) {
            throw new UserException("error_severity_fatal", "error_type_user_concurrency", "error_message_record_locked", new Object[]{e.getUserName(), e.getLockedDate()}, "locked entity");
        }
        catch (InvalidSnapshotException e) {
            throw new UserException("error_severity_fatal", "error_type_user_concurrency", "error_message_invalid_snapshot", new Object[]{e.getUpdatedByUser(), e.getUpdatedDate()}, "invalid query snapshot - entity already updated by another user");
        }
    }

    @Override
    public void commit(DataGraph[] dataGraphs, String username) {
        try {
            this.serviceProxy.commit(dataGraphs, username);
        }
        catch (LockedEntityException e) {
            throw new UserException("error_severity_fatal", "error_type_user_concurrency", "error_message_record_locked", new Object[]{e.getUserName(), e.getLockedDate()}, "locked entity");
        }
        catch (InvalidSnapshotException e) {
            throw new UserException("error_severity_fatal", "error_type_user_concurrency", "error_message_invalid_snapshot", new Object[]{e.getUpdatedByUser(), e.getUpdatedDate()}, "invalid query snapshot - entity already updated by another user");
        }
    }
}

