/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.Property;
import org.plasma.query.model.WildcardPathElement;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;

public abstract class DataComparator {
    private static Log log = LogFactory.getLog(DataComparator.class);
    protected static int ASCENDING = 1;
    protected static int DESCENDING = 2;
    protected List<PathInfo> paths = new ArrayList<PathInfo>();

    public void addAscending(Property property) {
        this.paths.add(new PathInfo(property, ASCENDING));
    }

    public void addDescending(Property property) {
        this.paths.add(new PathInfo(property, DESCENDING));
    }

    protected int compare(DataObject vo1, DataObject vo2) {
        for (PathInfo info : this.paths) {
            Object ep1 = this.findEndpoint(vo1, info.property, info.property.getPath(), 0);
            Object ep2 = this.findEndpoint(vo2, info.property, info.property.getPath(), 0);
            int result = info.direction == ASCENDING ? this.comp(ep1, ep2) : this.comp(ep2, ep1);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    protected int comp(Object ep1, Object ep2) {
        int result = 0;
        if (ep1 != null && ep2 != null) {
            if (ep1 instanceof Comparable) {
                result = ((Comparable)ep1).compareTo(ep2);
            } else {
                log.warn((Object)("endpoint class not comparable, " + ep1.getClass().getName()));
            }
        } else if (ep1 == null && ep2 != null) {
            result = -1;
        } else if (ep2 == null && ep1 != null) {
            result = 1;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object findEndpoint(DataObject targetObject, Property property, Path path, int pathIndex) {
        PlasmaType targetType = (PlasmaType)targetObject.getType();
        if (path != null && pathIndex < path.getPathNodes().size()) {
            AbstractPathElement pathElem = path.getPathNodes().get(pathIndex).getPathElement();
            if (pathElem instanceof WildcardPathElement) {
                throw new DataAccessException("wildcard path elements applicable for 'Select' clause paths only, not 'Where' clause paths");
            }
            String elem = ((PathElement)pathElem).getValue();
            PlasmaProperty prop = (PlasmaProperty)targetType.getProperty(elem);
            if (!targetObject.isSet(prop)) return null;
            if (!prop.isMany()) {
                DataObject next = targetObject.getDataObject(prop);
                return this.findEndpoint(next, property, path, pathIndex + 1);
            }
            List list = targetObject.getList(prop);
            if (list.size() == 1) {
                DataObject next = (DataObject)list.get(0);
                return this.findEndpoint(next, property, path, pathIndex + 1);
            }
            if (list.size() <= 1) return null;
            log.warn((Object)("ordering not supported across collection properties with multiple values present - " + targetType.toString() + "." + prop.getName() + " is a collection property - ignoring all but first value"));
            return null;
        }
        PlasmaProperty endpointProp = (PlasmaProperty)targetType.getProperty(property.getName());
        if (!endpointProp.getType().isDataType()) {
            throw new DataAccessException("expected datatype property for, " + endpointProp);
        }
        if (!targetObject.isSet(endpointProp)) return null;
        if (!endpointProp.isMany()) {
            return targetObject.get(endpointProp);
        }
        List list = targetObject.getList(endpointProp);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() <= 1) return null;
        log.warn((Object)("ordering not supported across collection properties with multiple values present - " + targetType.toString() + "." + endpointProp.getName() + " is a collection property - ignoring all but first value"));
        return null;
    }

    protected class PathInfo {
        public Property property;
        public int direction;

        private PathInfo() {
        }

        public PathInfo(Property property, int direction) {
            this.property = property;
            this.direction = direction;
        }
    }
}

