/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.jdo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.NonExistantNamespaceException;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.KeyType;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.sdo.access.provider.jdo.Class_;
import org.plasma.sdo.access.provider.jdo.Collection;
import org.plasma.sdo.access.provider.jdo.Column;
import org.plasma.sdo.access.provider.jdo.Discriminator;
import org.plasma.sdo.access.provider.jdo.Field;
import org.plasma.sdo.access.provider.jdo.Inheritance;
import org.plasma.sdo.access.provider.jdo.Jdo;
import org.plasma.sdo.access.provider.jdo.Join;
import org.plasma.sdo.access.provider.jdo.Package_;
import org.plasma.sdo.access.provider.jdo.Version;

public class JDOModelAssembler {
    private static Log log = LogFactory.getLog(JDOModelAssembler.class);
    private boolean multipleInheritance = true;
    private Model pkgs;
    private Jdo result;
    private Map<String, List<Class>> namespaceMap = new HashMap<String, List<Class>>();
    private Map<String, Class> entityMap = new HashMap<String, Class>();

    public JDOModelAssembler(Model pkgs) {
        this.pkgs = pkgs;
    }

    public Jdo getJdo() {
        if (this.result == null) {
            this.buildJdoModel();
        }
        return this.result;
    }

    private Jdo buildJdoModel() {
        List<Class> defs;
        for (Package pkg : this.pkgs.getPackages()) {
            for (Class clss : pkg.getClazzs()) {
                defs = this.namespaceMap.get(clss.getUri());
                if (defs == null) {
                    defs = new ArrayList<Class>();
                    this.namespaceMap.put(clss.getUri(), defs);
                }
                defs.add(clss);
                this.entityMap.put(clss.getUri() + "#" + clss.getName(), clss);
            }
        }
        this.result = new Jdo();
        for (String key : this.namespaceMap.keySet()) {
            String packageName = null;
            try {
                packageName = PlasmaConfig.getInstance().getServiceImplementationPackageName(DataAccessProviderName.JDO, key);
            }
            catch (NonExistantNamespaceException e) {
                continue;
            }
            Package_ pkg = new Package_();
            pkg.setName(packageName);
            this.result.getExtensionsAndPackagesAndQueries().add(pkg);
            defs = this.namespaceMap.get(key);
            for (Class provisioningClass : defs) {
                if (provisioningClass.isAbstract()) continue;
                Class_ cls = this.buildClass(provisioningClass);
                pkg.getInterfacesAndClazzsAndSequences().add(cls);
                if (provisioningClass.isAbstract()) continue;
                for (Property pdef : provisioningClass.getProperties()) {
                    Field field = this.buildField(provisioningClass, null, pdef);
                    cls.getFields().add(field);
                }
                this.inherit(provisioningClass, provisioningClass, cls);
            }
        }
        Object[] objs = new Object[this.result.getExtensionsAndPackagesAndQueries().size()];
        this.result.getExtensionsAndPackagesAndQueries().toArray(objs);
        for (Object obj : objs) {
            Package_ pkg = (Package_)obj;
            if (pkg.getInterfacesAndClazzsAndSequences().size() != 0) continue;
            this.result.getExtensionsAndPackagesAndQueries().remove(pkg);
        }
        return this.result;
    }

    private void inherit(Class def, Class baseDef, Class_ target) {
        for (ClassRef baseEntity : baseDef.getSuperClasses()) {
            Class nextBaseDef = this.entityMap.get(baseEntity.getUri() + "#" + baseEntity.getName());
            if (this.hasPhysicalName(nextBaseDef)) continue;
            for (Property pdef : nextBaseDef.getProperties()) {
                Field field = this.buildField(def, nextBaseDef, pdef);
                target.getFields().add(field);
            }
            this.inherit(def, nextBaseDef, target);
        }
    }

    private Class_ buildClass(Class sourceClass) {
        String className = PlasmaConfig.getInstance().getServiceImplementationClassName(DataAccessProviderName.JDO, sourceClass.getUri(), sourceClass.getName());
        Class_ cls = new Class_();
        cls.setName(className);
        Version version = new Version();
        version.setStrategy("none");
        cls.setVersion(version);
        if (sourceClass.isAbstract()) {
            // empty if block
        }
        if (!this.hasPhysicalName(sourceClass)) {
            Inheritance inheritance = new Inheritance();
            inheritance.setStrategy("subclass-table");
            cls.setInheritance(inheritance);
            cls.setObjectidClass(sourceClass.getName() + "AppId");
            return cls;
        }
        cls.setTable(sourceClass.getAlias().getPhysicalName());
        if (!this.isBaseEntity(sourceClass)) {
            Inheritance inheritance = new Inheritance();
            cls.setInheritance(inheritance);
            if (!this.hasPhysicalBaseEntity(sourceClass)) {
                Discriminator discriminator = new Discriminator();
                discriminator.setStrategy("final");
                inheritance.setDiscriminator(discriminator);
                cls.setObjectidClass(sourceClass.getName() + "AppId");
            } else {
                inheritance.setStrategy("new-table");
                Join join = new Join();
                join.setDeleteAction("restrict");
                inheritance.setJoin(join);
                Column joinColumn = new Column();
                join.getColumns().add(joinColumn);
                ClassRef baseRef = this.getPhysicalBaseEntityRef(sourceClass);
                String baseKey = baseRef.getUri() + "#" + baseRef.getName();
                Class base = this.entityMap.get(baseRef.getUri() + "#" + baseRef.getName());
                if (base.getAlias() == null || base.getAlias().getPhysicalName() == null || base.getAlias().getPhysicalName().trim().length() == 0) {
                    throw new IllegalStateException("expected physical name for base entity '" + baseKey + "'");
                }
                joinColumn.setName(base.getAlias().getPhysicalName());
                String parent = base.getAlias().getPhysicalName() + ".";
                Property[] basePriKeys = this.getPriKeys(base);
                if (basePriKeys.length == 0) {
                    throw new IllegalStateException("no primary key properties found for base entity '" + baseKey + "'");
                }
                if (basePriKeys.length > 1) {
                    throw new IllegalStateException("multiple primary key properties found for base entity '" + baseKey + "'");
                }
                parent = parent + basePriKeys[0].getAlias().getPhysicalName();
                joinColumn.setTarget(parent);
            }
        } else {
            cls.setObjectidClass(sourceClass.getName() + "AppId");
        }
        return cls;
    }

    private Field buildField(Class def, Class baseDef, Property pdef) {
        if (pdef.getType() instanceof ClassRef) {
            if (!pdef.isMany()) {
                return this.buildSingularReferenceField(def, baseDef, pdef);
            }
            return this.buildMultiReferenceField(def, baseDef, pdef);
        }
        return this.buildDataField(def, baseDef, pdef);
    }

    private Field buildSingularReferenceField(Class def, Class baseDef, Property pdef) {
        Field field = new Field();
        if (baseDef == null) {
            field.setName(this.buildFieldName(def, pdef));
        } else {
            field.setName(this.buildQualifiedFieldName(def, baseDef, pdef));
        }
        field.setPersistenceModifier("persistent");
        field.setDefaultFetchGroup("false");
        field.setDeleteAction("restrict");
        field.setIndexed("true");
        if (this.hasPhysicalName(def)) {
            Column column = new Column();
            if (!this.hasPhysicalName(pdef)) {
                throw new ProvisioningException("Expected physical name for singular property " + def.getUri() + "#" + def.getName() + "." + pdef.getName());
            }
            column.setName(pdef.getAlias().getPhysicalName());
            field.getColumns().add(column);
        }
        return field;
    }

    private Field buildMultiReferenceField(Class clss, Class baseClss, Property prop) {
        Field field = new Field();
        if (baseClss == null) {
            field.setName(this.buildFieldName(clss, prop));
        } else if (!baseClss.isAbstract()) {
            field.setName(this.buildQualifiedFieldName(clss, baseClss, prop));
        } else {
            field.setName(this.buildFieldName(clss, prop));
        }
        field.setDefaultFetchGroup("false");
        String oppositeName = prop.getOpposite();
        if (oppositeName != null) {
            field.setMappedBy("" + oppositeName);
        }
        Collection collection = new Collection();
        ClassRef propTypeRef = (ClassRef)prop.getType();
        Class propTypeClass = this.entityMap.get(propTypeRef.getUri() + "#" + propTypeRef.getName());
        NamespaceProvisioning provisioning = PlasmaConfig.getInstance().getProvisioningByNamespaceURI(DataAccessProviderName.JDO, propTypeClass.getUri());
        collection.setElementType(provisioning.getPackageName() + "." + propTypeClass.getName());
        field.setCollection(collection);
        return field;
    }

    private Field buildDataField(Class def, Class baseDef, Property pdef) {
        Field field = new Field();
        if (baseDef == null) {
            field.setName(this.buildFieldName(def, pdef));
        } else {
            field.setName(this.buildQualifiedFieldName(def, baseDef, pdef));
        }
        field.setNullValue("default");
        field.setDefaultFetchGroup("false");
        if (pdef.getKey() != null && pdef.getKey().getType().ordinal() == KeyType.PRIMARY.ordinal()) {
            field.setPrimaryKey("true");
        }
        if (this.hasPhysicalName(def)) {
            Long maxLength;
            Column column = new Column();
            column.setName(pdef.getAlias().getPhysicalName());
            column.setDefaultValue("BOGUS_DEFAULT_VALUE");
            if (pdef.getValueConstraint() != null && pdef.getValueConstraint().getMaxLength() != null && (maxLength = Long.valueOf(pdef.getValueConstraint().getMaxLength())) > 4000L) {
                column.setJdbcType("clob");
            }
            field.getColumns().add(column);
        }
        return field;
    }

    private String buildFieldName(Class def, Property pdef) {
        String result = pdef.isMany() ? "" + pdef.getName() + "" : "" + pdef.getName();
        return result;
    }

    private String buildQualifiedFieldName(Class def, Class baseDef, Property pdef) {
        String result;
        if (pdef.isMany()) {
            NamespaceProvisioning baseProvisioning = PlasmaConfig.getInstance().getProvisioningByNamespaceURI(DataAccessProviderName.JDO, baseDef.getUri());
            result = baseProvisioning.getPackageName() + "." + baseDef.getName() + "." + "" + pdef.getName() + "";
        } else {
            NamespaceProvisioning baseProvisioning = PlasmaConfig.getInstance().getProvisioningByNamespaceURI(DataAccessProviderName.JDO, baseDef.getUri());
            result = !this.multipleInheritance ? baseProvisioning.getPackageName() + "." + baseDef.getName() + "." + "" + pdef.getName() : "" + pdef.getName();
        }
        return result;
    }

    private boolean hasPhysicalName(Class cls) {
        return cls.getAlias() != null && cls.getAlias().getPhysicalName() != null && cls.getAlias().getPhysicalName().trim().length() > 0;
    }

    private boolean hasPhysicalName(Property prop) {
        return prop.getAlias() != null && prop.getAlias().getPhysicalName() != null && prop.getAlias().getPhysicalName().trim().length() > 0;
    }

    private boolean isBaseEntity(Class def) {
        for (Class def2 : this.entityMap.values()) {
            for (ClassRef ref : def2.getSuperClasses()) {
                if (!ref.getUri().equals(def.getUri()) || !ref.getName().equals(def.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPhysicalBaseEntity(Class def) {
        for (ClassRef ref : def.getSuperClasses()) {
            Class base = this.entityMap.get(ref.getUri() + "#" + ref.getName());
            if (!this.hasPhysicalName(base)) continue;
            return true;
        }
        return false;
    }

    private ClassRef getPhysicalBaseEntityRef(Class def) {
        for (ClassRef ref : def.getSuperClasses()) {
            Class base = this.entityMap.get(ref.getUri() + "#" + ref.getName());
            if (!this.hasPhysicalName(base)) continue;
            return ref;
        }
        return null;
    }

    private boolean hasPriKey(Class def) {
        if (def.getProperties() != null) {
            for (Property prop : def.getProperties()) {
                if (prop.getKey() == null || prop.getKey().getType().ordinal() != KeyType.PRIMARY.ordinal()) continue;
                return true;
            }
        }
        return false;
    }

    private Property[] getPriKeys(Class def) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (def.getProperties() != null) {
            for (Property prop : def.getProperties()) {
                if (prop.getKey() == null || prop.getKey().getType().ordinal() != KeyType.PRIMARY.ordinal()) continue;
                list.add(prop);
            }
        }
        Property[] result = new Property[list.size()];
        list.toArray(result);
        return result;
    }
}

