/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Type;
import java.util.UUID;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataGraphEventVisitor;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.core.CoreChangeSummary;
import org.plasma.sdo.core.CorePathAssembler;
import org.plasma.sdo.helper.PlasmaDataFactory;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class CoreDataGraph
implements PlasmaDataGraph {
    private static final long serialVersionUID = 1L;
    private Object id;
    private PlasmaDataObject rootObject;
    private CoreChangeSummary changeSummary = new CoreChangeSummary(this);

    public CoreDataGraph() {
    }

    public CoreDataGraph(PlasmaDataObject root) {
        this();
        this.rootObject = root;
        root.setDataGraph(this);
    }

    public String toString() {
        return this.rootObject.toString();
    }

    @Override
    public UUID getUUID() {
        return this.rootObject.getUUID();
    }

    @Override
    public String getUUIDAsString() {
        return this.rootObject.getUUIDAsString();
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public DataObject createRootObject(String namespaceURI, String typeName) {
        if (this.rootObject != null) {
            throw new IllegalStateException("a root data object already exists for this data graph");
        }
        this.rootObject = (PlasmaDataObject)PlasmaDataFactory.INSTANCE.create(namespaceURI, typeName);
        PlasmaDataObject root = ((PlasmaNode)((Object)this.rootObject)).getDataObject();
        root.setDataGraph(this);
        this.changeSummary.created(root);
        return this.rootObject;
    }

    @Override
    public DataObject createRootObject(Type type) {
        if (this.rootObject != null) {
            throw new IllegalStateException("a root data object already exists for this data graph");
        }
        this.rootObject = (PlasmaDataObject)PlasmaDataFactory.INSTANCE.create(type);
        PlasmaDataObject root = ((PlasmaNode)((Object)this.rootObject)).getDataObject();
        root.setDataGraph(this);
        this.changeSummary.created(root);
        return this.rootObject;
    }

    @Override
    public ChangeSummary getChangeSummary() {
        return this.changeSummary;
    }

    @Override
    public DataObject getRootObject() {
        return this.rootObject;
    }

    @Override
    public DataObject removeRootObject() {
        PlasmaDataObject oldRoot = this.rootObject;
        ((PlasmaNode)((Object)this.rootObject)).getDataObject().setDataGraph(null);
        this.rootObject = null;
        this.changeSummary = null;
        return oldRoot;
    }

    @Override
    public Type getType(String uri, String typeName) {
        return PlasmaTypeHelper.INSTANCE.getType(uri, typeName);
    }

    @Override
    public String getPath(DataObject dataObject) {
        CorePathAssembler visitor = new CorePathAssembler(dataObject);
        ((PlasmaNode)((Object)this.rootObject)).accept(visitor);
        return visitor.getMinimumPathString();
    }

    @Override
    public void accept(PlasmaDataGraphVisitor visitor) {
        ((PlasmaNode)((Object)this.rootObject)).accept(visitor);
    }

    @Override
    public void acceptDepthFirst(PlasmaDataGraphVisitor visitor) {
        ((PlasmaNode)((Object)this.rootObject)).acceptDepthFirst(visitor);
    }

    @Override
    public void accept(PlasmaDataGraphEventVisitor visitor) {
        ((PlasmaNode)((Object)this.rootObject)).accept(visitor);
    }

    @Override
    public String dump() {
        return this.rootObject.dump();
    }

    @Override
    public String dumpDepthFirst() {
        return this.rootObject.dumpDepthFirst();
    }
}

