/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import fUML.Syntax.Classes.Kernel.VisibilityKind;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Class_;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.TypeBinding;
import org.plasma.sdo.Alias;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.DataType;
import org.plasma.sdo.Derivation;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.core.CoreProperty;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.ConcurrencyType;
import org.plasma.sdo.profile.ConcurrentDataFlavor;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.profile.SDOAlias;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.Comment;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.Property;

public class CoreType
implements PlasmaType {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(CoreType.class);
    private static final List<Type> EMPTY_TYPE_LIST = new ArrayList<Type>();
    private String name;
    private String physicalName;
    private String localName;
    private QName qname;
    private int qnameHashCode;
    private Classifier classifier;
    private List<Type> baseTypes;
    private List<Type> subTypes;
    private Map<String, PlasmaProperty> declaredPropertiesMap;
    private Map<PlasmaProperty, Object> instancePropertiesMap;
    private List<commonj.sdo.Property> declaredPropertiesList;
    private String artifactURI;
    private String namespaceURI;

    private CoreType() {
    }

    public CoreType(String uri, String typeName) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("namespace URI is a required argument");
        }
        Namespace namespace = PlasmaConfig.getInstance().getSDONamespaceByURI(uri);
        this.artifactURI = namespace.getArtifact();
        this.namespaceURI = namespace.getUri();
        this.name = typeName;
        this.qname = new QName(this.namespaceURI, this.name);
        this.qnameHashCode = this.qname.hashCode();
        String lookupName = this.name;
        TypeBinding binding = PlasmaConfig.getInstance().findTypeBinding(uri, typeName);
        if (binding != null) {
            if (binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
                this.name = binding.getLogicalName().trim();
                lookupName = binding.getType();
                PlasmaConfig.getInstance().remapTypeBinding(uri, binding);
            }
            if (binding.getPhysicalName() != null && binding.getPhysicalName().trim().length() > 0) {
                this.physicalName = binding.getPhysicalName().trim();
            }
            if (binding.getLocalName() != null && binding.getLocalName().trim().length() > 0) {
                this.localName = binding.getLocalName().trim();
            }
        }
        String artifactQualifiedName = this.artifactURI + "#" + lookupName;
        org.modeldriven.fuml.repository.Classifier classifier = PlasmaRepository.getInstance().getClassifier(artifactQualifiedName);
        this.classifier = Class_.class.isAssignableFrom(classifier.getClass()) ? new org.plasma.sdo.repository.Class_((Class_)classifier) : new Classifier(classifier);
    }

    public int hashCode() {
        return this.qnameHashCode;
    }

    public boolean equals(Object other) {
        if (other != null) {
            CoreType otherType = (CoreType)other;
            return this.qnameHashCode == otherType.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.qname.toString();
    }

    private void lazyLoadProperties() {
        this.declaredPropertiesMap = new HashMap<String, PlasmaProperty>();
        this.declaredPropertiesList = new ArrayList<commonj.sdo.Property>();
        this.instancePropertiesMap = new HashMap<PlasmaProperty, Object>();
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_STRING_PHYSICAL_NAME, this.classifier.getPhysicalName());
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_STRING_NAMESPACE_URI, this.classifier.getNamespaceURI());
        if (this.classifier.getComments() != null) {
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION, this.classifier.getComments());
        }
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_STRING_UUID, UUID.randomUUID().toString());
        VisibilityKind visibility = VisibilityKind.public_;
        if (this.classifier.getVisibility() != null) {
            visibility = this.classifier.getVisibility();
        }
        this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_VISIBILITY, visibility);
        List<org.modeldriven.fuml.repository.Property> properties = this.classifier.getDeclaredProperties();
        for (org.modeldriven.fuml.repository.Property prop : properties) {
            Type propertyType = null;
            if (!prop.isDataType()) {
                org.modeldriven.fuml.repository.Property oppositeProperty = prop.getOpposite();
                if (oppositeProperty != null) {
                    Class_ oppositeClass = oppositeProperty.getClass_();
                    String oppositeClassNamespaceURI = this.classifier.getNamespaceURI((org.modeldriven.fuml.repository.Classifier)oppositeClass);
                    propertyType = PlasmaTypeHelper.INSTANCE.getType(oppositeClassNamespaceURI, oppositeClass.getName());
                } else {
                    org.modeldriven.fuml.repository.Classifier oppositeClassifier = prop.getType();
                    Classifier repoClassifier = new Classifier(oppositeClassifier);
                    String oppositeClassNamespaceURI = repoClassifier.getNamespaceURI();
                    propertyType = PlasmaTypeHelper.INSTANCE.getType(oppositeClassNamespaceURI, repoClassifier.getName());
                }
            } else {
                org.modeldriven.fuml.repository.Classifier propertyClassifier = prop.getType();
                DataType dataType = DataType.valueOf(propertyClassifier.getName());
                propertyType = PlasmaTypeHelper.INSTANCE.getType(PlasmaConfig.getInstance().getSDO().getDefaultNamespace().getUri(), dataType.name());
            }
            CoreProperty property = new CoreProperty((CoreType)propertyType, new Property(prop), this);
            this.declaredPropertiesMap.put(property.getName(), property);
            PlasmaProperty existing = null;
            for (String alias : property.getAliasNames()) {
                existing = this.declaredPropertiesMap.get(alias);
                if (existing != null && !existing.getName().equals(property.getName())) {
                    throw new IllegalStateException("found existing property, " + existing.getContainingType().toString() + "." + existing.getName() + ", already mapped to alias '" + alias + "' while loading property " + this.toString() + "." + property.getName());
                }
                this.declaredPropertiesMap.put(alias, property);
            }
            this.declaredPropertiesList.add(property);
            if (property.isKey(KeyType.primary)) {
                ArrayList<CoreProperty> pkPropList = (ArrayList<CoreProperty>)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_PRIKEY_PROPERTIES);
                if (pkPropList == null) {
                    pkPropList = new ArrayList<CoreProperty>();
                    this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_PRIKEY_PROPERTIES, pkPropList);
                }
                pkPropList.add(property);
            }
            if (property.isConcurrent(ConcurrencyType.origination, ConcurrentDataFlavor.time)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_ORIGINATION_TIMESTAMP, property);
            }
            if (property.isConcurrent(ConcurrencyType.origination, ConcurrentDataFlavor.user)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_ORIGINATION_USER, property);
            }
            if (property.isConcurrent(ConcurrencyType.pessimistic, ConcurrentDataFlavor.time)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_LOCKING_TIMESTAMP, property);
            }
            if (property.isConcurrent(ConcurrencyType.origination, ConcurrentDataFlavor.user)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_LOCKING_USER, property);
            }
            if (property.isConcurrent(ConcurrencyType.optimistic, ConcurrentDataFlavor.time)) {
                this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENCY_VERSION, property);
            }
            if (!property.isConcurrent(ConcurrencyType.optimistic, ConcurrentDataFlavor.user)) continue;
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_CONCURRENCY_USER, property);
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return this.classifier.getName();
        }
        return this.name;
    }

    @Override
    public byte[] getNameBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES)) == null) {
            result = this.getName().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public QName getQualifiedName() {
        return this.qname;
    }

    @Override
    public byte[] getQualifiedNameBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_NAME_BYTES)) == null) {
            result = this.getQualifiedName().toString().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public QName getQualifiedPhysicalName() {
        String physicalName = this.getPhysicalName();
        if (physicalName != null) {
            return new QName(this.namespaceURI, physicalName);
        }
        return null;
    }

    @Override
    public int getQualifiedNameHashCode() {
        return this.qnameHashCode;
    }

    @Override
    public byte[] getQualifiedPhysicalNameBytes() {
        QName qname;
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_PHYSICAL_NAME_BYTES)) == null && (qname = this.getQualifiedPhysicalName()) != null) {
            result = qname.toString().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_QUALIFIED_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getURI() {
        return this.namespaceURI;
    }

    @Override
    public byte[] getURIBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_URI_BYTES)) == null) {
            result = this.getURI().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_URI_BYTES, result);
        }
        return result;
    }

    @Override
    public String getPhysicalName() {
        if (this.physicalName == null) {
            return this.classifier.getPhysicalName();
        }
        return this.physicalName;
    }

    @Override
    public byte[] getPhysicalNameBytes() {
        String name;
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES)) == null && (name = this.getPhysicalName()) != null) {
            result = name.getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getLocalName() {
        if (this.localName != null) {
            return this.localName;
        }
        SDOAlias alias = this.classifier.findAlias();
        if (alias != null && alias.getLocalName() != null) {
            return alias.getLocalName();
        }
        return this.name;
    }

    @Override
    public byte[] getLocalNameBytes() {
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES)) == null) {
            result = this.getLocalName().getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_LOCAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public String getPackageName() {
        return this.classifier.getPackageName();
    }

    @Override
    public String getPackagePhysicalName() {
        return this.classifier.getPackagePhysicalName();
    }

    @Override
    public byte[] getPackagePhysicalNameBytes() {
        String name;
        byte[] result;
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        if ((result = (byte[])this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PACKAGE_PHYSICAL_NAME_BYTES)) == null && (name = this.getPackagePhysicalName()) != null) {
            result = name.getBytes(Charset.forName("UTF-8"));
            this.instancePropertiesMap.put(PlasmaProperty.INSTANCE_PROPERTY_BYTES_PACKAGE_PHYSICAL_NAME_BYTES, result);
        }
        return result;
    }

    @Override
    public List<Comment> getDescription() {
        return (List)this.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
    }

    @Override
    public String getDescriptionText() {
        StringBuilder buf = new StringBuilder();
        List list = (List)this.get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_DESCRIPTION);
        if (list != null) {
            for (Comment comment : list) {
                buf.append(comment.getBody());
            }
        }
        return buf.toString();
    }

    @Override
    public Alias getAlias() {
        return this.classifier.findAlias();
    }

    @Override
    public Classifier getClassifier() {
        return this.classifier;
    }

    @Override
    public boolean isAbstract() {
        return this.classifier.isAbstract();
    }

    @Override
    public boolean isDataType() {
        return this.classifier.isDataType();
    }

    @Override
    public List<String> getAliasNames() {
        if (this.instancePropertiesMap == null) {
            this.lazyLoadProperties();
        }
        ArrayList<String> aliasList = new ArrayList<String>();
        String physicalName = (String)this.instancePropertiesMap.get(PlasmaProperty.INSTANCE_PROPERTY_STRING_PHYSICAL_NAME);
        if (physicalName != null) {
            aliasList.add(physicalName);
        }
        return aliasList;
    }

    @Override
    public List<Type> getBaseTypes() {
        if (this.baseTypes == null) {
            this.baseTypes = new ArrayList<Type>();
            PlasmaTypeHelper helper = PlasmaTypeHelper.INSTANCE;
            List<org.modeldriven.fuml.repository.Classifier> generalizations = this.classifier.getGeneralization();
            for (org.modeldriven.fuml.repository.Classifier classifier : generalizations) {
                String namespaceURI = this.classifier.getNamespaceURI(classifier);
                Type type = helper.getType(namespaceURI, classifier.getName());
                this.baseTypes.add(type);
            }
        }
        return this.baseTypes;
    }

    @Override
    public boolean isBaseType(PlasmaType other) {
        for (Type t : this.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)t;
            if (baseType.getQualifiedNameHashCode() == other.getQualifiedNameHashCode()) {
                return true;
            }
            if (!baseType.isBaseType(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Type> getSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<Type>();
            PlasmaTypeHelper helper = PlasmaTypeHelper.INSTANCE;
            List<org.modeldriven.fuml.repository.Classifier> specializations = this.classifier.getSpecializations();
            for (org.modeldriven.fuml.repository.Classifier classifier : specializations) {
                String namespaceURI = this.classifier.getNamespaceURI(classifier);
                Type type = helper.getType(namespaceURI, classifier.getName());
                this.subTypes.add(type);
            }
        }
        return this.subTypes;
    }

    @Override
    public boolean isSubType(PlasmaType other) {
        for (Type t : this.getSubTypes()) {
            PlasmaType subType = (PlasmaType)t;
            if (subType.getQualifiedNameHashCode() == other.getQualifiedNameHashCode()) {
                return true;
            }
            if (!subType.isSubType(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<commonj.sdo.Property> getDeclaredProperties() {
        if (this.declaredPropertiesList == null) {
            this.lazyLoadProperties();
        }
        return this.declaredPropertiesList;
    }

    @Override
    public List<commonj.sdo.Property> getDeclaredPropertiesSorted() {
        List<commonj.sdo.Property> list = this.getDeclaredProperties();
        commonj.sdo.Property[] properties = new commonj.sdo.Property[list.size()];
        list.toArray(properties);
        Arrays.sort(properties, new Comparator<commonj.sdo.Property>(){

            @Override
            public int compare(commonj.sdo.Property o1, commonj.sdo.Property o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>(properties.length);
        for (commonj.sdo.Property prop : properties) {
            result.add(prop);
        }
        return result;
    }

    @Override
    public List<commonj.sdo.Property> getInstanceProperties() {
        if (this.declaredPropertiesMap == null) {
            this.lazyLoadProperties();
        }
        Iterator<PlasmaProperty> iter = this.instancePropertiesMap.keySet().iterator();
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>(this.instancePropertiesMap.size());
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    @Override
    public List<commonj.sdo.Property> getProperties() {
        ArrayList<commonj.sdo.Property> result = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties(this, result);
        return result;
    }

    @Override
    public Object get(commonj.sdo.Property property) {
        if (this.declaredPropertiesMap == null) {
            this.lazyLoadProperties();
        }
        return this.instancePropertiesMap.get(property);
    }

    @Override
    public List<Object> search(commonj.sdo.Property property) {
        if (this.declaredPropertiesMap == null) {
            this.lazyLoadProperties();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.collectInstancePropertyValues(this, property, result);
        return result;
    }

    private void collectInstancePropertyValues(Type type, commonj.sdo.Property property, List<Object> result) {
        Object value = type.get(property);
        if (value != null) {
            result.add(value);
        }
        for (Type baseType : type.getBaseTypes()) {
            this.collectInstancePropertyValues(baseType, property, result);
        }
    }

    @Override
    public commonj.sdo.Property getProperty(String propertyName) {
        commonj.sdo.Property result = this.findDeclaredProperty(this, propertyName);
        if (result == null) {
            throw new IllegalArgumentException("given property name '" + propertyName + "' is undefined for type " + this.getURI() + "#" + this.getName() + " and all its base types");
        }
        return result;
    }

    @Override
    public commonj.sdo.Property findProperty(String propertyName) {
        return this.findDeclaredProperty(this, propertyName);
    }

    @Override
    public commonj.sdo.Property findProperty(ConcurrencyType concurrencyType, ConcurrentDataFlavor dataFlavor) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties(this, concurrencyType, dataFlavor, properties);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return (commonj.sdo.Property)properties.get(0);
        }
        log.warn((Object)("Found multiple declared properties for type " + this.getURI() + "#" + this.getName() + " tagged with " + ConcurrencyType.class.getSimpleName() + " '" + concurrencyType.name() + "' and concurrency data flavor '" + dataFlavor.name() + "'"));
        return (commonj.sdo.Property)properties.get(0);
    }

    @Override
    public commonj.sdo.Property findProperty(KeyType keyType) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties(this, keyType, properties);
        if (properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return (commonj.sdo.Property)properties.get(0);
        }
        log.warn((Object)("Found multiple declared properties for type " + this.getURI() + "#" + this.getName() + " tagged with " + KeyType.class.getSimpleName() + " '" + keyType.name() + "'"));
        return (commonj.sdo.Property)properties.get(0);
    }

    @Override
    public List<commonj.sdo.Property> findProperties(KeyType keyType) {
        ArrayList<commonj.sdo.Property> properties = new ArrayList<commonj.sdo.Property>();
        this.collectDeclaredProperties(this, keyType, properties);
        return properties;
    }

    private commonj.sdo.Property findDeclaredProperty(PlasmaType currentType, String propertyName) {
        commonj.sdo.Property result;
        if (currentType.getDeclaredProperties() == null) {
            ((CoreType)currentType).lazyLoadProperties();
        }
        if ((result = (commonj.sdo.Property)((CoreType)currentType).declaredPropertiesMap.get(propertyName)) != null) {
            return result;
        }
        for (Type base : currentType.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)base;
            result = this.findDeclaredProperty(baseType, propertyName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private commonj.sdo.Property findDeclaredProperty(PlasmaType currentType, ConcurrencyType concurrencyType, ConcurrentDataFlavor dataFlavor) {
        if (currentType.getDeclaredProperties() == null) {
            ((CoreType)currentType).lazyLoadProperties();
        }
        commonj.sdo.Property result = null;
        for (commonj.sdo.Property property : this.getDeclaredProperties()) {
            if (!((PlasmaProperty)property).isConcurrent(concurrencyType, dataFlavor)) continue;
            result = property;
            break;
        }
        for (Type base : currentType.getBaseTypes()) {
            PlasmaType baseType = (PlasmaType)base;
            result = this.findDeclaredProperty(baseType, concurrencyType, dataFlavor);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void collectDeclaredProperties(PlasmaType type, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, properties);
        }
    }

    private void collectDeclaredProperties(PlasmaType type, ConcurrencyType concurrencyType, ConcurrentDataFlavor dataFlavor, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            PlasmaProperty plasmaProp = (PlasmaProperty)p;
            if (!plasmaProp.isConcurrent(concurrencyType, dataFlavor)) continue;
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, concurrencyType, dataFlavor, properties);
        }
    }

    private void collectDeclaredProperties(PlasmaType type, KeyType keyType, List<commonj.sdo.Property> properties) {
        for (commonj.sdo.Property p : type.getDeclaredProperties()) {
            PlasmaProperty plasmaProp = (PlasmaProperty)p;
            if (!plasmaProp.isKey(keyType)) continue;
            properties.add(p);
        }
        for (Type t : type.getBaseTypes()) {
            this.collectDeclaredProperties((PlasmaType)t, keyType, properties);
        }
    }

    @Override
    public Class<?> getInstanceClass() {
        if (!this.isDataType()) {
            Namespace namespace = PlasmaConfig.getInstance().getSDONamespaceByURI(this.getURI());
            if (namespace != null && namespace.getProvisioning() != null) {
                String qualifiedName = namespace.getProvisioning().getPackageName() + "." + this.getName();
                try {
                    Class<?> interfaceImplClass = Class.forName(qualifiedName);
                    return interfaceImplClass;
                }
                catch (ClassNotFoundException e) {
                    return CoreDataObject.class;
                }
            }
            return CoreDataObject.class;
        }
        return this.toDataTypeInstanceClass(DataType.valueOf(this.getName()));
    }

    @Override
    public boolean isInstance(Object object) {
        boolean result = false;
        if (DataObject.class.isAssignableFrom(object.getClass())) {
            DataObject dataObject = (DataObject)object;
            Type type = dataObject.getType();
            result = type.getName().equals(this.getName()) && type.getURI().equals(this.getURI());
        } else if (this.isDataType()) {
            Class<?> instanceClass = this.toDataTypeInstanceClass(DataType.valueOf(this.getName()));
            return instanceClass.isAssignableFrom(object.getClass());
        }
        return result;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isSequenced() {
        return false;
    }

    @Override
    public Class<?> toDataTypeInstanceClass(DataType dataType) {
        return DataConverter.INSTANCE.toWrapperJavaClass(dataType);
    }

    @Override
    public boolean isRelation(PlasmaType other, AssociationPath relationPath) {
        return this.classifier.isRelation(other.getClassifier(), relationPath);
    }

    @Override
    public Derivation getDerivation() {
        return this.classifier.findDerivation();
    }

    @Override
    public PlasmaType getDerivationSupplier() {
        org.modeldriven.fuml.repository.Classifier classifier = this.classifier.getDerivationSupplier();
        if (classifier != null) {
            return this.lookup(classifier);
        }
        return null;
    }

    private PlasmaType lookup(org.modeldriven.fuml.repository.Classifier repoClassifier) {
        String repoClassNamespaceURI = this.classifier.getNamespaceURI(repoClassifier);
        String repoTypeName = repoClassifier.getName();
        TypeBinding binding = PlasmaConfig.getInstance().findTypeBinding(repoClassNamespaceURI, repoClassifier.getName());
        if (binding != null && binding.getLogicalName() != null && binding.getLogicalName().trim().length() > 0) {
            repoTypeName = binding.getLogicalName().trim();
        }
        PlasmaType repoType = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(repoClassNamespaceURI, repoTypeName);
        return repoType;
    }
}

