/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Stereotype;
import org.plasma.sdo.PlasmaDataObjectConstants;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.core.CoreType;
import org.plasma.sdo.repository.PlasmaRepository;

public class PlasmaTypeHelper
implements TypeHelper {
    private static Log log = LogFactory.getLog(PlasmaTypeHelper.class);
    public static PlasmaTypeHelper INSTANCE = PlasmaTypeHelper.initializeInstance();
    private Map<String, Type> namespaceQualifiedNameToTypeMap = new HashMap<String, Type>();
    private Map<String, List<Type>> namespaceToTypesMap = new HashMap<String, List<Type>>();

    private PlasmaTypeHelper() {
    }

    private static synchronized PlasmaTypeHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaTypeHelper();
        }
        return INSTANCE;
    }

    @Override
    public Type define(DataObject type) {
        throw new RuntimeException("not yet supported");
    }

    @Override
    public List define(List types) {
        throw new RuntimeException("not yet supported");
    }

    @Override
    public Property defineOpenContentProperty(String uri, DataObject property) {
        throw new RuntimeException("not yet supported");
    }

    @Override
    public Property getOpenContentProperty(String uri, String propertyName) {
        throw new RuntimeException("not yet supported");
    }

    @Override
    public Type getType(String uri, String typeName) {
        String qualifiedName = uri + "#" + typeName;
        Type result = this.namespaceQualifiedNameToTypeMap.get(qualifiedName);
        if (result == null) {
            List<Type> namespaceTypes;
            result = new CoreType(uri, typeName);
            this.namespaceQualifiedNameToTypeMap.put(qualifiedName, result);
            if (!result.getName().equals(typeName)) {
                qualifiedName = uri + "#" + result.getName();
                this.namespaceQualifiedNameToTypeMap.put(qualifiedName, result);
            }
            if ((namespaceTypes = this.namespaceToTypesMap.get(uri)) == null) {
                namespaceTypes = new ArrayList<Type>();
            }
            namespaceTypes.add(result);
        }
        return result;
    }

    @Override
    public Type getType(Class interfaceClass) {
        String uri = null;
        try {
            Field uriField = interfaceClass.getDeclaredField(PlasmaDataObjectConstants.NAMESPACE_URI_FIELD_NAME);
            uri = (String)uriField.get(null);
        }
        catch (SecurityException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalAccessException e) {
            throw new PlasmaDataObjectException(e);
        }
        String qualifiedName = uri + "#" + interfaceClass.getSimpleName();
        Type result = this.namespaceQualifiedNameToTypeMap.get(qualifiedName);
        if (result == null) {
            result = new CoreType(uri, interfaceClass.getSimpleName());
            this.namespaceQualifiedNameToTypeMap.put(qualifiedName, result);
            List<Type> namespaceTypes = this.namespaceToTypesMap.get(uri);
            if (namespaceTypes == null) {
                namespaceTypes = new ArrayList<Type>();
            }
            namespaceTypes.add(result);
        }
        return result;
    }

    public List<Type> getTypes(String uri) {
        ArrayList<Type> result = new ArrayList<Type>();
        List<Classifier> list = PlasmaRepository.getInstance().getClassifiers(uri);
        for (Classifier classifier : list) {
            if (classifier instanceof Stereotype) {
                log.warn((Object)("ignoring stereotype: " + classifier.getName()));
                continue;
            }
            Type type = this.getType(uri, classifier.getName());
            result.add(type);
        }
        return result;
    }
}

