/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository;

import java.util.List;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Package;
import org.modeldriven.fuml.repository.Stereotype;
import org.plasma.sdo.profile.SDONamespace;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.RepositoryException;

public abstract class Element {
    public String getNamespaceURI(Classifier classifier) {
        Package p = classifier.getPackage();
        String uri = this.findSDONamespaceURI(p);
        if (uri == null) {
            throw new RepositoryException("no SDO Namespace uri found for classifier, '" + classifier.getName() + "'");
        }
        return uri;
    }

    private String findSDONamespaceURI(Package pkg) {
        SDONamespace sdoNamespaceStereotype = this.findSDONamespace(pkg);
        if (sdoNamespaceStereotype != null) {
            return sdoNamespaceStereotype.getUri();
        }
        if (pkg.getNestingPackage() != null) {
            return this.findSDONamespaceURI(pkg.getNestingPackage());
        }
        return null;
    }

    private SDONamespace findSDONamespace(Package pkg) {
        List stereotypes = PlasmaRepository.getInstance().getStereotypes((org.modeldriven.fuml.repository.Element)pkg);
        if (stereotypes != null) {
            for (Stereotype stereotype : stereotypes) {
                if (!(stereotype.getDelegate() instanceof SDONamespace)) continue;
                return (SDONamespace)stereotype.getDelegate();
            }
        }
        return null;
    }
}

