/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Property;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.Repository;

public class RelationCache {
    private static Log log = LogFactory.getFactory().getInstance(RelationCache.class);
    private Map<String, RelationPathResult> map = new HashMap<String, RelationPathResult>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRelation(Classifier target, Classifier source, AssociationPath relation) {
        switch (relation) {
            case singular: {
                String key = this.createHashKey(target, source);
                RelationPathResult result = this.map.get(key);
                if (result == null) {
                    boolean isRelated = this.isLateralSingularRelation(target, source, null, new HashMap<String, Integer>());
                    result = new RelationPathResult(AssociationPath.singular, isRelated);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cacheing (" + isRelated + ") lateral-singular relation: " + target.getName() + "/" + source.getName() + " (" + key + ")"));
                    }
                    Map<String, RelationPathResult> map = this.map;
                    synchronized (map) {
                        this.map.put(key, result);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("cache hit (" + result.isRelated() + ") lateral-singular relation: " + target.getName() + "/" + source.getName() + " (" + key + ")"));
                }
                return result.isRelated();
            }
        }
        return false;
    }

    public void clear() {
        this.map.clear();
    }

    private String createHashKey(Classifier targetType, Classifier sourceType) {
        return targetType.getId() + "/" + sourceType.getId();
    }

    private String createHashKey(Property target, Property source) {
        return target.getXmiId() + "/" + source.getXmiId();
    }

    private boolean isLateralSingularRelation(Classifier targetType, Classifier sourceType, Property traversalSourceProperty, Map<String, Integer> visited) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing targetType/sourceType " + targetType.toString() + " / " + sourceType.toString()));
        }
        List<Property> targetProperties = targetType.getAllProperties();
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking targetType  " + targetType.toString() + " with " + targetProperties.size() + " properties"));
        }
        for (Property targetProperty : targetProperties) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking " + targetType.toString() + "." + this.getDebugName(targetProperty)));
            }
            if (targetProperty.getType().isDataType()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("not a reference property " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                continue;
            }
            Property targetPropertyOpposite = targetProperty.getOpposite();
            if (targetPropertyOpposite == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("no opposite " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                continue;
            }
            if (!targetPropertyOpposite.isSingular()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("opposite not singular " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing " + targetType.toString() + "." + this.getDebugName(targetProperty)));
            }
            if (traversalSourceProperty != null) {
                String linkKey = this.createHashKey(targetProperty, traversalSourceProperty);
                Integer count = null;
                count = visited.get(linkKey);
                if (count == null) {
                    visited.put(linkKey, 1);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("exiting - visited  " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                    }
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing " + targetType.toString() + "." + this.getDebugName(targetProperty) + " (" + targetProperty.getType().getXmiId() + ")" + "->" + sourceType.toString() + " (" + sourceType.getId() + ")"));
            }
            if (targetProperty.getType().getXmiId().equals(sourceType.getId())) {
                if (targetType.getId().equals(sourceType.getId())) {
                    log.warn((Object)("potential circular reference: " + targetType.toString() + "." + this.getDebugName(targetProperty) + "->" + sourceType.toString()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found child link property " + targetType.toString() + "." + this.getDebugName(targetProperty) + "->" + sourceType.toString()));
                }
                return true;
            }
            if (targetProperty.getType().getXmiId().equals(targetType.getId())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("traversing " + targetType.toString() + "." + this.getDebugName(targetProperty)));
            }
            org.modeldriven.fuml.repository.Classifier tempClassifier = (org.modeldriven.fuml.repository.Classifier)Repository.INSTANCE.getElementById(targetProperty.getType().getXmiId());
            String urn = tempClassifier.getArtifact().getNamespaceURI();
            String qualifiedName = urn + "#" + tempClassifier.getName();
            org.modeldriven.fuml.repository.Classifier targetClassifier = PlasmaRepository.getInstance().getClassifier(qualifiedName);
            Classifier nextClassifier = null;
            nextClassifier = org.modeldriven.fuml.repository.Class_.class.isAssignableFrom(targetClassifier.getClass()) ? new Class_((org.modeldriven.fuml.repository.Class_)targetClassifier) : new Classifier(targetClassifier);
            if (!this.isLateralSingularRelation(nextClassifier, sourceType, targetProperty, visited)) continue;
            return true;
        }
        return false;
    }

    private String getDebugName(Property prop) {
        if (prop.getName() != null && prop.getName().trim().length() > 0) {
            return prop.getName();
        }
        return prop.getType().getName();
    }

    class RelationPathResult {
        private AssociationPath relationPath;
        private boolean related;

        private RelationPathResult() {
        }

        public RelationPathResult(AssociationPath relationPath, boolean related) {
            this.relationPath = relationPath;
            this.related = related;
        }

        public AssociationPath getRelationPath() {
            return this.relationPath;
        }

        public boolean isRelated() {
            return this.related;
        }
    }
}

