/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.ddl;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.OpaqueBehavior;
import org.plasma.config.DataStoreType;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Enumeration;
import org.plasma.sdo.repository.EnumerationLiteral;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.text.ddl.Behavior;
import org.plasma.text.ddl.BehaviorType;
import org.plasma.text.ddl.Check;
import org.plasma.text.ddl.Column;
import org.plasma.text.ddl.DDLException;
import org.plasma.text.ddl.Fk;
import org.plasma.text.ddl.Index;
import org.plasma.text.ddl.On;
import org.plasma.text.ddl.Pk;
import org.plasma.text.ddl.Schema;
import org.plasma.text.ddl.Schemas;
import org.plasma.text.ddl.Table;
import org.plasma.text.ddl.Unique;

public class DDLModelAssembler {
    private static Log log = LogFactory.getLog(DDLModelAssembler.class);
    private Schemas schemas;
    private Map<String, Map<String, PlasmaType>> schemaMap = new HashMap<String, Map<String, PlasmaType>>();

    public DDLModelAssembler() {
        this(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public DDLModelAssembler(List<Namespace> namespaces) {
        this.schemas = new Schemas();
        for (Namespace namespace : namespaces) {
            log.debug((Object)("processing namespace: " + namespace.getUri()));
            if (!PlasmaConfig.getInstance().hasNamespace(DataStoreType.RDBMS)) {
                log.debug((Object)("ignoring non " + DataStoreType.RDBMS.name() + " namespace: " + namespace.getUri()));
                continue;
            }
            List<Type> types = PlasmaTypeHelper.INSTANCE.getTypes(namespace.getUri());
            for (Type type : types) {
                PlasmaType plasmaType = (PlasmaType)type;
                if (plasmaType.getPhysicalName() == null || plasmaType.getPhysicalName().length() == 0) continue;
                Map<String, PlasmaType> typeMap = this.schemaMap.get(namespace.getPhysicalName());
                if (typeMap == null) {
                    typeMap = new HashMap<String, PlasmaType>();
                    this.schemaMap.put(namespace.getPhysicalName(), typeMap);
                }
                typeMap.put(plasmaType.getPhysicalName(), plasmaType);
            }
        }
        for (String schemaName : this.schemaMap.keySet()) {
            Schema schema = this.createSchema(schemaName);
            Map<String, PlasmaType> typeMap = this.schemaMap.get(schemaName);
            for (PlasmaType type : typeMap.values()) {
                Table table = this.createTable(schema, type);
                schema.getTables().add(table);
                List<Property> properties = type.getProperties();
                HashMap<Property, Property> map = new HashMap<Property, Property>();
                for (Property p : properties) {
                    map.put(p, p);
                }
                this.createColumns(schema, table, type, map.values());
                this.createPriKey(table, map.values());
                Class_ repositoryClass = (Class_)type.getClassifier();
                List<OpaqueBehavior> ddlBehaviors = repositoryClass.getOpaqueBehaviors("DDL");
                this.createBehaviors(table, ddlBehaviors);
                List<OpaqueBehavior> sqlBehaviors = repositoryClass.getOpaqueBehaviors("SQL");
                this.createBehaviors(table, sqlBehaviors);
                this.createForeignConstraints(table, type, map.values());
                this.createUniqueConstraints(table, map.values());
                this.createCheckConstraints(table, map.values());
                this.createIndexes(table, map.values());
            }
        }
    }

    private void createIndexes(Table table, Collection<Property> properties) {
        int i = 1;
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || plasmaProperty.getType().isDataType()) continue;
            Index index = new Index();
            index.setName("I_" + table.getName() + String.valueOf(i));
            index.setColumn(plasmaProperty.getPhysicalName());
            table.getIndices().add(index);
            ++i;
        }
    }

    private void createCheckConstraints(Table table, Collection<Property> properties) {
        int i = 1;
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || !plasmaProperty.getType().isDataType() || plasmaProperty.getRestriction() == null) continue;
            Check check = new Check();
            check.setName("CK_" + table.getName() + "_" + String.valueOf(i));
            check.setColumn(plasmaProperty.getPhysicalName());
            table.getChecks().add(check);
            Enumeration restriction = plasmaProperty.getRestriction();
            for (EnumerationLiteral lit : restriction.getOwnedLiteral()) {
                check.getValues().add(lit.getPhysicalName());
            }
            ++i;
        }
    }

    private void createUniqueConstraints(Table table, Collection<Property> properties) {
        int uniqueCount = 0;
        for (Property prop : properties) {
            Boolean isUnique;
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || plasmaProperty.getKey() != null && plasmaProperty.getKey().getType().ordinal() == KeyType.primary.ordinal() || (isUnique = (Boolean)plasmaProperty.get(PlasmaProperty.INSTANCE_PROPERTY_BOOLEAN_ISUNIQUE)) == null || !isUnique.booleanValue()) continue;
            ++uniqueCount;
        }
        if (uniqueCount > 0) {
            Unique unique = new Unique();
            unique.setName("UK_" + table.getName());
            table.getUniques().add(unique);
            int i = 1;
            for (Property prop : properties) {
                Boolean isUnique;
                PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
                if (plasmaProperty.getPhysicalName() == null || plasmaProperty.getKey() != null && plasmaProperty.getKey().getType().ordinal() == KeyType.primary.ordinal() || (isUnique = (Boolean)plasmaProperty.get(PlasmaProperty.INSTANCE_PROPERTY_BOOLEAN_ISUNIQUE)) == null || !isUnique.booleanValue()) continue;
                On on = new On();
                on.setColumn(plasmaProperty.getPhysicalName());
                unique.getOns().add(on);
                ++i;
            }
        }
    }

    private void createForeignConstraints(Table table, PlasmaType plasmaType, Collection<Property> properties) {
        int i = 1;
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null) {
                if (plasmaProperty.isMany()) continue;
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName()));
                continue;
            }
            if (plasmaProperty.getType().isDataType()) continue;
            Fk fk = new Fk();
            fk.setName("FK_" + table.getName() + String.valueOf(i));
            fk.setColumn(plasmaProperty.getPhysicalName());
            Type oppositeType = plasmaProperty.getType();
            if (!oppositeType.isAbstract()) {
                fk.setToTable(((PlasmaType)oppositeType).getPhysicalName());
            } else {
                fk.setToTable(plasmaType.getPhysicalName());
            }
            table.getFks().add(fk);
            ++i;
        }
    }

    private void createBehaviors(Table table, List<OpaqueBehavior> behaviors) {
        for (OpaqueBehavior behavior : behaviors) {
            BehaviorType type = null;
            try {
                type = BehaviorType.fromValue(behavior.getName());
            }
            catch (IllegalArgumentException e) {
                throw new DDLException("unknown behavior name '" + behavior.getName() + "' - expected one of [" + BehaviorType.values() + "]");
            }
            Behavior ddlBehavior = new Behavior();
            ddlBehavior.setType(type);
            ddlBehavior.setValue(behavior.getBody());
            table.getBehaviors().add(ddlBehavior);
        }
    }

    private void createColumns(Schema schema, Table table, PlasmaType plasmaType, Collection<Property> properties) {
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null) {
                if (plasmaProperty.isMany()) continue;
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName()));
                continue;
            }
            Column column = this.createColumn(schema, table, plasmaType, plasmaProperty);
            table.getColumns().add(column);
        }
    }

    private void createPriKey(Table table, Collection<Property> properties) {
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || !plasmaProperty.isKey(KeyType.primary)) continue;
            Pk pk = table.getPk();
            if (pk == null) {
                pk = this.createPk(table, plasmaProperty);
                table.setPk(pk);
            }
            On on = new On();
            on.setColumn(plasmaProperty.getPhysicalName());
            table.getPk().getOns().add(on);
        }
    }

    private Pk createPk(Table table, PlasmaProperty plasmaProperty) {
        Pk pk = new Pk();
        pk.setName("PK_" + table.getName());
        return pk;
    }

    private Column createColumn(Schema schema, Table table, PlasmaType plasmaType, PlasmaProperty plasmaProperty) {
        Column column = new Column();
        column.setName(plasmaProperty.getPhysicalName());
        column.setNullable(plasmaProperty.isNullable());
        if (plasmaProperty.getMaxLength() > 0L) {
            column.setSize(plasmaProperty.getMaxLength());
        } else {
            column.setSize(-1L);
        }
        if (plasmaProperty.getType().isDataType()) {
            DataType sdoType = DataType.valueOf(plasmaProperty.getType().getName());
            column.setType(sdoType.name());
        } else {
            PlasmaProperty oppositePkProp = null;
            if (!plasmaProperty.getType().isAbstract()) {
                for (Property p : plasmaProperty.getType().getProperties()) {
                    PlasmaProperty oppositeProp = (PlasmaProperty)p;
                    if (!oppositeProp.isKey(KeyType.primary)) continue;
                    if (oppositePkProp != null) {
                        throw new DDLException("multiple opposite pri-key propertys found for '" + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName() + "'");
                    }
                    oppositePkProp = oppositeProp;
                }
            } else {
                oppositePkProp = (PlasmaProperty)plasmaType.findProperty(KeyType.primary);
            }
            if (oppositePkProp == null) {
                throw new DDLException("could not find opposite pri-key property for '" + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName() + "'");
            }
            DataType sdoType = DataType.valueOf(oppositePkProp.getType().getName());
            column.setType(sdoType.name());
        }
        return column;
    }

    private Table createTable(Schema schema, PlasmaType plasmaType) {
        Table table = new Table();
        table.setName(plasmaType.getPhysicalName());
        return table;
    }

    private Schema createSchema(String name) {
        Schema schema = new Schema();
        this.schemas.getSchemas().add(schema);
        schema.setName(name);
        return schema;
    }

    public Schemas getSchemas() {
        return this.schemas;
    }
}

