/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.adapter.FieldAdapter;
import org.plasma.sdo.access.model.Entity;
import org.plasma.text.lang3gl.ClassFactory;
import org.plasma.text.lang3gl.ClassNameResolver;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.JDOClassNameResolver;
import org.plasma.text.lang3gl.java.JDODefaultFactory;
import org.plasma.text.lang3gl.java.TypeClassInfo;

public class JDOClassFactory
extends JDODefaultFactory
implements ClassFactory {
    public JDOClassFactory(Lang3GLContext context) {
        super(context);
    }

    @Override
    public String createFileName(Class clss) {
        StringBuilder buf = new StringBuilder();
        JDOClassNameResolver classNameResolver = new JDOClassNameResolver();
        buf.append(classNameResolver.getName(clss));
        buf.append(".java");
        return buf.toString();
    }

    @Override
    public String createContent(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.createPackageDeclaration(pkg));
        buf.append(LINE_SEP);
        buf.append(this.createThirdPartyImportDeclarations(pkg, clss));
        JDOClassNameResolver resolver = new JDOClassNameResolver();
        Map<String, String> importMap = this.createFieldImportMap(pkg, clss, resolver);
        buf.append(this.createImportDeclarations(importMap));
        buf.append(LINE_SEP);
        buf.append(LINE_SEP);
        buf.append(this.createTypeDeclaration(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.createStaticFieldDeclarations(clss));
        buf.append(LINE_SEP);
        buf.append(this.createConstructors(pkg, clss));
        buf.append(this.createFields(pkg, clss));
        buf.append(this.createOperations(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.endBody());
        return buf.toString();
    }

    @Override
    protected Map<String, String> createFieldImportMap(Package pkg, Class clss, ClassNameResolver resolver) {
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        this.collectDataFieldClassNamesDeep(pkg, clss, nameMap, resolver, true, -1);
        this.collectReferenceFieldClassNamesDeep(pkg, clss, nameMap, resolver, false, -1);
        return nameMap;
    }

    private String createFields(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        TreeMap<String, FieldAdapter> fields = new TreeMap<String, FieldAdapter>();
        this.collectProvisioningFields(pkg, clss, pkg, clss, fields);
        for (String name : fields.keySet()) {
            FieldAdapter adapter = (FieldAdapter)fields.get(name);
            buf.append(LINE_SEP);
            buf.append(this.createPrivateFieldDeclaration(clss, adapter.getField()));
        }
        return buf.toString();
    }

    protected String createConstructors(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        JDOClassNameResolver classNameResolver = new JDOClassNameResolver();
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("public ");
        buf.append(classNameResolver.getName(clss));
        buf.append("() {");
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("super();");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("}");
        return buf.toString();
    }

    protected String createOperations(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        TreeMap<String, FieldAdapter> fields = new TreeMap<String, FieldAdapter>();
        this.collectProvisioningFields(pkg, clss, pkg, clss, fields);
        for (String name : fields.keySet()) {
            FieldAdapter adapter = (FieldAdapter)fields.get(name);
            buf.append(this.createOperations(pkg, clss, adapter.getField()));
        }
        return buf.toString();
    }

    protected String createOperations(Package pkg, Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        TypeClassInfo typeClassName = this.getTypeClassName(field.getType());
        if (!field.isMany()) {
            buf.append(LINE_SEP);
            this.createSingularGetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createSingularSetter(pkg, clss, field, typeClassName, buf);
        } else {
            buf.append(LINE_SEP);
            this.createManyGetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyIndexGetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyCount(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManySetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyAdder(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyRemover(pkg, clss, field, typeClassName, buf);
        }
        return buf.toString();
    }

    private void createSingularGetter(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createSingularGetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createSingularGetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createSingularGetterBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("return this.");
        buf.append(this.buildPrivateFieldName(clss, field));
        buf.append(";");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createSingularSetter(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createSingularSetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createSingularSetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createSingularSetterBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("this.");
        buf.append(this.buildPrivateFieldName(clss, field));
        buf.append(" = value;");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createManyGetter(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createManyGetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyGetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyGetterBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append(typeClassName.getSimpleName());
        buf.append("[] array = new ");
        buf.append(typeClassName.getSimpleName());
        buf.append("[this.");
        buf.append(fieldName);
        buf.append(".size()];");
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".toArray(array);");
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("return array;");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createManyIndexGetter(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createManyIndexGetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyIndexGetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyIndexGetterBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("return this.");
        buf.append(fieldName);
        buf.append(".get(idx);");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createManyCount(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createManyCountDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyCountBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyCountBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("return this.");
        buf.append(fieldName);
        buf.append(".size();");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createManySetter(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createManySetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManySetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManySetterBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".clear();");
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("for (int i = 0; i < value.length; i++) {");
        buf.append(LINE_SEP);
        buf.append(this.indent(3));
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".add(value[i]);");
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("}");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createManyAdder(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createManyAdderDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyAdderBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyAdderBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".add(value);");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    private void createManyRemover(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createManyRemoverDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyRemoverBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyRemoverBody(Package pkg, Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".remove(value);");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append(this.endBody());
    }

    protected String createStaticFieldDeclarations(Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("/** The SDO namespace URI associated with the SDO Type for this class */");
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("public static final String NAMESPACE_URI = \"");
        buf.append(clss.getUri());
        buf.append("\";");
        return buf.toString();
    }

    protected String createTypeDeclaration(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        JDOClassNameResolver classNameResolver = new JDOClassNameResolver();
        buf.append("public class ");
        buf.append(classNameResolver.getName(clss));
        buf.append(" extends ");
        buf.append(Entity.class.getName());
        return buf.toString();
    }

    protected String createPrivateFieldDeclaration(Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        TypeClassInfo typeClassName = this.getTypeClassName(field.getType());
        String fieldName = this.buildPrivateFieldName(clss, field);
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("private ");
        if (!field.isMany()) {
            buf.append(typeClassName.getSimpleName());
            buf.append(" ");
            buf.append(fieldName);
            buf.append(";");
        } else {
            buf.append("List<");
            buf.append(typeClassName.getCollectionSimpleName());
            buf.append("> ");
            buf.append(fieldName);
            buf.append(" = new ArrayList<");
            buf.append(typeClassName.getCollectionSimpleName());
            buf.append(">();");
        }
        return buf.toString();
    }

    private String buildPrivateFieldName(Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        buf.append("");
        buf.append(field.getName());
        if (field.isMany()) {
            buf.append("");
        }
        return buf.toString();
    }

    protected String createThirdPartyImportDeclarations(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        if (!this.hasOnlySingilarFieldsDeep(clss)) {
            buf.append(LINE_SEP);
            buf.append(this.createImportDeclaration(pkg, clss, List.class.getName()));
            buf.append(LINE_SEP);
            buf.append(this.createImportDeclaration(pkg, clss, ArrayList.class.getName()));
        }
        return buf.toString();
    }
}

