/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.config;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.env.EnvProperties;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.config.Artifact;
import org.plasma.config.ConfigUtils;
import org.plasma.config.ConfigurationException;
import org.plasma.config.DataAccessProvider;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.DataAccessService;
import org.plasma.config.DataStoreType;
import org.plasma.config.ImplementationProvisioning;
import org.plasma.config.Namespace;
import org.plasma.config.NamespaceLink;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.NonExistantNamespaceException;
import org.plasma.config.PlasmaConfigDataBinding;
import org.plasma.config.PlasmaConfigValidationEventHandler;
import org.plasma.config.PlasmaConfiguration;
import org.plasma.config.Property;
import org.plasma.config.PropertyBinding;
import org.plasma.config.QueryDSLProvisioning;
import org.plasma.config.RDBMSVendorName;
import org.plasma.config.Repository;
import org.plasma.config.SDO;
import org.plasma.config.TypeBinding;
import org.plasma.config.adapter.NamespaceAdapter;
import org.plasma.config.adapter.PropertyBindingAdapter;
import org.plasma.config.adapter.TypeBindingAdapter;
import org.xml.sax.SAXException;

public class PlasmaConfig {
    private static Log log = LogFactory.getLog(PlasmaConfig.class);
    private static PlasmaConfig instance = null;
    private static final String defaultConfigFileName = "plasma-config.xml";
    private String configFileName;
    private long configFileLastModifiedDate = System.currentTimeMillis();
    private PlasmaConfiguration config;
    private Map<String, Artifact> artifactMap = new HashMap<String, Artifact>();
    private Map<String, NamespaceAdapter> sdoNamespaceMap = new HashMap<String, NamespaceAdapter>();
    private DataAccessProviderName defaultProviderName;
    private Map<DataStoreType, Map<String, NamespaceLink>> dataStoreNamespaceLinkMap = new HashMap<DataStoreType, Map<String, NamespaceLink>>();
    private Map<DataAccessProviderName, DataAccessProvider> dataAccessProviderMap = new HashMap<DataAccessProviderName, DataAccessProvider>();
    private Map<DataAccessProviderName, Map<String, NamespaceProvisioning>> dataAccessProviderProvisioningMap = new HashMap<DataAccessProviderName, Map<String, NamespaceProvisioning>>();
    private Map<DataAccessProviderName, Map<String, Property>> dataAccessProviderPropertyMap = new HashMap<DataAccessProviderName, Map<String, Property>>();

    private PlasmaConfig() {
        log.debug((Object)"initializing...");
        try {
            this.configFileName = EnvProperties.instance().getProperty("plasma.configuration");
            if (this.configFileName == null) {
                this.configFileName = defaultConfigFileName;
            }
            PlasmaConfigDataBinding configBinding = new PlasmaConfigDataBinding(new PlasmaConfigValidationEventHandler());
            this.config = this.unmarshalConfig(this.configFileName, configBinding);
            for (Artifact artifact : this.config.getRepository().getArtifacts()) {
                this.artifactMap.put(artifact.getNamespaceUri(), artifact);
            }
            if (this.artifactMap.get(this.config.getSDO().getDefaultNamespace().getArtifact()) == null) {
                throw new ConfigurationException("Invalid SDO Namespace - could not find repository artifact based on URI '" + this.config.getSDO().getDefaultNamespace().getArtifact() + "'");
            }
            this.sdoNamespaceMap.put(this.config.getSDO().getDefaultNamespace().getUri(), new NamespaceAdapter(this.config.getSDO().getDefaultNamespace()));
            for (Namespace namespace : this.config.getSDO().getNamespaces()) {
                if (this.artifactMap.get(namespace.getArtifact()) == null) {
                    throw new ConfigurationException("Invalid SDO Namespace - could not find repository artifact based on URI '" + namespace.getArtifact() + "'");
                }
                if (this.sdoNamespaceMap.get(namespace.getUri()) != null) {
                    throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with URI '" + namespace.getUri() + "' already exists " + "within the configucation");
                }
                if (namespace.getProvisioning() == null) {
                    NamespaceProvisioning provisioning = this.createDefaultProvisioning(namespace.getUri());
                    namespace.setProvisioning(provisioning);
                }
                NamespaceAdapter namespaceAdapter = new NamespaceAdapter(namespace);
                this.sdoNamespaceMap.put(namespace.getUri(), namespaceAdapter);
                if (this.sdoNamespaceMap.get(namespace.getProvisioning().getPackageName()) != null) {
                    throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with provisioning package name '" + namespace.getProvisioning().getPackageName() + "' already exists " + "within the configucation");
                }
                this.sdoNamespaceMap.put(namespace.getProvisioning().getPackageName(), namespaceAdapter);
                for (TypeBinding typeBinding : namespace.getTypeBindings()) {
                    namespaceAdapter.addTypeBinding(typeBinding);
                }
            }
            for (String artifactUri : this.artifactMap.keySet()) {
                Artifact artifact = this.artifactMap.get(artifactUri);
                if (this.sdoNamespaceMap.get(artifact.getNamespaceUri()) != null) continue;
                Namespace namespace = new Namespace();
                namespace.setArtifact(artifact.getNamespaceUri());
                namespace.setUri(artifact.getNamespaceUri());
                NamespaceProvisioning provisioning = this.createDefaultProvisioning(artifact.getNamespaceUri());
                namespace.setProvisioning(provisioning);
                NamespaceAdapter namespaceAdapter = new NamespaceAdapter(namespace);
                this.sdoNamespaceMap.put(namespace.getUri(), namespaceAdapter);
            }
            for (DataAccessService daconfig : this.config.getSDO().getDataAccessServices()) {
                for (DataAccessProvider provider : daconfig.getDataAccessProviders()) {
                    Map<String, NamespaceLink> linkMap;
                    if (this.defaultProviderName == null) {
                        this.defaultProviderName = provider.name;
                    }
                    this.dataAccessProviderMap.put(provider.getName(), provider);
                    Map<String, NamespaceProvisioning> provMap = this.dataAccessProviderProvisioningMap.get((Object)provider.getName());
                    if (provMap == null) {
                        provMap = new HashMap<String, NamespaceProvisioning>();
                        this.dataAccessProviderProvisioningMap.put(provider.getName(), provMap);
                    }
                    if ((linkMap = this.dataStoreNamespaceLinkMap.get((Object)daconfig.getDataStoreType())) == null) {
                        linkMap = new HashMap<String, NamespaceLink>();
                        this.dataStoreNamespaceLinkMap.put(daconfig.getDataStoreType(), linkMap);
                    }
                    for (NamespaceLink namespaceLink : provider.getNamespaceLinks()) {
                        if (namespaceLink.getUri() == null) {
                            throw new ConfigurationException("expected namespace URI for Data Access Service configuration '" + provider.getName().toString() + "'");
                        }
                        linkMap.put(namespaceLink.getUri(), namespaceLink);
                        NamespaceAdapter adapter = this.sdoNamespaceMap.get(namespaceLink.getUri());
                        if (adapter == null) {
                            throw new ConfigurationException("Invalid SDO Namespace - could not find SDO namespace based on namespace URI '" + namespaceLink.getUri() + "' for Data Access Service configuration '" + provider.getName().toString() + "'");
                        }
                        if (adapter.getNamespace().getProvisioning() != null && adapter.getNamespace().getProvisioning().getPackageName() != null && namespaceLink.getProvisioning() != null && adapter.getNamespace().getProvisioning().getPackageName().equals(namespaceLink.getProvisioning().getPackageName())) {
                            throw new ConfigurationException("Duplicate provisioning package name (" + namespaceLink.getProvisioning().getPackageName() + ") for SDO Namespace '" + namespaceLink.getUri() + "' and Data Access Service configuration '" + provider.getName().toString() + "'");
                        }
                        if (namespaceLink.getProvisioning() == null) continue;
                        provMap.put(namespaceLink.getUri(), namespaceLink.getProvisioning());
                    }
                    Map<String, Property> propertyMap = this.dataAccessProviderPropertyMap.get((Object)provider.getName());
                    if (propertyMap == null) {
                        propertyMap = new HashMap<String, Property>();
                        this.dataAccessProviderPropertyMap.put(provider.getName(), propertyMap);
                    }
                    for (Property property : provider.getProperties()) {
                        propertyMap.put(property.getName(), property);
                    }
                }
            }
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(e);
        }
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public long getConfigFileLastModifiedDate() {
        return this.configFileLastModifiedDate;
    }

    public DataAccessProviderName getDefaultProviderName() {
        return this.defaultProviderName;
    }

    private NamespaceProvisioning createDefaultProvisioning(String uri) {
        NamespaceProvisioning provisioning = new NamespaceProvisioning();
        String[] tokens = ConfigUtils.toPackageTokens(uri);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(tokens[i]);
            ++i;
        }
        provisioning.setPackageName(buf.toString());
        return provisioning;
    }

    private PlasmaConfiguration unmarshalConfig(String configFileName, PlasmaConfigDataBinding binding) {
        try {
            File urlFile;
            InputStream stream = PlasmaConfig.class.getResourceAsStream(configFileName);
            if (stream == null) {
                stream = PlasmaConfig.class.getClassLoader().getResourceAsStream(configFileName);
            }
            if (stream == null) {
                throw new ConfigurationException("could not find configuration file resource '" + configFileName + "' on the current classpath");
            }
            PlasmaConfiguration result = (PlasmaConfiguration)binding.validate(stream);
            URL url = PlasmaConfig.class.getResource(configFileName);
            if (url == null) {
                url = PlasmaConfig.class.getClassLoader().getResource(configFileName);
            }
            if (url != null && (urlFile = new File(url.getFile())).exists()) {
                this.configFileLastModifiedDate = urlFile.lastModified();
            }
            return result;
        }
        catch (UnmarshalException e) {
            throw new ConfigurationException(e);
        }
        catch (JAXBException e) {
            throw new ConfigurationException(e);
        }
    }

    public void marshal(OutputStream stream) {
        try {
            PlasmaConfigDataBinding configBinding = new PlasmaConfigDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            configBinding.marshal(this.config, stream);
        }
        catch (JAXBException e1) {
            throw new ConfigurationException(e1);
        }
        catch (SAXException e1) {
            throw new ConfigurationException(e1);
        }
    }

    public static PlasmaConfig getInstance() throws PlasmaRuntimeException {
        if (instance == null) {
            PlasmaConfig.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws PlasmaRuntimeException {
        if (instance == null) {
            instance = new PlasmaConfig();
        }
    }

    public PlasmaConfiguration getConfig() {
        return this.config;
    }

    public SDO getSDO() {
        return this.config.getSDO();
    }

    public Namespace getSDONamespaceByURI(String uri) {
        NamespaceAdapter result = this.sdoNamespaceMap.get(uri);
        if (result != null) {
            return result.getNamespace();
        }
        throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
    }

    public Namespace getSDONamespaceByInterfacePackage(String packageName) {
        NamespaceAdapter result = this.sdoNamespaceMap.get(packageName);
        if (result != null) {
            return result.getNamespace();
        }
        throw new ConfigurationException("no configured SDO namespace found for interface package name '" + packageName + "'");
    }

    public TypeBinding findTypeBinding(String uri, String typeName) {
        NamespaceAdapter namespaceAdapter = this.sdoNamespaceMap.get(uri);
        if (namespaceAdapter != null) {
            TypeBindingAdapter resultAdapter = namespaceAdapter.findTypeBinding(typeName);
            if (resultAdapter != null) {
                return resultAdapter.getBinding();
            }
            return null;
        }
        throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
    }

    public void remapTypeBinding(String uri, TypeBinding typeBinding) {
        NamespaceAdapter namespaceAdapter = this.sdoNamespaceMap.get(uri);
        if (namespaceAdapter == null) {
            throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
        }
        namespaceAdapter.remapTypeBinding(typeBinding);
    }

    public PropertyBinding findPropertyBinding(String uri, String typeName, String propertyName) {
        NamespaceAdapter namespaceAdapter = this.sdoNamespaceMap.get(uri);
        if (namespaceAdapter != null) {
            TypeBindingAdapter typeBinding = namespaceAdapter.findTypeBinding(typeName);
            if (typeBinding != null) {
                PropertyBindingAdapter resultAdapter = typeBinding.findPropertyBinding(propertyName);
                if (resultAdapter != null) {
                    return resultAdapter.getBinding();
                }
                return null;
            }
            return null;
        }
        throw new ConfigurationException("no configured SDO namespace found for URI '" + uri + "'");
    }

    public void addDynamicSDONamespace(String uri, String supplierUri) {
        Namespace namespace = new Namespace();
        namespace.setArtifact(uri);
        namespace.setUri(uri);
        if (this.sdoNamespaceMap.get(namespace.getUri()) != null) {
            throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with URI '" + namespace.getUri() + "' already exists " + "within the configucation");
        }
        this.sdoNamespaceMap.put(uri, new NamespaceAdapter(namespace));
        for (Map<String, NamespaceProvisioning> map : this.dataAccessProviderProvisioningMap.values()) {
            Iterator<String> iter = map.keySet().iterator();
            NamespaceProvisioning provisioning = null;
            while (iter.hasNext()) {
                String key = iter.next();
                if (!key.equals(supplierUri)) continue;
                provisioning = map.get(key);
            }
            if (provisioning == null) continue;
            map.put(uri, provisioning);
        }
    }

    public void addDynamicSDONamespace(String uri, String artifact, NamespaceProvisioning provisioning) {
        Namespace namespace = new Namespace();
        namespace.setArtifact(artifact);
        namespace.setUri(uri);
        namespace.setProvisioning(provisioning);
        if (this.sdoNamespaceMap.get(namespace.getUri()) != null) {
            throw new ConfigurationException("duplicate SDO namespace configuration - a namespace with URI '" + namespace.getUri() + "' already exists " + "within the configucation");
        }
        this.sdoNamespaceMap.put(uri, new NamespaceAdapter(namespace));
    }

    public DataAccessProvider findDataAccessProvider(DataAccessProviderName providerName) {
        DataAccessProvider result = this.dataAccessProviderMap.get((Object)providerName);
        return result;
    }

    public DataAccessProvider getDataAccessProvider(DataAccessProviderName providerName) {
        DataAccessProvider result = this.dataAccessProviderMap.get((Object)providerName);
        if (result != null) {
            return result;
        }
        throw new ConfigurationException("no data access provider configuration found for '" + providerName.value() + "'");
    }

    public RDBMSVendorName getRDBMSProviderVendor(DataAccessProviderName providerName) {
        DataAccessProvider provider = this.dataAccessProviderMap.get((Object)providerName);
        if (provider == null) {
            throw new ConfigurationException("no data access provider configuration found for '" + providerName.value() + "'");
        }
        RDBMSVendorName vendor = null;
        switch (providerName) {
            case JDBC: 
            case JDO: 
            case JPA: 
            case HIBERNATE: {
                Property vendorProp = this.findProviderPropertyByName(provider, "org.plasma.sdo.access.provider.jdbc.Vendor");
                if (vendorProp != null) {
                    vendor = this.getVendorName(provider, vendorProp);
                    break;
                }
                log.debug((Object)("no vendor property (org.plasma.sdo.access.provider.jdbc.Vendor) found for provider '" + providerName.value() + "'- searching for vendor based on JDBC driver name"));
                Property driverProp = this.findProviderPropertyByName(provider, "org.plasma.sdo.access.provider.jdbc.ConnectionDriverName");
                if (driverProp != null) {
                    vendor = this.matchVendorName(driverProp);
                }
                if (vendor != null) break;
                throw new ConfigurationException("could not determine RDBMS vendor for provider '" + providerName.value() + "' - no vendor property (" + "org.plasma.sdo.access.provider.jdbc.Vendor" + ")" + " or driver (" + "org.plasma.sdo.access.provider.jdbc.ConnectionDriverName" + ") properties found");
            }
            default: {
                throw new ConfigurationException("could not determine RDBMS vendor for non-RDBMS provider '" + providerName.value() + "'");
            }
        }
        return vendor;
    }

    /*
     * Unable to fully structure code
     */
    private RDBMSVendorName getVendorName(DataAccessProvider provider, Property prop) {
        try {
            return RDBMSVendorName.valueOf(prop.getValue());
        }
        catch (IllegalArgumentException e) {
            buf = new StringBuilder();
            i = 0;
            ** while (i < RDBMSVendorName.values().length)
        }
lbl-1000:
        // 1 sources

        {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(RDBMSVendorName.values()[i].name());
            ++i;
            continue;
        }
lbl14:
        // 1 sources

        throw new ConfigurationException("could not determine RDBMS vendor for provider '" + provider.getName().value() + "' based on property value '" + prop.getValue() + "' - expected one of [" + buf.toString() + "]");
    }

    private RDBMSVendorName matchVendorName(Property prop) {
        RDBMSVendorName[] rDBMSVendorNameArray = RDBMSVendorName.values();
        int n = rDBMSVendorNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            RDBMSVendorName vendor = rDBMSVendorNameArray[n2];
            if (prop.getValue().toLowerCase().contains(vendor.name().toLowerCase())) {
                return vendor;
            }
            ++n2;
        }
        return null;
    }

    private Property findProviderPropertyContainingValue(DataAccessProvider provider, String value) {
        for (Property prop : provider.getProperties()) {
            if (prop.getValue() == null || !prop.getValue().toLowerCase().contains(value)) continue;
            return prop;
        }
        return null;
    }

    private Property findProviderPropertyByName(DataAccessProvider provider, String name) {
        Map<String, Property> propertyMap = this.dataAccessProviderPropertyMap.get((Object)provider.getName());
        if (propertyMap != null) {
            return propertyMap.get(name);
        }
        return null;
    }

    public NamespaceProvisioning getProvisioningByNamespaceURI(DataAccessProviderName providerName, String uri) {
        NamespaceProvisioning result;
        Map<String, NamespaceProvisioning> providerProvisionMap = this.dataAccessProviderProvisioningMap.get((Object)providerName);
        if (providerProvisionMap != null && (result = providerProvisionMap.get(uri)) != null) {
            return result;
        }
        throw new NonExistantNamespaceException("no configured '" + providerName.value() + "' provider namespace found for URI '" + uri + "'");
    }

    public boolean hasNamespace(DataStoreType dataStore) {
        return this.dataStoreNamespaceLinkMap.get((Object)dataStore) != null;
    }

    public Repository getRepository() {
        return this.config.getRepository();
    }

    public String getSDOInterfaceClassName(String uri, String name) {
        String result = name;
        Namespace namespace = this.getSDONamespaceByURI(uri);
        return result;
    }

    public String getSDOInterfacePackageName(String uri) {
        Namespace sdoNamespace = this.getSDONamespaceByURI(uri);
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        return packageName;
    }

    public String getSDOImplementationClassName(String uri, String name) {
        String result = name;
        Namespace namespace = this.getSDONamespaceByURI(uri);
        if (namespace != null) {
            String prefix = null;
            String suffix = null;
            if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getImplementation() != null) {
                ImplementationProvisioning prov = this.getSDO().getGlobalProvisioning().getImplementation();
                prefix = prov.getClassNamePrefix();
                suffix = prov.getClassNameSuffix();
            }
            if (prefix != null && prefix.trim().length() > 0) {
                result = String.valueOf(prefix) + result;
            }
            if (suffix != null && suffix.trim().length() > 0) {
                result = String.valueOf(result) + suffix;
            }
            return result;
        }
        return null;
    }

    public String getSDOImplementationPackageName(String uri) {
        Namespace sdoNamespace = this.getSDONamespaceByURI(uri);
        if (sdoNamespace != null && sdoNamespace.getProvisioning() != null) {
            String packageName = sdoNamespace.getProvisioning().getPackageName();
            String subpackage = null;
            if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getImplementation() != null) {
                ImplementationProvisioning prov = this.getSDO().getGlobalProvisioning().getImplementation();
                subpackage = prov.getChildPackageName();
            }
            if (subpackage != null && subpackage.trim().length() > 0) {
                packageName = String.valueOf(packageName) + "." + subpackage;
            }
            return packageName;
        }
        return null;
    }

    public boolean generateQueryDSL(String uri, String name) {
        Namespace namespace = this.getSDONamespaceByURI(uri);
        if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getQueryDSL() != null) {
            QueryDSLProvisioning queryDsl = this.getSDO().getGlobalProvisioning().getQueryDSL();
            if (!queryDsl.isGenerate()) {
                return false;
            }
            NamespaceProvisioning prov = namespace.getProvisioning();
            if (prov != null && prov.getQueryDSL() != null && !prov.getQueryDSL().isGenerate()) {
                return false;
            }
        }
        return true;
    }

    public String getQueryDSLImplementationClassName(String uri, String name) {
        String result = name;
        Namespace namespace = this.getSDONamespaceByURI(uri);
        if (namespace != null) {
            QueryDSLProvisioning queryDsl;
            String prefix = null;
            String suffix = null;
            if (this.getSDO() != null && this.getSDO().getGlobalProvisioning() != null && this.getSDO().getGlobalProvisioning().getQueryDSL() != null && (queryDsl = this.getSDO().getGlobalProvisioning().getQueryDSL()).getImplementation() != null) {
                ImplementationProvisioning prov = queryDsl.getImplementation();
                prefix = prov.getClassNamePrefix();
                suffix = prov.getClassNameSuffix();
            }
            if (prefix != null && prefix.trim().length() > 0) {
                result = String.valueOf(prefix) + result;
            }
            if (suffix != null && suffix.trim().length() > 0) {
                result = String.valueOf(result) + suffix;
            }
            return result;
        }
        return null;
    }

    public String getServiceImplementationClassName(DataAccessProviderName providerName, String uri, String name) {
        String result = name;
        DataAccessProvider config = this.getDataAccessProvider(providerName);
        Namespace namespace = this.getSDONamespaceByURI(uri);
        return result;
    }

    public String getServiceImplementationPackageName(DataAccessProviderName serviceName, String uri) {
        NamespaceProvisioning provisioning = this.getProvisioningByNamespaceURI(serviceName, uri);
        Namespace namespace = this.getSDONamespaceByURI(uri);
        return provisioning.getPackageName();
    }
}

