/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import commonj.sdo.DataGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.ProvisioningModelAssembler;
import org.plasma.provisioning.ProvisioningModelDataBinding;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.ProvisioningTarget;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.QueryToolAction;
import org.plasma.query.Query;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.access.client.SDODataAccessClient;
import org.plasma.sdo.core.CoreXMLDocument;
import org.plasma.sdo.helper.PlasmaXSDHelper;
import org.plasma.sdo.xml.MarshallerException;
import org.plasma.sdo.xml.StreamMarshaller;
import org.plasma.xml.uml.UMLModelAssembler;
import org.xml.sax.SAXException;

public class QueryTool
extends ProvisioningTool {
    private static Log log = LogFactory.getLog(QueryTool.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$plasma$provisioning$cli$ProvisioningTarget;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$plasma$provisioning$cli$QueryToolAction;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws TransformerConfigurationException, IOException, TransformerException, ClassNotFoundException {
        block18: {
            if (args.length != 6) {
                QueryTool.printUsage();
                return;
            }
            if (!args[0].startsWith("-")) {
                QueryTool.printUsage();
                return;
            }
            command = QueryToolAction.valueOf(args[0].substring(1));
            sourceFile = new File(args[1]);
            if (!sourceFile.exists()) {
                throw new IllegalArgumentException("given source file '" + args[1] + "' does not exist");
            }
            destFile = new File(args[2]);
            if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("directory path cannot be created for given dest file '" + args[2] + "' ");
            }
            destFileType = args[3];
            if (destFileType == null || destFileType.trim().length() == 0) {
                throw new IllegalArgumentException("expected argument, destFileType");
            }
            targetType = null;
            try {
                targetType = ProvisioningTarget.valueOf(destFileType);
                break block18;
            }
            catch (IllegalArgumentException e) {
                displayValues = new ArrayList<String>();
                var11_10 = ProvisioningTarget.values();
                var10_11 = var11_10.length;
                var9_12 = 0;
                ** while (var9_12 < var10_11)
            }
lbl-1000:
            // 1 sources

            {
                v = var11_10[var9_12];
                displayValues.add(v.name());
                ++var9_12;
                continue;
            }
lbl32:
            // 1 sources

            throw new IllegalArgumentException("unknown target type '" + destFileType + "' - expected one of " + displayValues);
        }
        destNamespaceURI = args[4];
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument, destNamespaceURI");
        }
        destNamespacePrefix = args[5];
        if (destNamespacePrefix == null || destNamespacePrefix.trim().length() == 0) {
            destNamespacePrefix = "tns";
        }
        block1 : switch (QueryTool.$SWITCH_TABLE$org$plasma$provisioning$cli$QueryToolAction()[command.ordinal()]) {
            case 1: {
                baseTempDir = new File(System.getProperty("java.io.tmpdir"));
                switch (QueryTool.$SWITCH_TABLE$org$plasma$provisioning$cli$ProvisioningTarget()[targetType.ordinal()]) {
                    case 1: {
                        QueryTool.log.info((Object)"compiling query into XML Schema model");
                        QueryTool.generateXMLSchemaModel(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                        break block1;
                    }
                    case 2: {
                        QueryTool.log.info((Object)"compiling query into UML/XMI model");
                        QueryTool.generateUMLModel(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                        break block1;
                    }
                }
                throw new IllegalArgumentException("unknown target type '" + targetType.name() + "'");
            }
            case 2: {
                QueryTool.log.info((Object)"running query");
                QueryTool.run(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                QueryTool.log.info((Object)("successfully provisioned XML to, " + destFile.getName()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown command '" + command.toString() + "'");
            }
        }
    }

    private static void run(File queryFile, File destFile, String destNamespaceURI, String destNamespacePrefix) {
        FileOutputStream xmlos;
        log.info((Object)("unmarshaling query file '" + queryFile.getName() + "'"));
        String rootElementName = "Data";
        Query query = QueryTool.unmarshalQuery(queryFile);
        SDODataAccessClient service = new SDODataAccessClient();
        DataGraph[] results = service.find(query);
        try {
            xmlos = new FileOutputStream(destFile);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        int i = 0;
        while (i < results.length) {
            PlasmaDataObject dataObject = (PlasmaDataObject)results[i].getRootObject();
            CoreXMLDocument doc = new CoreXMLDocument(dataObject, destNamespaceURI, rootElementName);
            StreamMarshaller assembler = new StreamMarshaller(doc);
            try {
                assembler.marshal(xmlos);
            }
            catch (XMLStreamException e) {
                throw new PlasmaRuntimeException((Throwable)e);
            }
            catch (MarshallerException e) {
                throw new PlasmaRuntimeException((Throwable)e);
            }
            ++i;
        }
    }

    private static void generateUMLModel(File queryFile, File destFile, String destNamespaceURI, String destNamespacePrefix) {
        log.info((Object)("unmarshaling query file '" + queryFile.getName() + "'"));
        Query query = QueryTool.unmarshalQuery(queryFile);
        ProvisioningModelAssembler stagingAssembler = new ProvisioningModelAssembler(query, destNamespaceURI, destNamespacePrefix);
        Model model = stagingAssembler.getModel();
        try {
            FileOutputStream os = new FileOutputStream(new File(destFile.getParentFile(), "query-pim.xml"));
            ProvisioningModelDataBinding binding = new ProvisioningModelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            binding.marshal(model, os);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        ModelAdapter validator = new ModelAdapter(model);
        log.info((Object)"assembling XMI model");
        UMLModelAssembler modelAssembler = new UMLModelAssembler(query, destNamespaceURI, destNamespacePrefix);
        Document document = modelAssembler.getDocument();
        log.info((Object)("marshaling XMI model to file, '" + destFile.getName() + "'"));
        try {
            FileOutputStream os = new FileOutputStream(destFile);
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private static void generateXMLSchemaModel(File queryFile, File destFile, String destNamespaceURI, String destNamespacePrefix) {
        FileOutputStream ouputStream;
        log.info((Object)("unmarshaling query file '" + queryFile.getName() + "'"));
        Query query = QueryTool.unmarshalQuery(queryFile);
        try {
            ouputStream = new FileOutputStream(destFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            log.info((Object)("marshaling XML schema to file, '" + destFile.getName() + "'"));
            PlasmaXSDHelper.INSTANCE.generate(query, destNamespaceURI, destNamespacePrefix, null, ouputStream);
        }
        finally {
            try {
                ouputStream.flush();
                ouputStream.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Query unmarshalQuery(File queryFile) {
        String queryXml = null;
        try {
            byte[] queryBytes = QueryTool.readContent(new FileInputStream(queryFile));
            queryXml = new String(queryBytes);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        Query query = null;
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            if (log.isDebugEnabled()) {
                log.debug((Object)("query: " + queryXml));
            }
            query = (Query)binding.validate(queryXml);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return query;
    }

    private static void printUsage() {
        log.info((Object)"usage: -action sourceFile destFile destFileType destNamespaceURI [destNamespacePrefix]");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$plasma$provisioning$cli$ProvisioningTarget() {
        if ($SWITCH_TABLE$org$plasma$provisioning$cli$ProvisioningTarget != null) {
            return $SWITCH_TABLE$org$plasma$provisioning$cli$ProvisioningTarget;
        }
        int[] nArray = new int[ProvisioningTarget.values().length];
        try {
            nArray[ProvisioningTarget.xmi.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ProvisioningTarget.xsd.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$plasma$provisioning$cli$ProvisioningTarget = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$plasma$provisioning$cli$QueryToolAction() {
        if ($SWITCH_TABLE$org$plasma$provisioning$cli$QueryToolAction != null) {
            return $SWITCH_TABLE$org$plasma$provisioning$cli$QueryToolAction;
        }
        int[] nArray = new int[QueryToolAction.values().length];
        try {
            nArray[QueryToolAction.compile.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[QueryToolAction.run.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$plasma$provisioning$cli$QueryToolAction = nArray;
        return nArray;
    }
}

