/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.ElementNSImpl;
import org.plasma.provisioning.Body;
import org.plasma.provisioning.Documentation;
import org.plasma.provisioning.DocumentationType;
import org.plasma.provisioning.NameUtils;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.Appinfo;
import org.plasma.xml.schema.Enumeration;

public abstract class AbstractAssembler {
    private static Log log = LogFactory.getLog(AbstractAssembler.class);
    protected String destNamespaceURI;
    protected String destNamespacePrefix;
    protected ConverterSupport support;

    private AbstractAssembler() {
    }

    public AbstractAssembler(String destNamespaceURI, String destNamespacePrefix, ConverterSupport converterSupport) {
        this.destNamespaceURI = destNamespaceURI;
        this.destNamespacePrefix = destNamespacePrefix;
        this.support = converterSupport;
    }

    protected Documentation createDocumentation(DocumentationType type, String content) {
        Documentation documentation = new Documentation();
        documentation.setType(type);
        Body body = new Body();
        body.setValue(content);
        documentation.setBody(body);
        return documentation;
    }

    protected String formatLocalClassName(String localName) {
        if (localName == null || localName.trim().length() == 0) {
            throw new IllegalArgumentException("expected localName argument");
        }
        String result = localName;
        result = NameUtils.firstToUpperCase(result);
        return result;
    }

    protected String formatLocalPropertyName(String localName) {
        if (localName == null || localName.trim().length() == 0) {
            throw new IllegalArgumentException("expected localName argument");
        }
        String result = localName;
        result = NameUtils.firstToLowerCase(result);
        return result;
    }

    protected String getDocumentationContent(Annotated annotated) {
        StringBuilder buf = new StringBuilder();
        if (annotated != null && annotated.getAnnotation() != null) {
            for (Object annotationObj : annotated.getAnnotation().getAppinfosAndDocumentations()) {
                if (annotationObj instanceof org.plasma.xml.schema.Documentation) {
                    org.plasma.xml.schema.Documentation doc = (org.plasma.xml.schema.Documentation)annotationObj;
                    for (Object content : doc.getContent()) {
                        if (content instanceof String) {
                            buf.append(content);
                            continue;
                        }
                        if (content instanceof ElementNSImpl) {
                            ElementNSImpl nsElem = (ElementNSImpl)content;
                            buf.append(this.serializeElement(nsElem));
                            continue;
                        }
                        throw new IllegalStateException("unexpected content class, " + annotationObj.getClass().getName());
                    }
                    continue;
                }
                if (!(annotationObj instanceof Appinfo)) continue;
                log.warn((Object)("ignoring app-info: " + String.valueOf(annotationObj)));
            }
        }
        return buf.toString();
    }

    protected String findAppInfoValue(Enumeration schemaEnum) {
        String result = null;
        if (schemaEnum.getAnnotation() != null) {
            for (Object o2 : schemaEnum.getAnnotation().getAppinfosAndDocumentations()) {
                if (!(o2 instanceof Appinfo)) continue;
                Appinfo appinfo = (Appinfo)o2;
                result = (String)appinfo.getContent().get(0);
                if (result == null) break;
                result.trim();
                if (result.length() != 0) break;
                result = null;
                break;
            }
        }
        return result;
    }

    protected String serializeElement(ElementNSImpl nsElem) {
        String result = "";
        TransformerFactory transFactory = TransformerFactory.newInstance();
        log.debug((Object)("transformer factory: " + transFactory.getClass().getName()));
        Transformer idTransform = null;
        ByteArrayOutputStream stream = null;
        try {
            idTransform = transFactory.newTransformer();
            idTransform.setOutputProperty("method", "xml");
            idTransform.setOutputProperty("indent", "yes");
            idTransform.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource input = new DOMSource(nsElem.getOwnerDocument());
            stream = new ByteArrayOutputStream();
            StreamResult output = new StreamResult(stream);
            idTransform.transform(input, output);
            stream.flush();
            String string = result = new String(stream.toByteArray());
            return string;
        }
        catch (TransformerConfigurationException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }
}

