/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Alias;
import org.plasma.provisioning.Body;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.DataTypeRef;
import org.plasma.provisioning.Documentation;
import org.plasma.provisioning.DocumentationType;
import org.plasma.provisioning.Enumeration;
import org.plasma.provisioning.EnumerationConstraint;
import org.plasma.provisioning.EnumerationRef;
import org.plasma.provisioning.Key;
import org.plasma.provisioning.KeyType;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.SchemaConverter;
import org.plasma.provisioning.Sort;
import org.plasma.provisioning.ValueConstraint;
import org.plasma.provisioning.VisibilityType;
import org.plasma.provisioning.XmlNodeType;
import org.plasma.provisioning.XmlProperty;
import org.plasma.provisioning.xsd.ConstraintAssembler;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.provisioning.xsd.EnumerationAssembler;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.Attribute;
import org.plasma.xml.schema.ComplexType;
import org.plasma.xml.schema.Element;
import org.plasma.xml.schema.ExplicitGroup;
import org.plasma.xml.schema.ExtensionType;
import org.plasma.xml.schema.Facet;
import org.plasma.xml.schema.LocalElement;
import org.plasma.xml.schema.LocalSimpleType;
import org.plasma.xml.schema.Restriction;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaUtil;
import org.plasma.xml.schema.SimpleType;

public class SDOXSchemaConverter
extends ConverterSupport
implements SchemaConverter {
    private static Log log = LogFactory.getLog(SDOXSchemaConverter.class);
    private QName appNamespaceQName;
    private EnumerationAssembler enumerationAssembler;
    private ConstraintAssembler constraintAssembler;

    public SDOXSchemaConverter(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        super(schema, destNamespaceURI, destNamespacePrefix);
        this.enumerationAssembler = new EnumerationAssembler(this, destNamespaceURI, destNamespacePrefix);
        this.constraintAssembler = new ConstraintAssembler(this, destNamespaceURI, destNamespacePrefix);
    }

    @Override
    public Model buildModel() {
        ComplexType complexType;
        Model model = new Model();
        model.setName(this.schema.getId());
        model.setId(UUID.randomUUID().toString());
        model.setUri(this.destNamespaceURI);
        this.appNamespaceQName = this.findOpenAttributeQNameByValue(this.schema.getTargetNamespace(), this.schema);
        for (Annotated annotated : this.schema.getSimpleTypesAndComplexTypesAndGroups()) {
            if (annotated instanceof ComplexType) {
                ComplexType complexType2 = (ComplexType)annotated;
                if (complexType2.getName().equals(SchemaUtil.getSerializationBaseTypeName())) continue;
                this.complexTypeMap.put(complexType2.getName(), complexType2);
                Class cls = this.buildClass(model, complexType2);
                this.classQualifiedNameMap.put(String.valueOf(this.destNamespaceURI) + "#" + cls.getName(), cls);
                continue;
            }
            if (annotated instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)annotated;
                this.simpleTypeMap.put(simpleType.getName(), simpleType);
                continue;
            }
            if (annotated instanceof Element) continue;
            log.warn((Object)("unknown annotated class, " + annotated.getClass().getName()));
        }
        for (Annotated annotated : this.schema.getSimpleTypesAndComplexTypesAndGroups()) {
            Element element;
            if (!(annotated instanceof Element) || (element = (Element)annotated).getName().equals(SchemaUtil.getSerializationBaseTypeName()) || (complexType = (ComplexType)this.complexTypeMap.get(element.getName())) != null) continue;
            throw new IllegalStateException("found top-level Element '" + element.getName() + "' but expected top-level " + "ComplexType with the same name (XML Schema re-use best practice)");
        }
        for (Class cls : this.classQualifiedNameMap.values()) {
            String localName = cls.getName();
            if (cls.getAlias() != null && cls.getAlias().getLocalName() != null) {
                localName = cls.getAlias().getLocalName();
            }
            complexType = (ComplexType)this.complexTypeMap.get(localName);
            List<Annotated> annotatedList = null;
            annotatedList = complexType.getComplexContent() == null ? complexType.getAttributesAndAttributeGroups() : complexType.getComplexContent().getExtension().getAttributesAndAttributeGroups();
            for (Annotated annot : annotatedList) {
                if (annot instanceof Attribute) {
                    Attribute attribute = (Attribute)annot;
                    Property property = this.buildDatatypeProperty(complexType, attribute);
                    cls.getProperties().add(property);
                    continue;
                }
                throw new IllegalStateException("unexpected ComplexType child class, " + annot.getClass().getName());
            }
            ExplicitGroup sequence = null;
            sequence = complexType.getComplexContent() == null ? complexType.getSequence() : complexType.getComplexContent().getExtension().getSequence();
            if (sequence == null) continue;
            int i = 0;
            while (i < sequence.getElementsAndGroupsAndAlls().size()) {
                JAXBElement element;
                Object obj = sequence.getElementsAndGroupsAndAlls().get(i);
                if (obj instanceof JAXBElement) {
                    element = (JAXBElement)obj;
                    if (!(element.getValue() instanceof LocalElement)) {
                        throw new IllegalStateException("unexpected JAXBElement value class, " + element.getValue().getClass().getName());
                    }
                } else {
                    throw new IllegalStateException("unexpected sequence child class, " + obj.getClass().getName());
                }
                LocalElement localElement = (LocalElement)element.getValue();
                Property property = this.buildProperty(complexType, localElement, i);
                cls.getProperties().add(property);
                ++i;
            }
        }
        for (Class cls : this.classQualifiedNameMap.values()) {
            Property[] props = new Property[cls.getProperties().size()];
            cls.getProperties().toArray(props);
            Property[] propertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                Object prop = propertyArray[n2];
                if (!(((Property)prop).getType() instanceof DataTypeRef)) {
                    ClassRef classRef = (ClassRef)((Property)prop).getType();
                    String qualifiedName = String.valueOf(classRef.getUri()) + "#" + classRef.getName();
                    Class targetClass = (Class)this.classQualifiedNameMap.get(qualifiedName);
                    if (targetClass == null) {
                        throw new IllegalStateException("no class definition found for qualified name '" + qualifiedName + "'");
                    }
                    Property targetProperty = null;
                    Property[] pdefs2 = new Property[targetClass.getProperties().size()];
                    targetClass.getProperties().toArray(pdefs2);
                    Property[] propertyArray2 = pdefs2;
                    int n3 = pdefs2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Property pdef2 = propertyArray2[n4];
                        if (pdef2.getName().equals(((Property)prop).getOpposite())) {
                            targetProperty = pdef2;
                            break;
                        }
                        ++n4;
                    }
                    if (targetProperty == null && ((Property)prop).getOpposite() != null) {
                        targetProperty = this.createDerivedPropertyOpposite(cls, (Property)prop);
                        targetClass.getProperties().add(targetProperty);
                    }
                }
                ++n2;
            }
        }
        for (SimpleType simpleType : this.simpleTypeMap.values()) {
            Enumeration enm = this.enumerationAssembler.buildEnumeration(simpleType);
            model.getEnumerations().add(enm);
        }
        return model;
    }

    private Class buildClass(Package pkg, ComplexType complexType) {
        ExtensionType baseType;
        QName base;
        Class clss = new Class();
        pkg.getClazzs().add(clss);
        clss.setId(UUID.randomUUID().toString());
        clss.setUri(this.destNamespaceURI);
        Alias alias = new Alias();
        clss.setAlias(alias);
        alias.setLocalName(complexType.getName());
        String name = this.getSDOXValue(complexType, "name");
        clss.setName(name);
        String physicalNameAlias = this.findSDOXValue(complexType, "aliasName");
        if (physicalNameAlias != null) {
            alias.setPhysicalName(physicalNameAlias);
        }
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent(complexType));
        clss.getDocumentations().add(documentation);
        if (complexType.getComplexContent() != null && !(base = (baseType = complexType.getComplexContent().getExtension()).getBase()).getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
            ClassRef baseRef = new ClassRef();
            baseRef.setName(base.getLocalPart());
            baseRef.setUri(this.destNamespaceURI);
            clss.getSuperClasses().add(baseRef);
        }
        return clss;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Property buildProperty(ComplexType complexType, LocalElement element, int sequenceNum) {
        QName typeQName;
        QName aliasQName;
        String physicalNameAlias;
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        Alias alias = new Alias();
        property.setAlias(alias);
        alias.setLocalName(element.getName());
        QName nameQName = new QName("commonj.sdo/xml", "name", "sdox");
        String name = this.getOpenAttributeValue(nameQName, element);
        property.setName(name);
        XmlProperty xmlProp = new XmlProperty();
        xmlProp.setNodeType(XmlNodeType.ELEMENT);
        property.setXmlProperty(xmlProp);
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent(element));
        property.getDocumentations().add(documentation);
        property.setVisibility(VisibilityType.PUBLIC);
        if ("1".equals(String.valueOf(element.getMinOccurs()))) {
            property.setNullable(false);
        }
        if ((physicalNameAlias = this.findOpenAttributeValue(aliasQName = new QName("commonj.sdo/xml", "aliasName", "sdox"), element)) != null) {
            alias.setPhysicalName(physicalNameAlias);
        } else if (!"unbounded".equals(element.getMaxOccurs())) {
            log.warn((Object)("expected SDOX 'aliasName' attribute for local Element '" + element.getName() + "' for ComplexType '" + complexType.getName() + "'"));
        }
        QName manyQName = new QName("commonj.sdo/xml", "many", "sdox");
        Boolean many = new Boolean(this.getOpenAttributeValue(manyQName, element));
        if (many.booleanValue()) {
            property.setMany(true);
        } else {
            property.setMany(false);
        }
        QName keyQName = new QName("commonj.sdo/xml", "key", "sdox");
        Boolean isKey = new Boolean(this.findOpenAttributeValue(keyQName, element));
        if (isKey.booleanValue()) {
            property.setVisibility(VisibilityType.PRIVATE);
            Key key = new Key();
            key.setType(KeyType.PRIMARY);
            property.setKey(key);
        }
        if ((typeQName = element.getType()).getPrefix() == null || this.appNamespaceQName != null && typeQName.getPrefix().equals(this.appNamespaceQName.getPrefix())) {
            QName datatypeQName;
            Class targetDef;
            QName oppositeQName = new QName("commonj.sdo/xml", "oppositeProperty", "sdox");
            String oppositeName = this.findOpenAttributeValue(oppositeQName, element);
            if (oppositeName != null) {
                property.setOpposite(oppositeName);
            }
            if ((targetDef = (Class)this.classQualifiedNameMap.get(this.getOpenAttributeValue(datatypeQName = new QName("commonj.sdo/xml", "dataType", "sdox"), element))) == null) throw new IllegalStateException("could not find target class from, " + datatypeQName);
            ClassRef targetClassRef = new ClassRef();
            targetClassRef.setName(targetDef.getName());
            targetClassRef.setUri(targetDef.getUri());
            property.setType(targetClassRef);
            property.setContainment(true);
        } else {
            QName datatypeQName = new QName("commonj.sdo/xml", "dataType", "sdox");
            DataTypeRef dataTypeRef = new DataTypeRef();
            dataTypeRef.setName(this.getOpenAttributeValue(datatypeQName, element));
            dataTypeRef.setUri(PlasmaConfig.getInstance().getSDO().getDefaultNamespace().getUri());
            property.setType(dataTypeRef);
        }
        QName readonlyQName = new QName("commonj.sdo/xml", "readOnly", "sdox");
        Boolean isReadonly = new Boolean(this.getOpenAttributeValue(readonlyQName, element));
        property.setReadOnly(isReadonly);
        if (sequenceNum <= -1) return property;
        Sort seq = new Sort();
        seq.setKey(String.valueOf(sequenceNum));
        property.setSort(seq);
        return property;
    }

    private Property createDerivedPropertyOpposite(Class clss, Property sourceProperty) {
        Property targetProperty = new Property();
        targetProperty.setId(UUID.randomUUID().toString());
        targetProperty.setName(sourceProperty.getOpposite());
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, "private derived opposite for, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        targetProperty.getDocumentations().add(documentation);
        targetProperty.setVisibility(VisibilityType.PRIVATE);
        targetProperty.setNullable(true);
        targetProperty.setMany(true);
        targetProperty.setDerived(true);
        targetProperty.setContainment(false);
        targetProperty.setOpposite(sourceProperty.getName());
        ClassRef targetClassRef = new ClassRef();
        targetClassRef.setName(clss.getName());
        targetClassRef.setUri(clss.getUri());
        targetProperty.setType(targetClassRef);
        return targetProperty;
    }

    private Property buildDatatypeProperty(ComplexType complexType, Attribute attribute) {
        QName typeQName;
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        Alias alias = new Alias();
        property.setAlias(alias);
        alias.setLocalName(attribute.getName());
        QName nameQName = new QName("commonj.sdo/xml", "name", "sdox");
        String name = this.getOpenAttributeValue(nameQName, attribute);
        property.setName(name);
        QName aliasQName = new QName("commonj.sdo/xml", "aliasName", "sdox");
        String physicalNameAlias = this.getOpenAttributeValue(aliasQName, attribute);
        alias.setPhysicalName(physicalNameAlias);
        XmlProperty xmlProp = new XmlProperty();
        xmlProp.setNodeType(XmlNodeType.ATTRIBUTE);
        property.setXmlProperty(xmlProp);
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        body.setValue(this.getDocumentationContent(attribute));
        documentation.setBody(body);
        property.getDocumentations().add(documentation);
        property.setVisibility(VisibilityType.PUBLIC);
        if ("required".equals(attribute.getUse())) {
            property.setNullable(false);
        } else {
            property.setNullable(true);
        }
        QName manyQName = new QName("commonj.sdo/xml", "many", "sdox");
        Boolean many = new Boolean(this.getOpenAttributeValue(manyQName, attribute));
        if (many.booleanValue()) {
            property.setMany(true);
        } else {
            property.setMany(false);
        }
        QName datatypeQName = new QName("commonj.sdo/xml", "dataType", "sdox");
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(this.getOpenAttributeValue(datatypeQName, attribute));
        dataTypeRef.setUri(PlasmaConfig.getInstance().getSDO().getDefaultNamespace().getUri());
        property.setType(dataTypeRef);
        QName keyQName = new QName("commonj.sdo/xml", "key", "sdox");
        Boolean isKey = new Boolean(this.findOpenAttributeValue(keyQName, attribute));
        if (isKey.booleanValue()) {
            QName keyTypeQName = new QName("commonj.sdo/xml", "keyType", "sdox");
            String keyType = this.findOpenAttributeValue(keyTypeQName, attribute);
            property.setVisibility(VisibilityType.PRIVATE);
            Key key = new Key();
            key.setType(KeyType.valueOf(keyType.toUpperCase()));
            property.setKey(key);
        }
        if ((typeQName = attribute.getType()) != null) {
            if (typeQName.getPrefix() == null || this.appNamespaceQName != null && typeQName.getPrefix().equals(this.appNamespaceQName.getPrefix())) {
                SimpleType simpleType = (SimpleType)this.simpleTypeMap.get(typeQName.getLocalPart());
                EnumerationConstraint constraint = new EnumerationConstraint();
                EnumerationRef enumRef = new EnumerationRef();
                enumRef.setName(simpleType.getName());
                enumRef.setUri(this.destNamespaceURI);
                constraint.setValue(enumRef);
                property.setEnumerationConstraint(constraint);
            }
        } else {
            LocalSimpleType lst = attribute.getSimpleType();
            Restriction rest = lst.getRestriction();
            ValueConstraint constraint = this.constraintAssembler.buildValueConstraint(rest);
            property.setValueConstraint(constraint);
        }
        return property;
    }

    private JAXBElement<Facet> findFacet(String name, List<Object> list) {
        for (Object obj : list) {
            JAXBElement facet;
            if (!(obj instanceof JAXBElement) || !(facet = (JAXBElement)obj).getName().getLocalPart().equals(name)) continue;
            return facet;
        }
        return null;
    }
}

