/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.collector;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.plasma.query.InvalidPathPredicateException;
import org.plasma.query.QueryException;
import org.plasma.query.collector.CollectorSupport;
import org.plasma.query.collector.PropertySelection;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Select;
import org.plasma.query.model.Where;
import org.plasma.query.model.WildcardPathElement;
import org.plasma.query.model.WildcardProperty;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.sdo.PlasmaType;

@Deprecated
public class PropertySelectionCollector
extends CollectorSupport
implements PropertySelection {
    private Select select;
    private Map<Property, Where> predicateMap;
    private Map<Type, List<String>> propertyMap;
    private Map<Type, List<String>> singularPropertyMap;
    private Map<Type, List<String>> inheritedPropertyMap;

    public PropertySelectionCollector(Select select, Type rootType) {
        super(rootType);
        this.select = select;
    }

    public PropertySelectionCollector(Select select, Type rootType, boolean onlySingularProperties) {
        super(rootType, onlySingularProperties);
        this.select = select;
    }

    @Override
    public void collect(Where predicate) {
        DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

            @Override
            public void start(org.plasma.query.model.Property property) {
                PropertySelectionCollector.this.collect(property);
                super.start(property);
            }

            @Override
            public void start(WildcardProperty wildcardProperty) {
                PropertySelectionCollector.this.collect(wildcardProperty);
                super.start(wildcardProperty);
            }
        };
        predicate.accept(visitor);
    }

    private void collect() {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<Type, List<String>>();
            this.singularPropertyMap = new HashMap<Type, List<String>>();
            this.inheritedPropertyMap = new HashMap<Type, List<String>>();
            this.predicateMap = new HashMap<Property, Where>();
            DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

                @Override
                public void start(org.plasma.query.model.Property property) {
                    PropertySelectionCollector.this.collect(property);
                    super.start(property);
                }

                @Override
                public void start(WildcardProperty wildcardProperty) {
                    PropertySelectionCollector.this.collect(wildcardProperty);
                    super.start(wildcardProperty);
                }
            };
            this.select.accept(visitor);
        }
    }

    @Deprecated
    public Map<Property, Where> getPredicateMap() {
        this.collect();
        return this.predicateMap;
    }

    @Override
    public Where getPredicate(Property property) {
        if (this.predicateMap != null) {
            return this.predicateMap.get(property);
        }
        return null;
    }

    @Deprecated
    public Map<Type, List<String>> getSingularPropertyMap() {
        this.collect();
        return this.singularPropertyMap;
    }

    @Override
    public List<String> getSingularProperties(Type type) {
        this.collect();
        return this.singularPropertyMap.get(type);
    }

    @Deprecated
    public Map<Type, List<String>> getResult() {
        this.collect();
        return this.propertyMap;
    }

    @Override
    public List<String> getProperties(Type type) {
        this.collect();
        return this.propertyMap.get(type);
    }

    @Override
    public List<String> getInheritedProperties(Type type) {
        this.collect();
        return this.inheritedPropertyMap.get(type);
    }

    @Override
    public List<Type> getTypes() {
        this.collect();
        ArrayList<Type> result = new ArrayList<Type>();
        result.addAll(this.propertyMap.keySet());
        result.addAll(this.inheritedPropertyMap.keySet());
        return result;
    }

    @Override
    public boolean hasType(Type type) {
        return this.propertyMap.get(type) != null;
    }

    @Override
    public List<Type> getInheritedTypes() {
        this.collect();
        ArrayList<Type> result = new ArrayList<Type>();
        result.addAll(this.inheritedPropertyMap.keySet());
        return result;
    }

    @Override
    public boolean hasInheritedType(Type type) {
        return this.inheritedPropertyMap.get(type) != null;
    }

    @Override
    public boolean hasProperty(Type type, Property property) {
        List<String> props = this.propertyMap.get(type);
        if (props != null && props.size() > 0) {
            for (String prop : props) {
                if (!prop.equals(property.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Type> addProperty(Type rootType, String path) {
        ArrayList<Type> result = new ArrayList<Type>();
        Type contextType = rootType;
        StringBuilder buf = new StringBuilder();
        String[] tokens = path.split("/");
        int i = 0;
        while (i < tokens.length) {
            int attr;
            String token;
            int right;
            if (i > 0) {
                buf.append("/");
            }
            if ((right = (token = tokens[i]).indexOf("[")) >= 0) {
                token = token.substring(0, right);
            }
            if ((attr = token.indexOf("@")) == 0) {
                token = token.substring(1);
            }
            Property prop = contextType.getProperty(token);
            this.mapProperty(contextType, prop, this.propertyMap);
            this.mapInheritedProperty(contextType, prop, this.inheritedPropertyMap);
            if (!prop.getType().isDataType()) {
                contextType = prop.getType();
                result.add(contextType);
            }
            buf.append(prop.getName());
            ++i;
        }
        return result;
    }

    @Override
    public boolean hasInheritedProperty(Type type, Property property) {
        List<String> props = this.inheritedPropertyMap.get(type);
        if (props != null && props.size() > 0) {
            for (String prop : props) {
                if (!prop.equals(property.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void collect(AbstractProperty abstractProperty) {
        Path path = null;
        if (abstractProperty instanceof org.plasma.query.model.Property) {
            path = ((org.plasma.query.model.Property)abstractProperty).getPath();
        } else if (abstractProperty instanceof WildcardProperty) {
            path = ((WildcardProperty)abstractProperty).getPath();
        } else {
            throw new IllegalArgumentException("unknown property class, " + abstractProperty.getClass().getName());
        }
        if (path == null) {
            String[] names = this.findPropertyNames(this.rootType, abstractProperty);
            this.mapPropertyNames(this.rootType, names, this.propertyMap);
            this.mapInheritedPropertyNames(this.rootType, names, this.inheritedPropertyMap);
        } else if (!this.isOnlySingularProperties()) {
            this.collect(path, this.rootType, path.getPathNodes().get(0), 0, abstractProperty);
        } else if (this.isSingularPath(path, this.rootType, abstractProperty)) {
            this.collect(path, this.rootType, path.getPathNodes().get(0), 0, abstractProperty);
        }
    }

    private void collect(Path path, Type currType, PathNode currPathode, int curPathElementIndex, AbstractProperty abstractProperty) {
        AbstractPathElement currPathElement = currPathode.getPathElement();
        if (currPathElement instanceof PathElement) {
            PathElement pathElement = (PathElement)currPathElement;
            Property prop = currType.getProperty(pathElement.getValue());
            if (prop.getType().isDataType()) {
                if (abstractProperty instanceof org.plasma.query.model.Property) {
                    throw new QueryException("traversal path for property '" + ((org.plasma.query.model.Property)abstractProperty).getName() + "' from root '" + this.rootType.getName() + "' contains a non-reference property '" + prop.getName() + "'");
                }
                throw new QueryException("traversal path for wildcard property ' from root '" + this.rootType.getName() + "' contains a non-reference property '" + prop.getName() + "'");
            }
            if (currPathode.getWhere() != null) {
                this.predicateMap.put(prop, currPathode.getWhere());
            }
            if (prop.isMany() && this.isOnlySingularProperties()) {
                return;
            }
            Type nextType = prop.getType();
            if (path.getPathNodes().size() > curPathElementIndex + 1) {
                this.mapProperty(currType, prop, this.propertyMap);
                this.mapInheritedProperty(currType, prop, this.inheritedPropertyMap);
                int nextPathElementIndex = curPathElementIndex + 1;
                PathNode nextPathNode = path.getPathNodes().get(nextPathElementIndex);
                this.collect(path, nextType, nextPathNode, nextPathElementIndex, abstractProperty);
            } else {
                this.mapProperty(currType, prop, this.propertyMap);
                this.mapInheritedProperty(currType, prop, this.inheritedPropertyMap);
                String[] names = this.findPropertyNames(nextType, abstractProperty);
                this.mapPropertyNames(nextType, names, this.propertyMap);
                this.mapInheritedPropertyNames(nextType, names, this.inheritedPropertyMap);
            }
        } else if (currPathElement instanceof WildcardPathElement) {
            List<Property> properties = null;
            properties = this.onlyDeclaredProperties ? currType.getDeclaredProperties() : currType.getProperties();
            if (currPathode.getWhere() != null) {
                throw new InvalidPathPredicateException("path predicate found on wildcard path element");
            }
            for (Property prop : properties) {
                if (prop.getType().isDataType()) continue;
                if (prop.isMany() && this.isOnlySingularProperties()) {
                    return;
                }
                Type nextType = prop.getType();
                if (path.getPathNodes().size() > curPathElementIndex + 1) {
                    this.mapProperty(currType, prop, this.propertyMap);
                    this.mapInheritedProperty(currType, prop, this.inheritedPropertyMap);
                    int nextPathElementIndex = curPathElementIndex + 1;
                    PathNode nextPathNode = path.getPathNodes().get(nextPathElementIndex);
                    this.collect(path, nextType, nextPathNode, nextPathElementIndex, abstractProperty);
                    continue;
                }
                this.mapProperty(currType, prop, this.propertyMap);
                this.mapInheritedProperty(currType, prop, this.inheritedPropertyMap);
                String[] names = this.findPropertyNames(nextType, abstractProperty);
                this.mapPropertyNames(nextType, names, this.propertyMap);
                this.mapInheritedPropertyNames(nextType, names, this.inheritedPropertyMap);
            }
        } else {
            throw new IllegalArgumentException("unknown path element class, " + currPathElement.getClass().getName());
        }
    }

    public String dumpProperties() {
        StringBuilder buf = new StringBuilder();
        for (PlasmaType plasmaType : this.propertyMap.keySet()) {
            buf.append("\n" + plasmaType.getURI() + "#" + plasmaType.getName());
            List<String> names = this.propertyMap.get(plasmaType);
            for (String name : names) {
                buf.append("\n\t" + name);
            }
        }
        return buf.toString();
    }

    public String dumpInheritedProperties() {
        StringBuilder buf = new StringBuilder();
        for (PlasmaType plasmaType : this.inheritedPropertyMap.keySet()) {
            buf.append("\n" + plasmaType.getURI() + "#" + plasmaType.getName());
            List<String> names = this.inheritedPropertyMap.get(plasmaType);
            for (String name : names) {
                buf.append("\n\t" + name);
            }
        }
        return buf.toString();
    }
}

