/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.client;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.naming.ServiceLocator;
import org.plasma.query.Query;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.DataAccessService;
import org.plasma.sdo.access.client.DataAccessClient;
import org.plasma.sdo.core.SnapshotMap;

public class EJBDataAccessClient
implements DataAccessClient {
    private static Log log = LogFactory.getLog(EJBDataAccessClient.class);
    private static DataAccessService service;

    @Override
    public DataGraph[] find(Query query) {
        try {
            log.debug((Object)"calling local persistence service...");
            DataAccessService service = this.locateService();
            DataGraph[] results = service.find(query.getModel());
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + String.valueOf(results.length) + " results roots"));
            }
            return results;
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public DataGraph[] find(Query query, int maxResults) {
        try {
            log.debug((Object)"calling persistence service...");
            DataAccessService service = this.locateService();
            DataGraph[] results = service.find(query.getModel(), maxResults);
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + String.valueOf(results.length) + " results roots"));
            }
            return results;
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    public List find(Query[] queries) {
        try {
            log.debug((Object)"calling persistence service...");
            org.plasma.query.model.Query[] queryModels = new org.plasma.query.model.Query[queries.length];
            int i = 0;
            while (i < queries.length) {
                queryModels[i] = queries[i].getModel();
                ++i;
            }
            DataAccessService service = this.locateService();
            List<DataGraph[]> results = service.find(queryModels);
            if (log.isDebugEnabled()) {
                log.debug((Object)("returned " + String.valueOf(results.size()) + " results roots"));
            }
            return results;
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public int count(Query query) {
        try {
            log.debug((Object)"calling persistence service...");
            DataAccessService service = this.locateService();
            return service.count(query.getModel());
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public int[] count(Query[] queries) {
        try {
            log.debug((Object)"calling persistence service...");
            DataAccessService service = this.locateService();
            org.plasma.query.model.Query[] queryModels = new org.plasma.query.model.Query[queries.length];
            int i = 0;
            while (i < queries.length) {
                queryModels[i] = queries[i].getModel();
                ++i;
            }
            return service.count(queryModels);
        }
        catch (Exception e) {
            log.info((Object)("caught4: " + e.getClass().getName()));
            throw new DataAccessException(e);
        }
    }

    @Override
    public void commit(DataGraph dataGraph, String username) {
        SnapshotMap idMap = service.commit(dataGraph, username);
        List<DataObject> changedObjects = dataGraph.getChangeSummary().getChangedDataObjects();
        for (DataObject dataObject : changedObjects) {
            if (dataGraph.getChangeSummary().isDeleted(dataObject)) continue;
            ((PlasmaNode)((Object)dataObject)).getDataObject().reset(idMap, username);
        }
        dataGraph.getChangeSummary().endLogging();
        dataGraph.getChangeSummary().beginLogging();
        if (log.isDebugEnabled()) {
            log.debug((Object)"committed 1 data-graph");
        }
    }

    @Override
    public void commit(DataGraph[] dataGraphs, String username) {
        SnapshotMap idMap = service.commit(dataGraphs, username);
        int i = 0;
        while (i < dataGraphs.length) {
            DataGraph dataGraph = dataGraphs[i];
            List<DataObject> changedObjects = dataGraph.getChangeSummary().getChangedDataObjects();
            for (DataObject dataObject : changedObjects) {
                if (dataGraph.getChangeSummary().isDeleted(dataObject)) continue;
                ((PlasmaNode)((Object)dataObject)).getDataObject().reset(idMap, username);
            }
            dataGraph.getChangeSummary().endLogging();
            dataGraph.getChangeSummary().beginLogging();
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"committed 1 data-graph");
        }
    }

    private DataAccessService locateService() throws Exception {
        if (service == null) {
            service = (DataAccessService)ServiceLocator.getInstance().getStub(DataAccessService.class);
        }
        return service;
    }
}

