/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.client;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.query.Query;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.access.PlasmaDataAccessService;
import org.plasma.sdo.access.client.ClientSupport;
import org.plasma.sdo.access.client.DataAccessClient;
import org.plasma.sdo.core.SnapshotMap;

public class PojoDataAccessClient
extends ClientSupport
implements DataAccessClient {
    private static Log log = LogFactory.getLog(PojoDataAccessClient.class);
    protected PlasmaDataAccessService service;

    public PojoDataAccessClient() {
        PlasmaConfig config = PlasmaConfig.getInstance();
        if (config.getDefaultProviderName() != null) {
            this.service = this.createProvider(config.getDataAccessProvider(config.getDefaultProviderName()).getClassName());
        }
    }

    public PojoDataAccessClient(DataAccessProviderName providerName) {
        this.service = this.createProvider(PlasmaConfig.getInstance().getDataAccessProvider(providerName).getClassName());
    }

    public PojoDataAccessClient(PlasmaDataAccessService provider) {
        this.service = provider;
    }

    @Override
    public DataGraph[] find(Query query) {
        log.debug((Object)"calling data access service...");
        DataGraph[] dataGraphs = this.service.find(query.getModel());
        if (log.isDebugEnabled()) {
            log.debug((Object)("returned " + String.valueOf(dataGraphs.length) + " results graphs"));
        }
        int i = 0;
        while (i < dataGraphs.length) {
            if (log.isDebugEnabled()) {
                log.debug((Object)dataGraphs[i].toString());
            }
            dataGraphs[i].getChangeSummary().beginLogging();
            ++i;
        }
        return dataGraphs;
    }

    @Override
    public DataGraph[] find(Query query, int maxResults) {
        log.debug((Object)"calling data access service...");
        DataGraph[] dataGraphs = this.service.find(query.getModel(), maxResults);
        if (log.isDebugEnabled()) {
            log.debug((Object)("returned " + String.valueOf(dataGraphs.length) + " results graphs"));
        }
        int i = 0;
        while (i < dataGraphs.length) {
            dataGraphs[i].getChangeSummary().beginLogging();
            ++i;
        }
        return dataGraphs;
    }

    @Override
    public List<DataGraph[]> find(Query[] queries) {
        log.debug((Object)"calling data access service...");
        org.plasma.query.model.Query[] queryModels = new org.plasma.query.model.Query[queries.length];
        int i = 0;
        while (i < queries.length) {
            queryModels[i] = queries[i].getModel();
            ++i;
        }
        List<DataGraph[]> resultList = this.service.find(queryModels);
        if (log.isDebugEnabled()) {
            log.debug((Object)("returned " + String.valueOf(resultList.size()) + " results lists"));
        }
        Iterator<DataGraph[]> iter = resultList.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            DataGraph[] result = iter.next();
            ArrayList list = new ArrayList(result.length);
            int j = 0;
            while (j < result.length) {
                result[j].getChangeSummary().beginLogging();
                ++j;
            }
            ++i2;
        }
        return resultList;
    }

    @Override
    public int count(Query query) {
        log.debug((Object)"calling data access service...");
        return this.service.count(query.getModel());
    }

    @Override
    public int[] count(Query[] queries) {
        log.debug((Object)"calling data access service...");
        org.plasma.query.model.Query[] queryModels = new org.plasma.query.model.Query[queries.length];
        int i = 0;
        while (i < queries.length) {
            queryModels[i] = queries[i].getModel();
            ++i;
        }
        return this.service.count(queryModels);
    }

    @Override
    public void commit(DataGraph dataGraph, String username) {
        SnapshotMap idMap = this.service.commit(dataGraph, username);
        List<DataObject> changedObjects = dataGraph.getChangeSummary().getChangedDataObjects();
        for (DataObject dataObject : changedObjects) {
            if (dataGraph.getChangeSummary().isDeleted(dataObject)) continue;
            ((PlasmaNode)((Object)dataObject)).getDataObject().reset(idMap, username);
        }
        dataGraph.getChangeSummary().endLogging();
        dataGraph.getChangeSummary().beginLogging();
        if (log.isDebugEnabled()) {
            log.debug((Object)"committed 1 data-graph");
        }
    }

    @Override
    public void commit(DataGraph[] dataGraphs, String username) {
        SnapshotMap idMap = this.service.commit(dataGraphs, username);
        int i = 0;
        while (i < dataGraphs.length) {
            DataGraph dataGraph = dataGraphs[i];
            List<DataObject> changedObjects = dataGraph.getChangeSummary().getChangedDataObjects();
            for (DataObject dataObject : changedObjects) {
                if (dataGraph.getChangeSummary().isDeleted(dataObject)) continue;
                ((PlasmaNode)((Object)dataObject)).getDataObject().reset(idMap, username);
            }
            dataGraph.getChangeSummary().endLogging();
            dataGraph.getChangeSummary().beginLogging();
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("committed " + dataGraphs.length + " data-graph(s)"));
        }
    }
}

