/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.model;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaDataObjectConstants;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.model.DataEntity;
import org.plasma.sdo.access.model.EntityException;
import org.plasma.sdo.access.model.EntityGraphVisitor;
import org.plasma.sdo.access.model.EntityVisitor;
import org.plasma.sdo.access.provider.common.TraversalMap;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public abstract class Entity
implements DataEntity {
    private static Log log = LogFactory.getFactory().getInstance(Entity.class);
    private static Object lock = new Object();
    private static Map<String, Map<String, Method>[]> methodMap = new HashMap<String, Map<String, Method>[]>();
    private static Object[] emptyArgs = new Object[0];
    private static int GET_METHODS = 0;
    private static int SET_METHODS = 1;
    private static int ADD_METHODS = 2;
    private String hashKey;
    private Type type;
    private String namespaceURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity() {
        Object object = lock;
        synchronized (object) {
            Map<String, Method>[] maps = methodMap.get(this.getClass().getName());
            if (maps == null) {
                methodMap.put(this.getClass().getName(), this.createMethodMaps());
            }
        }
    }

    private Map<String, Method>[] createMethodMaps() {
        Map[] maps = new Map[3];
        maps[Entity.GET_METHODS] = new HashMap();
        maps[Entity.SET_METHODS] = new HashMap();
        maps[Entity.ADD_METHODS] = new HashMap();
        Method[] methods = this.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            String key;
            Class<?>[] argTypes;
            if (methods[i].getName().startsWith("get")) {
                argTypes = methods[i].getParameterTypes();
                if (argTypes.length == 0) {
                    key = String.valueOf(String.valueOf(Character.toLowerCase(methods[i].getName().charAt(3)))) + methods[i].getName().substring(4);
                    maps[GET_METHODS].put(key, methods[i]);
                    key = methods[i].getName().substring(3).toLowerCase();
                    maps[GET_METHODS].put(key, methods[i]);
                }
            } else if (methods[i].getName().startsWith("set")) {
                argTypes = methods[i].getParameterTypes();
                if (argTypes.length == 1) {
                    key = String.valueOf(String.valueOf(Character.toLowerCase(methods[i].getName().charAt(3)))) + methods[i].getName().substring(4);
                    maps[SET_METHODS].put(key, methods[i]);
                    key = methods[i].getName().substring(3).toLowerCase();
                    maps[SET_METHODS].put(key, methods[i]);
                }
            } else if (methods[i].getName().startsWith("add") && (argTypes = methods[i].getParameterTypes()).length == 1) {
                key = String.valueOf(String.valueOf(Character.toLowerCase(methods[i].getName().charAt(3)))) + methods[i].getName().substring(4);
                maps[ADD_METHODS].put(key, methods[i]);
                key = methods[i].getName().substring(3).toLowerCase();
                maps[ADD_METHODS].put(key, methods[i]);
            }
            ++i;
        }
        return maps;
    }

    @Override
    public Object get(String name) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Map<String, Method>[] maps = methodMap.get(this.getClass().getName());
        Method method = maps[GET_METHODS].get(name);
        if (method != null) {
            return method.invoke((Object)this, emptyArgs);
        }
        String lowerName = name.toLowerCase();
        method = maps[GET_METHODS].get(lowerName);
        if (method != null) {
            return method.invoke((Object)this, emptyArgs);
        }
        throw new EntityException("no " + this.getClass().getName() + " 'get' method found for property '" + name + "'");
    }

    @Override
    public Object set(String name, Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object old = this.get(name);
        Map<String, Method>[] maps = methodMap.get(this.getClass().getName());
        Method method = maps[SET_METHODS].get(name);
        if (method != null) {
            Object[] args = new Object[]{o};
            method.invoke((Object)this, args);
        } else {
            String lowerName = name.toLowerCase();
            method = maps[SET_METHODS].get(lowerName);
            if (method != null) {
                Object[] args = new Object[]{o};
                method.invoke((Object)this, args);
            } else {
                throw new EntityException("no " + this.getClass().getName() + " 'set' method found for property '" + name + "'");
            }
        }
        return old;
    }

    @Override
    public void add(String name, Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Map<String, Method>[] maps = methodMap.get(this.getClass().getName());
        Method method = maps[ADD_METHODS].get(name);
        if (method != null) {
            Object[] args = new Object[]{o};
            method.invoke((Object)this, args);
        } else {
            String lowerName = name.toLowerCase();
            method = maps[ADD_METHODS].get(lowerName);
            if (method != null) {
                Object[] args = new Object[]{o};
                method.invoke((Object)this, args);
            } else {
                throw new EntityException("no " + this.getClass().getName() + " 'add' method found for property '" + name + "'");
            }
        }
    }

    @Override
    public Object getEntityId() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.get(this.getIdProperty().getName());
    }

    @Override
    public Object setEntityId(Object id) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.set(this.getIdProperty().getName(), id);
    }

    @Override
    public void accept(EntityVisitor visitor) {
        try {
            this.accept(visitor, this, null, null, new HashMap<Entity, Entity>(), false);
        }
        catch (IllegalAccessException e) {
            throw new EntityException(e);
        }
        catch (IllegalArgumentException e) {
            throw new EntityException(e);
        }
        catch (InvocationTargetException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public void accept(EntityVisitor visitor, boolean depthFirst) {
        try {
            this.accept(visitor, this, null, null, new HashMap<Entity, Entity>(), depthFirst);
        }
        catch (IllegalAccessException e) {
            throw new EntityException(e);
        }
        catch (IllegalArgumentException e) {
            throw new EntityException(e);
        }
        catch (InvocationTargetException e) {
            throw new EntityException(e);
        }
    }

    public void accept(EntityGraphVisitor visitor, TraversalMap traversalMap) {
        try {
            this.accept(visitor, this, traversalMap);
        }
        catch (IllegalAccessException e) {
            throw new EntityException(e);
        }
        catch (InvocationTargetException e) {
            throw new EntityException(e);
        }
    }

    private boolean accept(EntityVisitor visitor, Entity entity, Entity source, String sourceKey, Map<Entity, Entity> visited, boolean depthFirst) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Entity[] entitys = null;
        visited.put(entity, entity);
        if (!depthFirst && !visitor.visit(entity, source, sourceKey)) {
            return false;
        }
        List<Property> properties = this.getType().getDeclaredProperties();
        for (Property property : properties) {
            if (property.getName().equals(this.getIdProperty().getName()) || property.getType().isDataType()) continue;
            entitys = this.getNodes(entity, property);
            int j = 0;
            while (j < entitys.length) {
                if (visited.get(entitys[j]) == null && !this.accept(visitor, entitys[j], entity, property.getName(), visited, depthFirst)) {
                    return false;
                }
                ++j;
            }
        }
        return !depthFirst || visitor.visit(entity, source, sourceKey);
    }

    private void accept(EntityGraphVisitor visitor, Entity entity, TraversalMap traversalMap) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Entity target = entity;
        Iterator<String> iter = traversalMap.iterator();
        while (iter.hasNext()) {
            String pathStr = iter.next();
            if (!pathStr.startsWith(TraversalMap.DELIM_PATH)) continue;
            String[] path = pathStr.substring(1).split(TraversalMap.DELIM_PATH);
            if (path.length == 1 && path[0].length() == 0) {
                path = null;
            }
            this.accept(visitor, entity, null, null, path, -1, pathStr, TraversalMap.DELIM_PATH);
        }
    }

    private void accept(EntityGraphVisitor visitor, Entity entity, Entity source, String sourceKey, String[] path, int item, String fullPath, String currPath) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Entity[] entities = null;
        if (path != null && ++item < path.length) {
            visitor.visit(entity, source, sourceKey, null);
            currPath = String.valueOf(currPath) + path[item] + TraversalMap.DELIM_PATH;
            Property property = entity.getType().getProperty(path[item]);
            entities = this.getNodes(entity, property);
            int i = 0;
            while (i < entities.length) {
                this.accept(visitor, entities[i], entity, property.getName(), path, item, fullPath, currPath);
                ++i;
            }
        } else {
            visitor.visit(entity, source, sourceKey, currPath);
        }
    }

    private Entity[] getNodes(Entity entity, Property property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Entity temp;
        Entity[] entitys = null;
        if (property.getType().isDataType()) {
            throw new EntityException("Expected reference property");
        }
        entitys = property.isMany() ? (Entity[])entity.get(property.getName()) : ((temp = (Entity)entity.get(property.getName())) != null ? new Entity[]{temp} : new Entity[]{});
        return entitys;
    }

    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            try {
                Field uriField = this.getClass().getDeclaredField(PlasmaDataObjectConstants.NAMESPACE_URI_FIELD_NAME);
                this.namespaceURI = (String)uriField.get(null);
            }
            catch (SecurityException e) {
                throw new EntityException(e);
            }
            catch (NoSuchFieldException e) {
                throw new EntityException(e);
            }
            catch (IllegalArgumentException e) {
                throw new EntityException(e);
            }
            catch (IllegalAccessException e) {
                throw new EntityException(e);
            }
        }
        return this.namespaceURI;
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            String className = this.getClass().getSimpleName();
            this.type = PlasmaTypeHelper.INSTANCE.getType(this.getNamespaceURI(), className);
        }
        return this.type;
    }

    @Override
    public Property getIdProperty() {
        List pkList = (List)this.getType().get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_PRIKEY_PROPERTIES);
        if (pkList == null || pkList.size() == 0) {
            throw new DataAccessException("no pri-key properties found for type '" + this.getType().getName() + "'");
        }
        if (pkList.size() > 1) {
            throw new DataAccessException("multiple pri-key properties found for type '" + this.getType().getName() + "' - not yet supported");
        }
        return (Property)pkList.get(0);
    }

    public String getHashKey() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.hashKey == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getType().getName());
            List pkPropertyList = (List)this.getType().get(PlasmaProperty.INSTANCE_PROPERTY_OBJECT_PRIKEY_PROPERTIES);
            if (pkPropertyList == null) {
                throw new DataAccessException("found no pri-key properties found for type '" + this.getType().getName() + "'");
            }
            for (Property property : pkPropertyList) {
                Object id = this.get(property.getName());
                if (id != null) {
                    buf.append(id.toString());
                    continue;
                }
                this.hashKey = UUID.randomUUID().toString();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("null pri-key value found for '" + this.getType().getName() + "." + property.getName() + "' when constructing hash-key - using UUID"));
                break;
            }
            this.hashKey = buf.toString();
        }
        return this.hashKey;
    }

    public String toString() {
        try {
            return String.valueOf(this.getHashKey());
        }
        catch (IllegalArgumentException e) {
            throw new EntityException(e);
        }
        catch (IllegalAccessException e) {
            throw new EntityException(e);
        }
        catch (InvocationTargetException e) {
            throw new EntityException(e);
        }
    }
}

