/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import java.util.ArrayList;
import java.util.List;
import org.plasma.sdo.PlasmaEdge;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.core.CoreObject;
import org.plasma.sdo.core.CoreObjectHolder;
import org.plasma.sdo.core.NamedEntity;
import org.plasma.sdo.core.NullValue;

public abstract class CoreNode
implements PlasmaNode,
CoreObjectHolder,
NamedEntity {
    private static final long serialVersionUID = 1L;
    protected CoreObject valueObject;
    protected static final List<PlasmaEdge> EMPTY_EDGE_LIST = new ArrayList<PlasmaEdge>();

    protected CoreNode() {
    }

    public CoreNode(CoreObject values) {
        this.valueObject = values;
    }

    @Override
    public abstract String getUUIDAsString();

    public Object getValue(String property) {
        Object results = this.valueObject.get(property);
        if (!(results instanceof NullValue)) {
            return results;
        }
        return null;
    }

    public void setValue(String property, Object value) {
        if (value != null) {
            this.valueObject.put(property, value);
        } else {
            this.valueObject.put(property, new NullValue());
        }
    }

    public void removeValue(String property) {
        this.valueObject.remove(property);
    }

    @Override
    public String getEntityName() {
        return this.valueObject.getEntityName();
    }

    @Override
    public CoreObject getValueObject() {
        return this.valueObject;
    }

    @Override
    public void setValueObject(CoreObject v) {
        this.valueObject = v;
    }

    @Override
    public List<PlasmaEdge> getEdges(PlasmaProperty property) {
        ArrayList<PlasmaEdge> result = EMPTY_EDGE_LIST;
        if (!property.isMany()) {
            PlasmaEdge edge = (PlasmaEdge)this.getValue(property.getName());
            if (edge != null) {
                result = new ArrayList<PlasmaEdge>();
                result.add(edge);
            }
        } else {
            ArrayList<PlasmaEdge> edgeList = (ArrayList<PlasmaEdge>)this.getValue(property.getName());
            if (edgeList != null) {
                result = edgeList;
            }
        }
        return result;
    }
}

