/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class CoreObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Object> values = new HashMap<String, Object>();

    private CoreObject() {
    }

    public CoreObject(String entityName) {
        this();
        this.put("entityName", entityName);
    }

    public String getEntityName() {
        return (String)this.get("entityName");
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public String[] getKeys() {
        Set<String> keys = this.values.keySet();
        String[] result = new String[keys.size()];
        keys.toArray(result);
        return result;
    }

    public void put(String key, Object value) {
        this.values.put(key, value);
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public Object remove(String key) {
        return this.values.remove(key);
    }

    public boolean isFlaggedLocked() {
        Boolean locked = (Boolean)this.values.get("entityLocked");
        return locked != null && locked != false;
    }

    public boolean isFlaggedUnlocked() {
        Boolean unlocked = (Boolean)this.values.get("entityUnlocked");
        return unlocked != null && unlocked != false;
    }

    public void flagLocked() {
        Boolean locked = (Boolean)this.values.get("entityLocked");
        if (locked == null || !locked.booleanValue()) {
            this.values.put("entityLocked", new Boolean(true));
        }
    }

    public void unflagLocked() {
        this.values.remove("entityLocked");
    }

    public void flagUnlocked() {
        Boolean locked = (Boolean)this.values.get("entityUnlocked");
        if (locked == null || !locked.booleanValue()) {
            this.values.put("entityUnlocked", new Boolean(true));
        }
    }

    public void unflagUnlocked() {
        this.values.remove("entityUnlocked");
    }

    public int getAbsoluteSize() {
        int total = 0;
        for (Object obj : this.values.values()) {
            if (obj instanceof CoreObject) {
                total += ((CoreObject)obj).getAbsoluteSize() + 1;
                continue;
            }
            ++total;
        }
        return total;
    }

    public int getDepth() {
        int total = 0;
        for (Object obj : this.values.values()) {
            if (!(obj instanceof CoreObject)) continue;
            total += ((CoreObject)obj).getDepth() + 1;
        }
        return total;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int size = this.values.size();
        out.writeInt(size);
        for (String key : this.values.keySet()) {
            Object obj = this.values.get(key);
            out.writeObject(key);
            out.writeObject(obj);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.values = new HashMap<String, Object>(size);
        int i = 0;
        while (i < size) {
            String key = (String)in.readObject();
            Object value = in.readObject();
            this.values.put(key, value);
            ++i;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CoreObject clone = (CoreObject)super.clone();
        clone.values = new HashMap<String, Object>(this.values);
        return clone;
    }
}

