/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.core.CoreDataGraph;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class PlasmaDataFactory
implements DataFactory {
    private static Log log = LogFactory.getLog(PlasmaDataFactory.class);
    public static PlasmaDataFactory INSTANCE = PlasmaDataFactory.initializeInstance();

    private PlasmaDataFactory() {
    }

    public static PlasmaDataFactory instance() {
        if (INSTANCE == null) {
            PlasmaDataFactory.initializeInstance();
        }
        return INSTANCE;
    }

    private static synchronized PlasmaDataFactory initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaDataFactory();
        }
        return INSTANCE;
    }

    public PlasmaDataGraph createDataGraph() {
        return new CoreDataGraph();
    }

    @Override
    public DataObject create(String uri, String typeName) {
        Type type = PlasmaTypeHelper.INSTANCE.getType(uri, typeName);
        String packageName = PlasmaConfig.getInstance().getSDOImplementationPackageName(uri);
        if (packageName != null) {
            return this.create(type);
        }
        return new CoreDataObject(type);
    }

    @Override
    public DataObject create(Type type) {
        DataObject result = null;
        if (type.isAbstract()) {
            throw new IllegalArgumentException("attempt to create an abstract type '" + type.getURI() + "#" + type.getName() + "'");
        }
        if (type.isDataType()) {
            throw new IllegalArgumentException("attempt to create a type which is a datatype '" + type.getURI() + "#" + type.getName() + "'");
        }
        String packageName = PlasmaConfig.getInstance().getSDOImplementationPackageName(type.getURI());
        String className = PlasmaConfig.getInstance().getSDOImplementationClassName(type.getURI(), type.getName());
        String qualifiedName = String.valueOf(packageName) + "." + className;
        try {
            Class<?> interfaceImplClass = Class.forName(qualifiedName);
            result = this.create(interfaceImplClass, type);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no interface class found for qualified name '" + qualifiedName + "' - using generic DataObject"));
            }
            CoreDataObject dataObject = new CoreDataObject(type);
            result = dataObject;
        }
        return result;
    }

    @Override
    public DataObject create(Class interfaceClass) {
        CoreDataObject result = null;
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByInterfacePackage(interfaceClass.getPackage().getName());
        String packageName = PlasmaConfig.getInstance().getSDOImplementationPackageName(sdoNamespace.getUri());
        String className = PlasmaConfig.getInstance().getSDOImplementationClassName(sdoNamespace.getUri(), interfaceClass.getSimpleName());
        String qualifiedName = String.valueOf(packageName) + "." + className;
        Class[] types = new Class[]{};
        Object[] args = new Object[]{};
        try {
            Class<?> interfaceImplClass = Class.forName(qualifiedName);
            Constructor<?> constructor = interfaceImplClass.getConstructor(types);
            result = (CoreDataObject)constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private DataObject create(Class<?> interfaceClass, Type type) {
        CoreDataObject result = null;
        Class[] types = new Class[]{Type.class};
        Object[] args = new Object[]{type};
        try {
            Constructor<?> constructor = interfaceClass.getConstructor(types);
            result = (CoreDataObject)constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

