/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xml;

import commonj.sdo.Property;
import commonj.sdo.helper.XMLDocument;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javanet.staxutils.events.EventAllocator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.core.CoreHelper;
import org.plasma.sdo.core.CoreXMLDocument;
import org.plasma.sdo.helper.PlasmaDataFactory;
import org.plasma.sdo.helper.PlasmaDataHelper;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.xml.DuplicateContainmentReferenceException;
import org.plasma.sdo.xml.InvalidReferenceException;
import org.plasma.sdo.xml.StreamNode;
import org.plasma.sdo.xml.StreamObject;
import org.plasma.sdo.xml.StreamObjectVisitor;
import org.plasma.sdo.xml.StreamProperty;
import org.plasma.sdo.xml.Unmarshaller;
import org.plasma.sdo.xml.UnmarshallerException;
import org.plasma.sdo.xml.UnmarshallerFlavor;
import org.plasma.sdo.xml.XMLOptions;
import org.plasma.xml.schema.SchemaUtil;

public class StreamUnmarshaller
extends Unmarshaller {
    private static Log log = LogFactory.getLog(StreamUnmarshaller.class);
    private XMLEventAllocator allocator = null;
    private XMLInputFactory factory;
    private Stack<StreamNode> stack = new Stack();
    private Map<Object, StreamObject> keyMap = new HashMap<Object, StreamObject>();
    private String currentNamespaceUri = null;
    private XMLOptions options;
    private String locationURI;
    private Timestamp snapshotDate = new Timestamp(new Date().getTime());
    private StringBuilder charbuf = new StringBuilder();

    public StreamUnmarshaller(XMLOptions options, String locationURI) {
        super(UnmarshallerFlavor.STAX);
        this.options = options;
        this.locationURI = locationURI;
        this.setup();
    }

    public XMLDocument getResult() {
        if (this.result == null) {
            throw new IllegalStateException("unmarshaling not yet performed - call unmarshal(...)");
        }
        return this.result;
    }

    private void setup() {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                log.debug((Object)("resolve: " + publicID + ":" + systemID + ":" + baseURI + ":" + namespace));
                return null;
            }
        });
        this.factory.setEventAllocator(new EventAllocator());
        this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        this.allocator = this.factory.getEventAllocator();
    }

    private void init() {
        this.snapshotDate = new Timestamp(new Date().getTime());
        this.stack.clear();
        this.keyMap.clear();
        this.charbuf = new StringBuilder();
    }

    public void unmarshal(InputStream stream) throws XMLStreamException, UnmarshallerException {
        XMLStreamReader streamReader = this.factory.createXMLStreamReader(stream);
        this.init();
        try {
            this.unmarshal(streamReader);
        }
        finally {
            streamReader.close();
        }
    }

    public void unmarshal(Source source) throws XMLStreamException, UnmarshallerException {
        XMLStreamReader streamReader = this.factory.createXMLStreamReader(source);
        this.init();
        try {
            this.unmarshal(streamReader);
        }
        finally {
            streamReader.close();
        }
    }

    public void unmarshal(Reader reader) throws XMLStreamException, UnmarshallerException {
        XMLStreamReader streamReader = this.factory.createXMLStreamReader(reader);
        this.init();
        try {
            this.unmarshal(streamReader);
        }
        finally {
            streamReader.close();
        }
    }

    private void unmarshal(XMLStreamReader streamReader) throws XMLStreamException, UnmarshallerException {
        StreamObject root = this.read(streamReader);
        final PlasmaDataGraph dataGraph = PlasmaDataFactory.INSTANCE.createDataGraph();
        dataGraph.getChangeSummary().beginLogging();
        StreamObjectVisitor visitor = new StreamObjectVisitor(){

            @Override
            public void visit(StreamObject target, StreamObject source, PlasmaProperty sourceProperty, int level) {
                if (target.isNonContainmentReference()) {
                    return;
                }
                PlasmaDataObject dataObject = null;
                if (source == null) {
                    dataObject = (PlasmaDataObject)dataGraph.createRootObject(target.getType());
                } else {
                    PlasmaDataObject parent = source.getDataObject();
                    dataObject = (PlasmaDataObject)parent.createDataObject(target.getSource());
                }
                target.setDataObject(dataObject);
                String key = target.getSerialId();
                StreamObject existing = (StreamObject)StreamUnmarshaller.this.keyMap.get(key);
                if (existing != null) {
                    String msg = "line:col[" + target.getLine() + ":" + target.getColumn() + "]";
                    msg = String.valueOf(msg) + " - attempt to instantiate multiple instances of '" + target.getLocalName() + "' using the same reference key '" + String.valueOf(key) + "'";
                    throw new DuplicateContainmentReferenceException(msg);
                }
                StreamUnmarshaller.this.keyMap.put(key, target);
                for (PlasmaProperty property : target.getValues().keySet()) {
                    if (!property.getType().isDataType()) continue;
                    Object value = target.get(property);
                    if (!property.isReadOnly()) {
                        if (!property.isMany()) {
                            dataObject.set(property, value);
                            continue;
                        }
                        dataObject.setList(property, (List)value);
                        continue;
                    }
                    CoreHelper.set(dataObject, property.getName(), value);
                }
            }
        };
        root.accept(visitor);
        visitor = new StreamObjectVisitor(){

            @Override
            public void visit(StreamObject target, StreamObject source, PlasmaProperty sourceProperty, int level) {
                if (!target.isNonContainmentReference()) {
                    return;
                }
                String key = target.getSerialId();
                if (key == null) {
                    throw new IllegalStateException("expected key");
                }
                StreamObject existing = (StreamObject)StreamUnmarshaller.this.keyMap.get(key);
                if (existing != null) {
                    if (!target.getSource().isMany()) {
                        source.getDataObject().set(target.getSource(), (Object)existing.getDataObject());
                    } else {
                        ArrayList<PlasmaDataObject> list = (ArrayList<PlasmaDataObject>)source.getDataObject().get(target.getSource());
                        if (list == null) {
                            list = new ArrayList<PlasmaDataObject>();
                        }
                        list.add(existing.getDataObject());
                        source.getDataObject().set(target.getSource(), list);
                    }
                } else {
                    String msg = "line:col[" + target.getLine() + ":" + target.getColumn() + "]";
                    msg = String.valueOf(msg) + " - reference value '" + String.valueOf(key) + "' not found within document";
                    throw new InvalidReferenceException(msg);
                }
            }
        };
        root.accept(visitor);
        visitor = new StreamObjectVisitor(){

            @Override
            public void visit(StreamObject target, StreamObject source, PlasmaProperty sourceProperty, int level) {
                target.getValues().clear();
                target.setDataObject(null);
            }
        };
        root.accept(visitor);
        this.result = new CoreXMLDocument(dataGraph.getRootObject(), this.options);
    }

    private StreamObject read(XMLStreamReader streamReader) throws XMLStreamException, UnmarshallerException {
        StreamObject root = null;
        block5: while (streamReader.hasNext()) {
            int eventType = streamReader.next();
            XMLEvent event = this.allocateXMLEvent(streamReader);
            switch (eventType) {
                case 1: {
                    PlasmaType type;
                    QName name = event.asStartElement().getName();
                    String uri = name.getNamespaceURI();
                    if (uri != null && uri.trim().length() > 0) {
                        this.currentNamespaceUri = uri.trim();
                    }
                    if (this.stack.size() == 0) {
                        String typeName = name.getLocalPart();
                        type = (PlasmaType)PlasmaTypeHelper.INSTANCE.getType(this.currentNamespaceUri, typeName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("unmarshaling root: " + type.getURI() + "#" + type.getName()));
                        }
                        root = new StreamObject(type, name, event.getLocation());
                        this.stack.push(root);
                    } else {
                        QName elemName;
                        StreamObject sreamObject = (StreamObject)this.stack.peek();
                        type = sreamObject.getType();
                        PlasmaProperty property = this.getPropertyByLocalName(event, type, (elemName = event.asStartElement().getName()).getLocalPart());
                        if (property.getType().isDataType()) {
                            this.stack.push(new StreamProperty((PlasmaType)property.getType(), property, name, event.getLocation()));
                            break;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("unmarshaling: " + property.getType().getURI() + "#" + property.getType().getName()));
                        }
                        this.stack.push(new StreamObject((PlasmaType)property.getType(), property, name, event.getLocation()));
                    }
                    StreamObject streamObject = (StreamObject)this.stack.peek();
                    this.readAttributes(event, streamObject);
                    break;
                }
                case 2: {
                    StreamNode node = this.stack.pop();
                    if (this.stack.size() == 0) continue block5;
                    StreamObject other = (StreamObject)this.stack.peek();
                    if (node instanceof StreamProperty) {
                        StreamProperty streamProp = (StreamProperty)node;
                        if (this.charbuf.length() > 0) {
                            this.readCharacters(streamProp, this.charbuf.toString(), event);
                            this.charbuf.setLength(0);
                        }
                        this.link((StreamProperty)node, other);
                        break;
                    }
                    this.link((StreamObject)node, other);
                    break;
                }
                case 4: {
                    StreamNode streamNode;
                    if (this.stack.size() == 0) continue block5;
                    String data = event.asCharacters().getData();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("unmarshaling characters: " + String.valueOf(data)));
                    }
                    if (data == null) continue block5;
                    if (data.contains(">")) {
                        Location loc = event.getLocation();
                        String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
                        msg = String.valueOf(msg) + " - document may not be well-formed";
                        log.warn((Object)msg);
                    }
                    if ((streamNode = this.stack.peek()) instanceof StreamProperty) {
                        this.charbuf.append(data);
                        break;
                    }
                    if (!log.isDebugEnabled()) continue block5;
                    StreamObject streamObj = (StreamObject)streamNode;
                    Location loc = event.getLocation();
                    String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
                    msg = String.valueOf(msg) + " - ignoring character(s) data '" + data + "' for complex type " + streamObj.getType().getURI() + "#" + streamObj.getType().getName();
                    log.debug((Object)msg);
                    break;
                }
                default: {
                    this.logEventInfo(event);
                }
            }
        }
        return root;
    }

    private void readCharacters(StreamProperty streamProperty, String data, XMLEvent event) throws UnmarshallerException {
        PlasmaType type = streamProperty.getType();
        PlasmaProperty property = streamProperty.getProperty();
        if (!property.getType().isDataType()) {
            Location loc = event.getLocation();
            String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
            msg = String.valueOf(msg) + " - cannot set reference propery (" + type.getURI() + "#" + type.getName() + "." + property.getName() + ") - from character data";
            throw new UnmarshallerException(msg);
        }
        if (!property.isReadOnly()) {
            if (!property.isMany()) {
                Object value = PlasmaDataHelper.INSTANCE.convert(property, (Object)data);
                streamProperty.set(value);
            } else {
                Object value = PlasmaDataHelper.INSTANCE.convert(property, (Object)data);
                streamProperty.set(value);
            }
        } else {
            Location loc = event.getLocation();
            String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
            msg = String.valueOf(msg) + " - cannot set readonly propery (" + property.getName() + ") - ignoring character data '" + data + "' for readonly propery, " + type.getURI() + "#" + type.getName() + "." + property.getName();
            log.warn((Object)msg);
        }
    }

    private void link(StreamProperty propertyNode, StreamObject parent) {
        Object value = propertyNode.get();
        if (value != null) {
            parent.set(propertyNode.getProperty(), value);
        }
    }

    private void link(StreamObject objectNode, StreamObject parent) throws UnmarshallerException {
        if (!objectNode.getSource().isMany()) {
            StreamObject existingValue = (StreamObject)parent.get(objectNode.getSource());
            if (existingValue != null) {
                String msg = "line:col[" + objectNode.getLine() + ":" + objectNode.getColumn() + "]";
                msg = String.valueOf(msg) + " - invalid element '" + objectNode.getLocalName() + "' - found existing element " + "for singular property, " + parent.getType().getURI() + "#" + parent.getType().getName() + "." + objectNode.getSource().getName();
                throw new UnmarshallerException(msg);
            }
            parent.set(objectNode.getSource(), objectNode);
        } else {
            ArrayList<StreamObject> list = (ArrayList<StreamObject>)parent.get(objectNode.getSource());
            if (list == null) {
                list = new ArrayList<StreamObject>();
                parent.set(objectNode.getSource(), list);
            }
            list.add(objectNode);
        }
    }

    private void readAttributes(XMLEvent event, StreamObject prototype) throws UnmarshallerException {
        boolean serialIdAttributeFound = false;
        PlasmaType type = prototype.getType();
        Iterator<Attribute> iter = event.asStartElement().getAttributes();
        while (iter.hasNext()) {
            String msg;
            Attribute attrib = iter.next();
            QName attribName = attrib.getName();
            String localPart = attribName.getLocalPart();
            if ("targetNamespace".equals(localPart)) continue;
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(attribName.getNamespaceURI())) {
                if (!"type".equals(localPart)) continue;
                String xsiTypeLocalName = attrib.getValue();
                int delim = xsiTypeLocalName.indexOf(":");
                if (delim >= 0) {
                    xsiTypeLocalName = xsiTypeLocalName.substring(delim + 1);
                }
                if (xsiTypeLocalName.equals(type.getLocalName())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("type as non-containment reference, " + type.getURI() + "#" + type.getName()));
                }
                prototype.setNonContainmentReference(true);
                continue;
            }
            PlasmaProperty property = this.findPropertyByLocalName(type, localPart);
            if (property == null) {
                if (!SchemaUtil.getSerializationAttributeName().equals(localPart)) {
                    Location loc = event.getLocation();
                    msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
                    msg = String.valueOf(msg) + " - no property '" + localPart + "' found defined for type " + type.getURI() + "#" + type.getName();
                    throw new UnmarshallerException(msg);
                }
                prototype.setSerialId(attrib.getValue());
                serialIdAttributeFound = true;
                continue;
            }
            if (property.getType().isDataType()) {
                if (property.isMany()) {
                    Location loc = event.getLocation();
                    msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
                    msg = String.valueOf(msg) + " - unexpected 'many' propery (" + type.getURI() + "#" + type.getName() + "." + property.getName() + ") can only set singular properties from attribute '" + localPart + "'";
                    throw new UnmarshallerException(msg);
                }
                Object value = PlasmaDataHelper.INSTANCE.convert(property, (Object)attrib.getValue());
                if (!property.isReadOnly()) {
                    prototype.set(property, value);
                    continue;
                }
                DataFlavor dataFlavor = property.getDataFlavor();
                switch (dataFlavor) {
                    case integral: {
                        Location loc = event.getLocation();
                        String msg2 = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
                        msg2 = String.valueOf(msg2) + " - cannot set integral readonly propery (" + property.getName() + ") - ignoring attribute data '" + attrib.getValue() + "' for readonly propery, " + type.getURI() + "#" + type.getName() + "." + property.getName();
                        log.warn((Object)msg2);
                        break;
                    }
                    default: {
                        prototype.set(property, value);
                        break;
                    }
                }
                continue;
            }
            Location loc = event.getLocation();
            msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
            msg = String.valueOf(msg) + " - expected datatype property - attribute '" + localPart + "' is a reference property as defined in type " + type.getURI() + "#" + type.getName();
            throw new UnmarshallerException(msg);
        }
        if (!serialIdAttributeFound) {
            Location loc = event.getLocation();
            String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
            msg = String.valueOf(msg) + " - expected serialization attribute '" + SchemaUtil.getSerializationAttributeName() + "' for type " + type.getURI() + "#" + type.getName();
            throw new UnmarshallerException(msg);
        }
    }

    private PlasmaProperty getPropertyByLocalName(XMLEvent event, PlasmaType type, String localName) throws UnmarshallerException {
        PlasmaProperty property = this.findPropertyByLocalName(type, localName);
        if (property == null) {
            Location loc = event.getLocation();
            String msg = "line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "]";
            msg = String.valueOf(msg) + " - no property with local name (" + localName + ") found defined for type " + type.getURI() + "#" + type.getName();
            throw new UnmarshallerException(msg);
        }
        return property;
    }

    private PlasmaProperty findPropertyByLocalName(PlasmaType type, String localName) {
        List<Property> props = type.getProperties();
        if (props != null) {
            for (Property p : type.getProperties()) {
                PlasmaProperty property = (PlasmaProperty)p;
                if (!property.getLocalName().equals(localName)) continue;
                return property;
            }
        }
        return null;
    }

    private XMLEvent allocateXMLEvent(XMLStreamReader reader) throws XMLStreamException {
        return this.allocator.allocate(reader);
    }

    private void logEventInfo(XMLEvent event) {
        if (log.isDebugEnabled()) {
            Location loc = event.getLocation();
            String msg = StreamUnmarshaller.getEventTypeString(event.getEventType());
            msg = String.valueOf(msg) + " line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "] - ";
            msg = String.valueOf(msg) + event.toString();
            log.debug((Object)msg);
        }
    }

    public static final String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + eventType;
    }
}

