/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.ddl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.plasma.common.io.StreamAssembler;
import org.plasma.text.ddl.Behavior;
import org.plasma.text.ddl.BehaviorType;
import org.plasma.text.ddl.Check;
import org.plasma.text.ddl.DDLAssembler;
import org.plasma.text.ddl.DDLException;
import org.plasma.text.ddl.DDLFactory;
import org.plasma.text.ddl.DDLOperation;
import org.plasma.text.ddl.Fk;
import org.plasma.text.ddl.Index;
import org.plasma.text.ddl.Schema;
import org.plasma.text.ddl.Schemas;
import org.plasma.text.ddl.Table;
import org.plasma.text.ddl.Unique;

public class DDLStreamAssembler
extends DDLAssembler
implements StreamAssembler {
    private OutputStream stream;
    private boolean indent = false;
    private String indentationToken = "\t";
    private Map<String, Table> tableMap = new HashMap<String, Table>();

    public DDLStreamAssembler(Schemas schemas, DDLFactory factory, DDLOperation operation, OutputStream stream) {
        super(schemas, factory, operation);
        this.stream = stream;
        if (this.schemas == null) {
            throw new IllegalArgumentException("expected 'schemas' argument");
        }
        if (this.stream == null) {
            throw new IllegalArgumentException("expected 'stream' argument");
        }
        if (this.factory == null) {
            throw new IllegalArgumentException("expected 'factory' argument");
        }
    }

    public void start() {
        try {
            for (Schema schema : this.schemas.getSchemas()) {
                for (Table table : schema.getTables()) {
                    this.tableMap.put(String.valueOf(schema.getName()) + "." + table.getName(), table);
                }
            }
            switch (this.operation) {
                case create: {
                    this.createTables();
                    this.createViews();
                    this.createForeignKeys();
                    this.createUniqueConstraints();
                    this.createCheckConstraints();
                    this.createIndexes();
                    this.createSequences();
                    break;
                }
                case drop: {
                    this.dropForeignKeys();
                    this.dropUniqueConstraints();
                    this.dropCheckConstraints();
                    this.dropIndexes();
                    this.dropSequences();
                    this.dropTables();
                    this.dropViews();
                    break;
                }
                case truncate: {
                    this.enableForeignKeys(false);
                    this.truncateTables();
                    this.enableForeignKeys(true);
                }
            }
        }
        catch (IOException e) {
            throw new DDLException(e);
        }
    }

    private void createTables() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (this.hasBehavior(BehaviorType.CREATE, schema, table)) continue;
                String ddl = this.createTable(schema, table);
                this.stream.write(ddl.getBytes());
            }
        }
    }

    private void dropTables() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (this.hasBehavior(BehaviorType.CREATE, schema, table)) continue;
                String ddl = this.dropTable(schema, table);
                this.stream.write(ddl.getBytes());
            }
        }
    }

    private void truncateTables() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (this.hasBehavior(BehaviorType.CREATE, schema, table)) continue;
                String ddl = this.truncateTable(schema, table);
                this.stream.write(ddl.getBytes());
            }
        }
    }

    private void createViews() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (!this.hasBehavior(BehaviorType.CREATE, schema, table)) continue;
                this.stream.write("\n".getBytes());
                Behavior behavior = this.getBehavior(BehaviorType.CREATE, schema, table);
                this.stream.write(behavior.getValue().getBytes());
                if (behavior.getValue().trim().endsWith(";")) continue;
                this.stream.write(";".getBytes());
            }
        }
        this.stream.write("\n".getBytes());
    }

    private void dropViews() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (!this.hasBehavior(BehaviorType.DROP, schema, table)) continue;
                this.stream.write("\n".getBytes());
                Behavior behavior = this.getBehavior(BehaviorType.DROP, schema, table);
                this.stream.write(behavior.getValue().getBytes());
                if (behavior.getValue().trim().endsWith(";")) continue;
                this.stream.write(";".getBytes());
            }
        }
    }

    private void createForeignKeys() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Fk fk : table.getFks()) {
                    Table toTable = this.getTable(fk.getToTable(), schema);
                    String ddl = this.createForeignKeyConstraint(schema, table, fk, toTable);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void dropForeignKeys() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Fk fk : table.getFks()) {
                    Table toTable = this.getTable(fk.getToTable(), schema);
                    String ddl = this.dropForeignKeyConstraint(schema, table, fk, toTable);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void enableForeignKeys(boolean enable) throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Fk fk : table.getFks()) {
                    Table toTable = this.getTable(fk.getToTable(), schema);
                    String ddl = this.enableForeignKeyConstraint(schema, table, fk, toTable, enable);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void createUniqueConstraints() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Unique unique : table.getUniques()) {
                    String ddl = this.createUniqueConstraint(schema, table, unique);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void dropUniqueConstraints() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Unique unique : table.getUniques()) {
                    String ddl = this.dropUniqueConstraint(schema, table, unique);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void enableUniqueConstraints(boolean enable) throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Unique unique : table.getUniques()) {
                    String ddl = this.enableUniqueConstraint(schema, table, unique, enable);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void createCheckConstraints() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Check check : table.getChecks()) {
                    String ddl = this.createCheckConstraint(schema, table, check);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void dropCheckConstraints() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Check check : table.getChecks()) {
                    String ddl = this.dropCheckConstraint(schema, table, check);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void enableCheckConstraints(boolean enable) throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Check check : table.getChecks()) {
                    String ddl = this.enableCheckConstraint(schema, table, check, enable);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void createIndexes() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Index index : table.getIndices()) {
                    String ddl = this.createIndex(schema, table, index);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void dropIndexes() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                for (Index index : table.getIndices()) {
                    String ddl = this.dropIndex(schema, table, index);
                    this.stream.write(ddl.getBytes());
                }
            }
        }
    }

    private void createSequences() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (this.hasBehavior(BehaviorType.CREATE, schema, table) || table.getPk() == null) continue;
                String ddl = this.createSequence(schema, table);
                this.stream.write(ddl.getBytes());
            }
        }
    }

    private void dropSequences() throws IOException {
        for (Schema schema : this.schemas.getSchemas()) {
            for (Table table : schema.getTables()) {
                if (this.hasBehavior(BehaviorType.CREATE, schema, table) || table.getPk() == null) continue;
                String ddl = this.dropSequence(schema, table);
                this.stream.write(ddl.getBytes());
            }
        }
    }

    private Table getTable(String name, Schema schema) {
        String key = String.valueOf(schema.getName()) + "." + name;
        Table result = this.tableMap.get(key);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("could not find table '" + key + "' in schema '" + schema.getName() + "'");
    }

    private String createTable(Schema schema, Table table) {
        return this.factory.createTable(schema, table);
    }

    private String dropTable(Schema schema, Table table) {
        return this.factory.dropTable(schema, table);
    }

    private String truncateTable(Schema schema, Table table) {
        return this.factory.truncateTable(schema, table);
    }

    private String createSequence(Schema schema, Table table) {
        return this.factory.createSequence(schema, table);
    }

    private String dropSequence(Schema schema, Table table) {
        return this.factory.dropSequence(schema, table);
    }

    private String createIndex(Schema schema, Table table, Index index) {
        return this.factory.createIndex(schema, table, index);
    }

    private String dropIndex(Schema schema, Table table, Index index) {
        return this.factory.dropIndex(schema, table, index);
    }

    private String createCheckConstraint(Schema schema, Table table, Check check) {
        return this.factory.createCheckConstraint(schema, table, check);
    }

    private String dropCheckConstraint(Schema schema, Table table, Check check) {
        return this.factory.dropCheckConstraint(schema, table, check);
    }

    private String enableCheckConstraint(Schema schema, Table table, Check check, boolean enable) {
        return this.factory.enableCheckConstraint(schema, table, check, enable);
    }

    private String createUniqueConstraint(Schema schema, Table table, Unique unique) {
        return this.factory.createUniqueConstraint(schema, table, unique);
    }

    private String dropUniqueConstraint(Schema schema, Table table, Unique unique) {
        return this.factory.dropUniqueConstraint(schema, table, unique);
    }

    private String enableUniqueConstraint(Schema schema, Table table, Unique unique, boolean enable) {
        return this.factory.enableUniqueConstraint(schema, table, unique, enable);
    }

    private String createForeignKeyConstraint(Schema schema, Table table, Fk fk, Table toTable) {
        return this.factory.createForeignKeyConstraint(schema, table, fk, toTable);
    }

    private String dropForeignKeyConstraint(Schema schema, Table table, Fk fk, Table toTable) {
        return this.factory.dropForeignKeyConstraint(schema, table, fk, toTable);
    }

    private String enableForeignKeyConstraint(Schema schema, Table table, Fk fk, Table toTable, boolean enable) {
        return this.factory.enableForeignKeyConstraint(schema, table, fk, toTable, enable);
    }

    private boolean hasBehavior(BehaviorType type, Schema schema, Table table) {
        for (Behavior behavior : table.getBehaviors()) {
            if (behavior.getType().ordinal() != type.ordinal()) continue;
            return true;
        }
        return false;
    }

    private Behavior getBehavior(BehaviorType type, Schema schema, Table table) {
        for (Behavior behavior : table.getBehaviors()) {
            if (behavior.getType().ordinal() != type.ordinal()) continue;
            return behavior;
        }
        return null;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public String getIndentationToken() {
        return this.indentationToken;
    }

    public void setIndentationToken(String indentationToken) {
        this.indentationToken = indentationToken;
    }
}

