/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.Map;
import java.util.TreeMap;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.DataTypeRef;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.TypeRef;
import org.plasma.sdo.DataType;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.DefaultFactory;
import org.plasma.text.lang3gl.java.JDOClassNameResolver;
import org.plasma.text.lang3gl.java.JDOInterfaceNameResolver;

public abstract class JDODefaultFactory
extends DefaultFactory {
    public JDODefaultFactory(Lang3GLContext context) {
        super(context);
    }

    public String createBaseDirectoryName(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getServiceImplementationPackageName(DataAccessProviderName.JDO, pkg.getUri());
        String packageDir = packageName.replace(".", "/");
        StringBuilder buf = new StringBuilder();
        buf.append(packageDir);
        return buf.toString();
    }

    public String createDirectoryName(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getServiceImplementationPackageName(DataAccessProviderName.JDO, pkg.getUri());
        String packageDir = packageName.replace(".", "/");
        StringBuilder buf = new StringBuilder();
        buf.append(packageDir);
        return buf.toString();
    }

    protected String createClassReferenceImportDeclarations(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        JDOClassNameResolver resolver = new JDOClassNameResolver();
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            this.collectSuperclassNames(pkg, clss, nameMap, resolver);
        }
        this.collectDataClassNames(pkg, clss, nameMap, resolver);
        this.collectReferenceClassNames(pkg, clss, nameMap, resolver);
        for (String name : nameMap.values()) {
            if (name.startsWith("java.lang.")) continue;
            buf.append(LINE_SEP);
            buf.append("import ");
            buf.append(name);
            buf.append(";");
        }
        return buf.toString();
    }

    protected String createInterfaceReferenceImportDeclarations(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        JDOInterfaceNameResolver resolver = new JDOInterfaceNameResolver();
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            this.collectSuperclassNames(pkg, clss, nameMap, resolver);
        }
        this.collectDataClassNames(pkg, clss, nameMap, resolver);
        this.collectReferenceClassNames(pkg, clss, nameMap, resolver);
        for (String name : nameMap.values()) {
            if (name.startsWith("java.lang.")) continue;
            buf.append(LINE_SEP);
            buf.append("import ");
            buf.append(name);
            buf.append(";");
        }
        return buf.toString();
    }

    protected String createPackageName(Package pkg) {
        NamespaceProvisioning provisioning = PlasmaConfig.getInstance().getProvisioningByNamespaceURI(DataAccessProviderName.JDO, pkg.getUri());
        String packageName = provisioning.getPackageName();
        StringBuilder buf = new StringBuilder();
        buf.append(packageName);
        return buf.toString();
    }

    protected String createPackageDeclaration(Package pkg) {
        StringBuilder buf = new StringBuilder();
        buf.append("package " + this.createPackageName(pkg));
        buf.append(";");
        return buf.toString();
    }

    protected void collectClassNames(Package pkg, Class clss, Map<String, String> nameMap, boolean collectAbstractClasses) {
        for (Property field : clss.getProperties()) {
            TypeRef type = field.getType();
            if (type instanceof DataTypeRef) {
                DataType sdoType = DataType.valueOf(((DataTypeRef)type).getName());
                java.lang.Class<?> typeClass = this.getTypeClass(sdoType);
                if (typeClass.isPrimitive()) continue;
                nameMap.put(typeClass.getName(), typeClass.getName());
                continue;
            }
            if (!(type instanceof ClassRef)) continue;
            ClassRef cref = (ClassRef)type;
            Class refClass = this.getContext().findClass(cref);
            if (refClass.isAbstract() && !collectAbstractClasses) continue;
            String className = PlasmaConfig.getInstance().getServiceImplementationClassName(DataAccessProviderName.JDO, cref.getUri(), cref.getName());
            String packageName = PlasmaConfig.getInstance().getServiceImplementationPackageName(DataAccessProviderName.JDO, cref.getUri());
            String qualifiedName = String.valueOf(packageName) + "." + className;
            nameMap.put(qualifiedName, qualifiedName);
        }
    }

    protected void collectClassNamesDeep(Package pkg, Class clss, Map<String, String> nameMap) {
        this.collectClassNamesDeep(pkg, clss, nameMap, true);
    }

    protected void collectClassNamesDeep(Package pkg, Class clss, Map<String, String> nameMap, boolean collectAbstractClasses) {
        this.collectClassNames(pkg, clss, nameMap, collectAbstractClasses);
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                Class superClass = this.context.findClass(cref);
                Package superClassPackage = this.context.findPackage(cref);
                this.collectClassNamesDeep(superClassPackage, superClass, nameMap, collectAbstractClasses);
            }
        }
    }

    protected void collectSuperclassNames(Package pkg, Class clss, Map<String, String> nameMap) {
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                String className = PlasmaConfig.getInstance().getServiceImplementationClassName(DataAccessProviderName.JDO, cref.getUri(), cref.getName());
                String packageName = PlasmaConfig.getInstance().getServiceImplementationPackageName(DataAccessProviderName.JDO, cref.getUri());
                String qualifiedName = String.valueOf(packageName) + "." + className;
                nameMap.put(qualifiedName, qualifiedName);
                Class superClass = this.context.findClass(cref);
                Package superClassPackage = this.context.findPackage(cref);
                this.collectSuperclassNames(superClassPackage, superClass, nameMap);
            }
        }
    }
}

