/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.plasma.config.InterfaceProvisioning;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.PropertyNameStyle;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.text.lang3gl.ClassNameResolver;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.DefaultFactory;
import org.plasma.text.lang3gl.java.SDOClassNameResolver;
import org.plasma.text.lang3gl.java.SDOInterfaceNameResolver;

public abstract class SDODefaultFactory
extends DefaultFactory {
    protected static String[] SDO_RESERVED_NAMES = new String[]{"type", "dataobject", "sequence", "list"};
    private Map<String, String> reservedGetterNameMap = new HashMap<String, String>();
    protected InterfaceProvisioning interfaceProvisioning;
    protected ClassNameResolver interfaceResolver = new SDOInterfaceNameResolver();
    protected ClassNameResolver classResolver = new SDOClassNameResolver();

    public SDODefaultFactory(Lang3GLContext context) {
        super(context);
        String[] stringArray = SDO_RESERVED_NAMES;
        int n = SDO_RESERVED_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.reservedGetterNameMap.put(name, name);
            ++n2;
        }
        this.interfaceProvisioning = PlasmaConfig.getInstance().getSDO().getGlobalProvisioning().getInterface();
        if (this.interfaceProvisioning == null) {
            this.interfaceProvisioning = new InterfaceProvisioning();
            this.interfaceProvisioning.setPropertyNameStyle(PropertyNameStyle.ENUMS);
        }
    }

    protected String createPackageDeclaration(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getSDOInterfacePackageName(pkg.getUri());
        StringBuilder buf = new StringBuilder();
        buf.append("package " + packageName);
        buf.append(";");
        return buf.toString();
    }

    public String createBaseDirectoryName(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getSDOInterfacePackageName(pkg.getUri());
        String packageDir = packageName.replace(".", "/");
        StringBuilder buf = new StringBuilder();
        buf.append(packageDir);
        return buf.toString();
    }

    public String createDirectoryName(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getSDOInterfacePackageName(pkg.getUri());
        String packageDir = packageName.replace(".", "/");
        StringBuilder buf = new StringBuilder();
        buf.append(packageDir);
        return buf.toString();
    }

    protected String toQualifiedPropertyNameReference(Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        switch (this.interfaceProvisioning.getPropertyNameStyle()) {
            case ENUMS: {
                buf.append(this.interfaceResolver.getName(clss));
                buf.append(".PROPERTY.");
                buf.append(field.getName());
                buf.append(".name()");
                break;
            }
            case CONSTANTS: {
                buf.append(this.interfaceResolver.getName(clss));
                buf.append(".");
                buf.append(this.toConstantName(field.getName()));
                break;
            }
            default: {
                buf.append("\"");
                buf.append(field.getName());
                buf.append("\"");
            }
        }
        return buf.toString();
    }

    protected String createSDOInterfaceReferenceImportDeclarations(Package pkg, Class clss) {
        StringBuilder buf = new StringBuilder();
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        SDOInterfaceNameResolver resolver = new SDOInterfaceNameResolver();
        this.collectSuperclassNames(pkg, clss, nameMap, resolver);
        for (String name : nameMap.values()) {
            buf.append(LINE_SEP);
            buf.append("import ");
            buf.append(name);
            buf.append(";");
        }
        return buf.toString();
    }

    protected String getImplementationClassName(Class clss) {
        SDOClassNameResolver resolver = new SDOClassNameResolver();
        String name = resolver.getName(clss);
        return name;
    }

    @Override
    protected String toMethodFieldName(String name) {
        String result = this.firstToUpperCase(name);
        if (this.reservedGetterNameMap.get(name.toLowerCase()) != null) {
            result = String.valueOf(result) + "_";
        }
        return result;
    }
}

