/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.xml.uml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.config.ConfigUtils;
import org.plasma.provisioning.Alias;
import org.plasma.provisioning.Behavior;
import org.plasma.provisioning.Class;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.DataTypeRef;
import org.plasma.provisioning.Documentation;
import org.plasma.provisioning.Enumeration;
import org.plasma.provisioning.EnumerationConstraint;
import org.plasma.provisioning.EnumerationLiteral;
import org.plasma.provisioning.EnumerationRef;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.ProvisioningModelAssembler;
import org.plasma.provisioning.ProvisioningModelDataBinding;
import org.plasma.provisioning.SchemaProvisioningModelAssembler;
import org.plasma.provisioning.ValueConstraint;
import org.plasma.query.Query;
import org.plasma.sdo.profile.SDOAlias;
import org.plasma.sdo.profile.SDOEnumerationConstraint;
import org.plasma.sdo.profile.SDOKey;
import org.plasma.sdo.profile.SDONamespace;
import org.plasma.sdo.profile.SDOSort;
import org.plasma.sdo.profile.SDOUniqueConstraint;
import org.plasma.sdo.profile.SDOValueConstraint;
import org.plasma.sdo.profile.SDOXmlProperty;
import org.plasma.xml.schema.Schema;
import org.xml.sax.SAXException;

public class UMLModelAssembler {
    private static Log log = LogFactory.getLog(UMLModelAssembler.class);
    private Model provisioningModel;
    private String destNamespaceURI;
    private String destNamespacePrefix;
    private boolean derivePackageNamesFromURIs = true;
    private Document document;
    private Map<String, Package> packageMap = new HashMap<String, Package>();
    private Map<String, Class> classMap = new HashMap<String, Class>();
    private Map<Class, Package> classPackageMap = new HashMap<Class, Package>();
    private Map<String, Enumeration> enumMap = new HashMap<String, Enumeration>();
    private Map<Enumeration, Package> enumPackageMap = new HashMap<Enumeration, Package>();
    private Namespace umlNs = Namespace.getNamespace((String)"uml", (String)"http://schema.omg.org/spec/UML/2.1.2");
    private Namespace xmiNs = Namespace.getNamespace((String)"xmi", (String)"http://schema.omg.org/spec/XMI/2.1");
    private Namespace plasmaNs = Namespace.getNamespace((String)"Plasma_SDO_Profile", (String)"http://www.magicdraw.com/schemas/Plasma_SDO_Profile.xmi");
    private Element xmiElem;
    private Element modelElem;
    private Map<String, Element> elementMap = new HashMap<String, Element>();
    private Map<String, Element> associationElementMap = new HashMap<String, Element>();
    private Map<String, Element> enumElementMap = new HashMap<String, Element>();

    private UMLModelAssembler() {
    }

    @Deprecated
    public UMLModelAssembler(Query query, String destNamespaceURI, String destNamespacePrefix) {
        this.destNamespaceURI = destNamespaceURI;
        this.destNamespacePrefix = destNamespacePrefix;
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespaceURI' argument");
        }
        if (destNamespacePrefix == null || destNamespacePrefix.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespacePrefix' argument");
        }
        this.document = this.buildDocumentModel(query, this.destNamespaceURI, this.destNamespacePrefix);
    }

    @Deprecated
    public UMLModelAssembler(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        this.destNamespaceURI = destNamespaceURI;
        this.destNamespacePrefix = destNamespacePrefix;
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespaceURI' argument");
        }
        if (destNamespacePrefix == null || destNamespacePrefix.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespacePrefix' argument");
        }
        this.document = this.buildDocumentModel(schema, this.destNamespaceURI, this.destNamespacePrefix);
    }

    public UMLModelAssembler(Model model, String destNamespaceURI, String destNamespacePrefix) {
        this.destNamespaceURI = destNamespaceURI;
        this.destNamespacePrefix = destNamespacePrefix;
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespaceURI' argument");
        }
        if (destNamespacePrefix == null || destNamespacePrefix.trim().length() == 0) {
            throw new IllegalArgumentException("expected 'destNamespacePrefix' argument");
        }
        this.provisioningModel = model;
    }

    public String getDestNamespaceURI() {
        return this.destNamespaceURI;
    }

    public void setDestNamespaceURI(String destNamespaceURI) {
        this.destNamespaceURI = destNamespaceURI;
    }

    public String getDestNamespacePrefix() {
        return this.destNamespacePrefix;
    }

    public void setDestNamespacePrefix(String destNamespacePrefix) {
        this.destNamespacePrefix = destNamespacePrefix;
    }

    public boolean isDerivePackageNamesFromURIs() {
        return this.derivePackageNamesFromURIs;
    }

    public void setDerivePackageNamesFromURIs(boolean derivePackageNamesFromURIs) {
        this.derivePackageNamesFromURIs = derivePackageNamesFromURIs;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = this.buildDocumentModel(this.provisioningModel, this.destNamespaceURI, this.destNamespacePrefix);
        }
        return this.document;
    }

    public String getContent() {
        return this.getContent(new XMLOutputter());
    }

    public String getContent(String indent, boolean newlines) {
        XMLOutputter outputter = new XMLOutputter();
        outputter.getFormat().setIndent(indent);
        return this.getContent(outputter);
    }

    public String getContent(Format format) {
        return this.getContent(new XMLOutputter(format));
    }

    public void getContent(OutputStream stream) {
        XMLOutputter outputter = new XMLOutputter();
        this.getContent(stream, outputter);
    }

    public void getContent(OutputStream stream, String indent, boolean newlines) {
        XMLOutputter outputter = new XMLOutputter();
        outputter.getFormat().setIndent(indent);
        this.getContent(stream, outputter);
    }

    public void getContent(OutputStream stream, Format format) {
        this.getContent(stream, new XMLOutputter(format));
    }

    private String getContent(XMLOutputter outputter) {
        String result = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            try {
                if (this.document == null) {
                    this.document = this.buildDocumentModel(this.provisioningModel, this.destNamespaceURI, this.destNamespacePrefix);
                }
                outputter.output(this.document, (OutputStream)os);
                os.flush();
                result = new String(os.toByteArray());
            }
            catch (IOException iOException) {
                try {
                    os.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private void getContent(OutputStream stream, XMLOutputter outputter) {
        Object result = null;
        try {
            try {
                if (this.document == null) {
                    this.document = this.buildDocumentModel(this.provisioningModel, this.destNamespaceURI, this.destNamespacePrefix);
                }
                outputter.output(this.document, stream);
                stream.flush();
            }
            catch (IOException iOException) {
                try {
                    stream.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Document buildDocumentModel(Query query, String destNamespaceURI, String destNamespacePrefix) {
        ProvisioningModelAssembler stagingAssembler = new ProvisioningModelAssembler(query, destNamespaceURI, destNamespacePrefix);
        Model model = stagingAssembler.getModel();
        if (log.isDebugEnabled()) {
            try {
                BindingValidationEventHandler debugHandler = new BindingValidationEventHandler(){

                    public int getErrorCount() {
                        return 0;
                    }

                    public boolean handleEvent(ValidationEvent ve) {
                        ValidationEventLocator vel = ve.getLocator();
                        String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
                        String sev = "";
                        switch (ve.getSeverity()) {
                            case 0: {
                                sev = "WARNING";
                                break;
                            }
                            case 1: {
                                sev = "ERROR";
                                break;
                            }
                            case 2: {
                                sev = "FATAL_ERROR";
                            }
                        }
                        log.debug((Object)(String.valueOf(sev) + " - " + message));
                        return true;
                    }
                };
                ProvisioningModelDataBinding binding = new ProvisioningModelDataBinding(debugHandler);
                String xml = binding.marshal(model);
                binding.validate(xml);
                log.debug((Object)xml);
            }
            catch (JAXBException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.buildDocumentModel(model, destNamespaceURI, destNamespacePrefix);
    }

    private Document buildDocumentModel(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        SchemaProvisioningModelAssembler stagingAssembler = new SchemaProvisioningModelAssembler(schema, destNamespaceURI, destNamespacePrefix);
        Model model = stagingAssembler.getModel();
        return this.buildDocumentModel(model, destNamespaceURI, destNamespacePrefix);
    }

    private Document buildDocumentModel(Model model, String destNamespaceURI, String destNamespacePrefix) {
        this.xmiElem = new Element("XMI");
        this.xmiElem.setNamespace(this.xmiNs);
        Document document = new Document(this.xmiElem);
        this.xmiElem.setAttribute(new Attribute("version", "2.1", this.xmiNs));
        this.xmiElem.addNamespaceDeclaration(this.umlNs);
        this.xmiElem.addNamespaceDeclaration(this.xmiNs);
        this.xmiElem.addNamespaceDeclaration(this.plasmaNs);
        this.modelElem = this.derivePackageNamesFromURIs ? this.buildModelFromURITokens(model) : this.buildModelFromPackageNames(model);
        this.collectPackages(model);
        this.collectClasses(model);
        this.collectEnumerations(model);
        for (Class clss : this.classMap.values()) {
            Package pkg = this.classPackageMap.get(clss);
            Element clssElem = this.buildClass(clss);
            this.elementMap.put(clss.getId(), clssElem);
            for (Property property : clss.getProperties()) {
                Element ownedAttribute = this.buildProperty(pkg, clss, property, clssElem);
                this.elementMap.put(property.getId(), ownedAttribute);
            }
        }
        for (Class clss : this.classMap.values()) {
            for (Property prop : clss.getProperties()) {
                Element association;
                if (prop.getType() instanceof DataTypeRef || this.associationElementMap.get(prop.getId()) != null) continue;
                String associationUUID = UUID.randomUUID().toString();
                Element leftOwnedAttribute = this.elementMap.get(prop.getId());
                leftOwnedAttribute.setAttribute(new Attribute("association", associationUUID));
                Property targetProp = this.getOppositeProperty(clss, prop);
                if (targetProp != null) {
                    Element rightOwnedAttribute = this.elementMap.get(targetProp.getId());
                    rightOwnedAttribute.setAttribute(new Attribute("association", associationUUID));
                    association = this.buildAssociation(prop, targetProp, this.modelElem, associationUUID);
                    this.associationElementMap.put(prop.getId(), association);
                    this.associationElementMap.put(targetProp.getId(), association);
                    continue;
                }
                Class targetClass = this.getOppositeClass(clss, prop);
                association = this.buildAssociation(prop, targetClass, this.modelElem, associationUUID);
                this.associationElementMap.put(prop.getId(), association);
            }
        }
        return document;
    }

    private void collectPackages(Model model) {
        if (model.getUri() != null) {
            this.packageMap.put(String.valueOf(model.getUri()) + "#" + model.getName(), model);
        }
        for (Package pkg : model.getPackages()) {
            if (pkg.getUri() == null) continue;
            this.packageMap.put(String.valueOf(pkg.getUri()) + "#" + pkg.getName(), pkg);
        }
    }

    private void collectClasses(Model model) {
        this.collectClasses((Package)model);
        for (Package pkg : model.getPackages()) {
            this.collectClasses(pkg);
        }
    }

    private void collectClasses(Package pkg) {
        for (Class clss : pkg.getClazzs()) {
            this.classMap.put(String.valueOf(clss.getUri()) + "#" + clss.getName(), clss);
            this.classPackageMap.put(clss, pkg);
        }
    }

    private void collectEnumerations(Model model) {
        this.collectEnumerations((Package)model);
        for (Package pkg : model.getPackages()) {
            this.collectEnumerations(pkg);
        }
    }

    private void collectEnumerations(Package pkg) {
        for (Enumeration enm : pkg.getEnumerations()) {
            this.enumMap.put(String.valueOf(enm.getUri()) + "#" + enm.getName(), enm);
            this.enumPackageMap.put(enm, pkg);
        }
    }

    private Element buildModelFromPackageNames(Model model) {
        Element modelElem = new Element("Model");
        modelElem.setNamespace(this.umlNs);
        this.xmiElem.addContent((Content)modelElem);
        modelElem.setAttribute(new Attribute("id", model.getId(), this.xmiNs));
        modelElem.setAttribute(new Attribute("name", model.getName()));
        modelElem.setAttribute(new Attribute("visibility", "public"));
        this.elementMap.put(model.getId(), modelElem);
        if (model.getDocumentations() != null) {
            for (Documentation doc : model.getDocumentations()) {
                this.addOwnedComment(modelElem, model.getId(), doc.getBody().getValue());
            }
        }
        if (model.getPackages().size() == 0) {
            Element modelStereotype = new Element(SDONamespace.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)modelStereotype);
            modelStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            modelStereotype.setAttribute(new Attribute("base_Package", model.getId()));
            modelStereotype.setAttribute(new Attribute("uri", model.getUri()));
            if (model.getAlias() != null) {
                this.addAlias(model.getAlias(), model.getId());
            }
        }
        for (Package pkg : model.getPackages()) {
            Element pkgElem = new Element("packagedElement");
            modelElem.addContent((Content)pkgElem);
            pkgElem.setAttribute(new Attribute("type", "uml:Package", this.xmiNs));
            pkgElem.setAttribute(new Attribute("id", pkg.getId(), this.xmiNs));
            pkgElem.setAttribute(new Attribute("name", pkg.getName()));
            pkgElem.setAttribute(new Attribute("visibility", "public"));
            this.elementMap.put(pkg.getId(), pkgElem);
            if (pkg.getAlias() != null) {
                this.addAlias(pkg.getAlias(), pkg.getId());
            }
            Element pkgStereotypeElem = new Element(SDONamespace.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)pkgStereotypeElem);
            pkgStereotypeElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            pkgStereotypeElem.setAttribute(new Attribute("base_Package", pkg.getId()));
            pkgStereotypeElem.setAttribute(new Attribute("uri", pkg.getUri()));
            if (pkg.getDocumentations() == null) continue;
            for (Documentation doc : model.getDocumentations()) {
                this.addOwnedComment(pkgElem, pkg.getId(), doc.getBody().getValue());
            }
        }
        return modelElem;
    }

    private Element buildModelFromURITokens(Model model) {
        Element rootPackageElem = null;
        String[] packageNames = ConfigUtils.toPackageTokens(model.getUri());
        Element modelElem = new Element("Model");
        modelElem.setNamespace(this.umlNs);
        this.xmiElem.addContent((Content)modelElem);
        modelElem.setAttribute(new Attribute("id", model.getId(), this.xmiNs));
        modelElem.setAttribute(new Attribute("name", packageNames[0]));
        modelElem.setAttribute(new Attribute("visibility", "public"));
        this.elementMap.put(model.getId(), modelElem);
        if (model.getDocumentations() != null) {
            for (Documentation doc : model.getDocumentations()) {
                this.addOwnedComment(modelElem, model.getId(), doc.getBody().getValue());
            }
        }
        if (packageNames.length == 1) {
            Element modelStereotype = new Element(SDONamespace.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)modelStereotype);
            modelStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            modelStereotype.setAttribute(new Attribute("base_Package", model.getId()));
            modelStereotype.setAttribute(new Attribute("uri", this.destNamespaceURI));
        }
        rootPackageElem = modelElem;
        int i = 1;
        while (i < packageNames.length) {
            Element pkgElem = new Element("packagedElement");
            rootPackageElem.addContent((Content)pkgElem);
            String id = UUID.randomUUID().toString();
            pkgElem.setAttribute(new Attribute("type", "uml:Package", this.xmiNs));
            pkgElem.setAttribute(new Attribute("id", id, this.xmiNs));
            pkgElem.setAttribute(new Attribute("name", packageNames[i]));
            pkgElem.setAttribute(new Attribute("visibility", "public"));
            this.elementMap.put(id, pkgElem);
            if (i == packageNames.length - 1) {
                Element pkgStereotypeElem = new Element(SDONamespace.class.getSimpleName(), this.plasmaNs);
                this.xmiElem.addContent((Content)pkgStereotypeElem);
                pkgStereotypeElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
                pkgStereotypeElem.setAttribute(new Attribute("base_Package", id));
                pkgStereotypeElem.setAttribute(new Attribute("uri", this.destNamespaceURI));
                if (model.getDocumentations() != null) {
                    for (Documentation doc : model.getDocumentations()) {
                        this.addOwnedComment(pkgElem, id, doc.getBody().getValue());
                    }
                }
            }
            rootPackageElem = pkgElem;
            ++i;
        }
        return rootPackageElem;
    }

    private Element buildClass(Class clss) {
        Package pkgParent = this.classPackageMap.get(clss);
        Element parent = this.elementMap.get(pkgParent.getId());
        Element clssElem = new Element("packagedElement");
        parent.addContent((Content)clssElem);
        this.elementMap.put(clss.getId(), clssElem);
        clssElem.setAttribute(new Attribute("type", "uml:Class", this.xmiNs));
        clssElem.setAttribute(new Attribute("id", clss.getId(), this.xmiNs));
        clssElem.setAttribute(new Attribute("name", clss.getName()));
        clssElem.setAttribute(new Attribute("visibility", "public"));
        if (clss.getDocumentations() != null) {
            for (Documentation doc : clss.getDocumentations()) {
                this.addOwnedComment(clssElem, clss.getId(), doc.getBody().getValue());
            }
        }
        if (clss.getAlias() != null) {
            this.addAlias(clss.getAlias(), clss.getId());
        }
        for (ClassRef baseRef : clss.getSuperClasses()) {
            Element generalizationElem = new Element("generalization");
            generalizationElem.setAttribute(new Attribute("type", "uml:Generalization", this.xmiNs));
            generalizationElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            clssElem.addContent((Content)generalizationElem);
            Class baseClass = this.classMap.get(String.valueOf(baseRef.getUri()) + "#" + baseRef.getName());
            generalizationElem.setAttribute(new Attribute("general", baseClass.getId()));
        }
        if (clss.getBehaviors().size() > 0) {
            this.addBehaviors(clss, clssElem, clss.getBehaviors());
        }
        return clssElem;
    }

    private void addBehaviors(Class clss, Element clssElem, List<Behavior> behaviors) {
        for (Behavior behavior : behaviors) {
            Element ownedBehavior = new Element("ownedBehavior");
            clssElem.addContent((Content)ownedBehavior);
            ownedBehavior.setAttribute(new Attribute("type", "uml:OpaqueBehavior", this.xmiNs));
            ownedBehavior.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            ownedBehavior.setAttribute(new Attribute("visibility", "public"));
            ownedBehavior.setAttribute(new Attribute("name", behavior.getType().name()));
            Element language = new Element("language");
            language.setText(behavior.getLanguage());
            ownedBehavior.addContent((Content)language);
            Element body = new Element("body");
            Text text = new Text(behavior.getValue());
            body.addContent((Content)text);
            ownedBehavior.addContent((Content)body);
        }
    }

    private void addAlias(Alias alias, String namedElementId) {
        Element aliasStereotype = new Element(SDOAlias.class.getSimpleName(), this.plasmaNs);
        this.xmiElem.addContent((Content)aliasStereotype);
        aliasStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        aliasStereotype.setAttribute(new Attribute("base_NamedElement", namedElementId));
        if (alias.getPhysicalName() != null) {
            aliasStereotype.setAttribute(new Attribute("physicalName", alias.getPhysicalName()));
        }
        if (alias.getLocalName() != null) {
            aliasStereotype.setAttribute(new Attribute("localName", alias.getLocalName().trim()));
        }
        if (alias.getBusinessName() != null) {
            aliasStereotype.setAttribute(new Attribute("businessName", alias.getBusinessName().trim()));
        }
    }

    private Element buildProperty(Package pkg, Class clss, Property property, Element parentElem) {
        Element ownedAttribute = new Element("ownedAttribute");
        parentElem.addContent((Content)ownedAttribute);
        ownedAttribute.setAttribute(new Attribute("type", "uml:Property", this.xmiNs));
        ownedAttribute.setAttribute(new Attribute("id", property.getId(), this.xmiNs));
        ownedAttribute.setAttribute(new Attribute("name", property.getName()));
        if (property.getVisibility() != null) {
            ownedAttribute.setAttribute(new Attribute("visibility", property.getVisibility().value()));
        }
        if (property.getDocumentations() != null) {
            for (Documentation doc : property.getDocumentations()) {
                if (doc.getBody() == null) continue;
                this.addOwnedComment(ownedAttribute, property.getId(), doc.getBody().getValue());
            }
        }
        Element upperValue = new Element("upperValue");
        ownedAttribute.addContent((Content)upperValue);
        upperValue.setAttribute(new Attribute("type", "uml:LiteralUnlimitedNatural", this.xmiNs));
        upperValue.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        upperValue.setAttribute(new Attribute("visibility", "public"));
        if (property.isMany()) {
            upperValue.setAttribute(new Attribute("value", "*"));
        } else {
            upperValue.setAttribute(new Attribute("value", "1"));
        }
        Element lowerValue = new Element("lowerValue");
        ownedAttribute.addContent((Content)lowerValue);
        lowerValue.setAttribute(new Attribute("type", "uml:LiteralInteger", this.xmiNs));
        lowerValue.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        lowerValue.setAttribute(new Attribute("visibility", "public"));
        if (property.isNullable()) {
            lowerValue.setAttribute(new Attribute("value", "0"));
        } else {
            lowerValue.setAttribute(new Attribute("value", "1"));
        }
        if (property.getType() instanceof DataTypeRef) {
            Element type = new Element("type");
            ownedAttribute.addContent((Content)type);
            type.setAttribute(new Attribute("type", "uml:DataType", this.xmiNs));
            type.setAttribute(new Attribute("href", "Plasma_SDO_Profile.mdxml#plasma-sdo-profile-datatypes-" + ((DataTypeRef)property.getType()).getName()));
        } else {
            ClassRef targetClassRef = (ClassRef)property.getType();
            Class targetClass = this.classMap.get(String.valueOf(targetClassRef.getUri()) + "#" + targetClassRef.getName());
            ownedAttribute.setAttribute(new Attribute("type", targetClass.getId()));
        }
        if (property.getKey() != null) {
            Element keyStereotype = new Element(SDOKey.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)keyStereotype);
            keyStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            keyStereotype.setAttribute(new Attribute("base_Property", property.getId()));
            keyStereotype.setAttribute(new Attribute("type", property.getKey().getType().name().toLowerCase()));
        }
        if (property.getUniqueConstraint() != null) {
            Element uniqueStereotype = new Element(SDOUniqueConstraint.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)uniqueStereotype);
            uniqueStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            uniqueStereotype.setAttribute(new Attribute("base_Property", property.getId()));
            uniqueStereotype.setAttribute(new Attribute("group", property.getUniqueConstraint().getGroup()));
        }
        if (property.getAlias() != null) {
            this.addAlias(property.getAlias(), property.getId());
        }
        if (property.getSort() != null) {
            Element sequenceStereotype = new Element(SDOSort.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)sequenceStereotype);
            sequenceStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            sequenceStereotype.setAttribute(new Attribute("base_Property", property.getId()));
            sequenceStereotype.setAttribute(new Attribute("key", String.valueOf(property.getSort().getKey())));
        }
        if (property.getXmlProperty() != null) {
            Element xmlPropertyStereotype = new Element(SDOXmlProperty.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)xmlPropertyStereotype);
            xmlPropertyStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            xmlPropertyStereotype.setAttribute(new Attribute("base_Property", property.getId()));
            xmlPropertyStereotype.setAttribute(new Attribute("nodeType", property.getXmlProperty().getNodeType().name().toLowerCase()));
        }
        if (property.getValueConstraint() != null) {
            Element valueContStereotype = new Element(SDOValueConstraint.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)valueContStereotype);
            valueContStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            valueContStereotype.setAttribute(new Attribute("base_Property", property.getId()));
            ValueConstraint vc = property.getValueConstraint();
            if (vc.getTotalDigits() != null) {
                valueContStereotype.setAttribute(new Attribute("totalDigits", String.valueOf(vc.getTotalDigits())));
            }
            if (vc.getFractionDigits() != null) {
                valueContStereotype.setAttribute(new Attribute("fractionDigits", String.valueOf(vc.getFractionDigits())));
            }
            if (vc.getMaxInclusive() != null) {
                valueContStereotype.setAttribute(new Attribute("maxInclusive", String.valueOf(vc.getMaxInclusive())));
            }
            if (vc.getMaxExclusive() != null) {
                valueContStereotype.setAttribute(new Attribute("maxExclusive", String.valueOf(vc.getMaxExclusive())));
            }
            if (vc.getMaxLength() != null) {
                valueContStereotype.setAttribute(new Attribute("maxLength", String.valueOf(vc.getMaxLength())));
            }
            if (vc.getMinInclusive() != null) {
                valueContStereotype.setAttribute(new Attribute("minInclusive", String.valueOf(vc.getMinInclusive())));
            }
            if (vc.getMinExclusive() != null) {
                valueContStereotype.setAttribute(new Attribute("minExclusive", String.valueOf(vc.getMinExclusive())));
            }
            if (vc.getMinLength() != null) {
                valueContStereotype.setAttribute(new Attribute("minLength", String.valueOf(vc.getMinLength())));
            }
            if (vc.getPattern() != null) {
                valueContStereotype.setAttribute(new Attribute("pattern", String.valueOf(vc.getPattern())));
            }
        }
        if (property.getEnumerationConstraint() != null) {
            Element enumConstraintStereotype = new Element(SDOEnumerationConstraint.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)enumConstraintStereotype);
            enumConstraintStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            enumConstraintStereotype.setAttribute(new Attribute("base_Property", property.getId()));
            EnumerationConstraint constraint = property.getEnumerationConstraint();
            EnumerationRef enumRef = constraint.getValue();
            String enumRefId = String.valueOf(enumRef.getUri()) + "#" + enumRef.getName();
            Element enumeration = this.enumElementMap.get(enumRefId);
            if (enumeration == null) {
                enumeration = this.buildEnumeration(constraint);
                Element pkgElement = this.elementMap.get(pkg.getId());
                pkgElement.addContent((Content)enumeration);
                this.enumElementMap.put(enumRefId, enumeration);
            }
            Attribute enumId = enumeration.getAttribute("id", this.xmiNs);
            enumConstraintStereotype.setAttribute(new Attribute("value", enumId.getValue()));
        }
        return ownedAttribute;
    }

    private Element buildAssociation(Property property, Property targetProperty, Element parentElem, String uuid) {
        Element associationElem = new Element("packagedElement");
        parentElem.addContent((Content)associationElem);
        this.associationElementMap.put(property.getId(), associationElem);
        this.associationElementMap.put(targetProperty.getId(), associationElem);
        associationElem.setAttribute(new Attribute("type", "uml:Association", this.xmiNs));
        associationElem.setAttribute(new Attribute("id", uuid, this.xmiNs));
        associationElem.setAttribute(new Attribute("visibility", "public"));
        Element leftMemberEnd = new Element("memberEnd");
        associationElem.addContent((Content)leftMemberEnd);
        leftMemberEnd.setAttribute(new Attribute("idref", property.getId(), this.xmiNs));
        Element rightMemberEnd = new Element("memberEnd");
        associationElem.addContent((Content)rightMemberEnd);
        rightMemberEnd.setAttribute(new Attribute("idref", targetProperty.getId(), this.xmiNs));
        return associationElem;
    }

    private Element buildAssociation(Property property, Class targetClass, Element parentElem, String uuid) {
        Element association = new Element("packagedElement");
        parentElem.addContent((Content)association);
        association.setAttribute(new Attribute("type", "uml:Association", this.xmiNs));
        association.setAttribute(new Attribute("id", uuid, this.xmiNs));
        association.setAttribute(new Attribute("visibility", "public"));
        Element leftMemberEnd = new Element("memberEnd");
        association.addContent((Content)leftMemberEnd);
        leftMemberEnd.setAttribute(new Attribute("idref", property.getId(), this.xmiNs));
        String rightPropId = UUID.randomUUID().toString();
        Element rightMemberEnd = new Element("memberEnd");
        association.addContent((Content)rightMemberEnd);
        rightMemberEnd.setAttribute(new Attribute("idref", rightPropId, this.xmiNs));
        Element navigableOwnedEnd = new Element("navigableOwnedEnd");
        association.addContent((Content)navigableOwnedEnd);
        navigableOwnedEnd.setAttribute(new Attribute("idref", rightPropId, this.xmiNs));
        Element ownedEnd = new Element("ownedEnd");
        association.addContent((Content)ownedEnd);
        ownedEnd.setAttribute(new Attribute("type", "uml:Property", this.xmiNs));
        ownedEnd.setAttribute(new Attribute("id", rightPropId, this.xmiNs));
        ownedEnd.setAttribute(new Attribute("visibility", "private"));
        ownedEnd.setAttribute(new Attribute("type", targetClass.getId()));
        Element upperValue = new Element("upperValue");
        ownedEnd.addContent((Content)upperValue);
        upperValue.setAttribute(new Attribute("type", "uml:LiteralUnlimitedNatural", this.xmiNs));
        upperValue.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        upperValue.setAttribute(new Attribute("visibility", "public"));
        upperValue.setAttribute(new Attribute("value", "*"));
        Element lowerValue = new Element("lowerValue");
        ownedEnd.addContent((Content)lowerValue);
        lowerValue.setAttribute(new Attribute("type", "uml:LiteralInteger", this.xmiNs));
        lowerValue.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        lowerValue.setAttribute(new Attribute("visibility", "public"));
        return association;
    }

    private Element buildEnumeration(EnumerationConstraint constraint) {
        Enumeration enm = this.enumMap.get(String.valueOf(constraint.getValue().getUri()) + "#" + constraint.getValue().getName());
        Element enumerationElem = new Element("packagedElement");
        enumerationElem.setAttribute(new Attribute("type", "uml:Enumeration", this.xmiNs));
        String enumId = UUID.randomUUID().toString();
        enumerationElem.setAttribute(new Attribute("id", enumId, this.xmiNs));
        enumerationElem.setAttribute(new Attribute("name", enm.getName()));
        enumerationElem.setAttribute(new Attribute("visibility", "public"));
        if (enm.getDocumentations() != null) {
            for (Documentation doc : enm.getDocumentations()) {
                this.addOwnedComment(enumerationElem, enumId, doc.getBody().getValue());
            }
        }
        for (EnumerationLiteral lit : enm.getEnumerationLiterals()) {
            Element literal = new Element("ownedLiteral");
            enumerationElem.addContent((Content)literal);
            literal.setAttribute(new Attribute("type", "uml:EnumerationLiteral", this.xmiNs));
            String literalId = UUID.randomUUID().toString();
            literal.setAttribute(new Attribute("id", literalId, this.xmiNs));
            literal.setAttribute(new Attribute("name", lit.getValue()));
            literal.setAttribute(new Attribute("visibility", "public"));
            if (lit.getDocumentations() != null) {
                for (Documentation doc : lit.getDocumentations()) {
                    this.addOwnedComment(literal, literalId, doc.getBody().getValue());
                }
            }
            if (lit.getAlias() == null || lit.getAlias().getPhysicalName() == null) continue;
            Element aliasStereotype = new Element(SDOAlias.class.getSimpleName(), this.plasmaNs);
            this.xmiElem.addContent((Content)aliasStereotype);
            aliasStereotype.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
            aliasStereotype.setAttribute(new Attribute("base_NamedElement", literalId));
            aliasStereotype.setAttribute(new Attribute("physicalName", lit.getAlias().getPhysicalName()));
        }
        return enumerationElem;
    }

    private void addOwnedComment(Element owner, String ownerId, String commentBody) {
        Element comment = new Element("ownedComment");
        owner.addContent((Content)comment);
        comment.setAttribute(new Attribute("type", "uml:Comment", this.xmiNs));
        comment.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        Element body = new Element("body");
        comment.addContent((Content)body);
        body.addContent((Content)new CDATA(commentBody));
        Element annotatedElement = new Element("annotatedElement");
        comment.addContent((Content)annotatedElement);
        annotatedElement.setAttribute(new Attribute("idref", ownerId, this.xmiNs));
    }

    private Class getOppositeClass(Class def, Property propertyDef) {
        Class targetDef = this.classMap.get(String.valueOf(propertyDef.getType().getUri()) + "#" + propertyDef.getType().getName());
        return targetDef;
    }

    private Property getOppositeProperty(Class def, Property propertyDef) {
        Class targetDef = this.classMap.get(String.valueOf(propertyDef.getType().getUri()) + "#" + propertyDef.getType().getName());
        for (Property p : targetDef.getProperties()) {
            if (!p.getName().equals(propertyDef.getOpposite())) continue;
            return p;
        }
        return null;
    }
}

