//==============================================================================
//                                                          
// This software artifact was generated using PlasmaSDO    
// provisioning tools.                                      
//                                                          
//==============================================================================
package org.plasma.sdo.profile;


import fUML.Syntax.Classes.Kernel.*;
import org.modeldriven.fuml.repository.ext.Stereotype;
import org.plasma.sdo.Concurrent;
/**
* 
* Annotates or tags properties as applicable for use within various operations involving concurrency control. Concurrency control deals with handling collisions and other issues which arise when allowing multiple users or processes simultaneous access to shared entities within a data store. Generic SDO Data Access Services (DAS) are faced with the problem of determining at runtime for any data-object within a modified data-graph, which properties are useful for various checks and operations under a particular concurrency control type or strategy. Properties tagged as concurrent at the model level are made available to Data Access Services within the PlasmaSDOâ„¢ runtime and build-time environments.
* 
* @author Plasma-Team
* @version 1.2.1
*/
public class SDOConcurrent extends Stereotype
    implements Concurrent
{

    public static final String BASE__PROPERTY = "base_Property";
    /**
    * Specifies the general category of concurrency or concurrency control under which a property participates
    */
    public static final String TYPE = "type";
    /**
    * Denotes or provides a hint as to the nature of the data instructive to vaious checks and operations under a particular concurrency control type or category.
    */
    public static final String DATA_FLAVOR = "dataFlavor";

    private Property base_Property;
    /**
    * Specifies the general category of concurrency or concurrency control under which a property participates
    */
    private ConcurrencyType type;
    /**
    * Denotes or provides a hint as to the nature of the data instructive to vaious checks and operations under a particular concurrency control type or category.
    */
    private ConcurrentDataFlavor dataFlavor;


    public Property getBase_Property() {
        return this.base_Property;
    }

    public void setBase_Property(Property value) {
        this.base_Property = value;
    }

    public ConcurrencyType getType() {
        return this.type;
    }

    public void setType(ConcurrencyType value) {
        this.type = value;
    }

    public ConcurrentDataFlavor getDataFlavor() {
        return this.dataFlavor;
    }

    public void setDataFlavor(ConcurrentDataFlavor value) {
        this.dataFlavor = value;
    }
}
