/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.ProvisioningModelDataBinding;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.RDBDialect;
import org.plasma.provisioning.cli.RDBException;
import org.plasma.provisioning.cli.RDBToolAction;
import org.plasma.provisioning.rdb.ConverterSupport;
import org.plasma.provisioning.rdb.MySql55Converter;
import org.plasma.provisioning.rdb.MySqlVersion;
import org.plasma.provisioning.rdb.MySqlVersionFinder;
import org.plasma.provisioning.rdb.Oracle11GConverter;
import org.plasma.provisioning.rdb.OracleVersion;
import org.plasma.provisioning.rdb.OracleVersionFinder;
import org.plasma.provisioning.rdb.RDBConstants;
import org.plasma.provisioning.rdb.mysql.any.GlobalVariable;
import org.plasma.provisioning.rdb.oracle.any.sys.Version;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.text.ddl.DDLFactory;
import org.plasma.text.ddl.DDLModelAssembler;
import org.plasma.text.ddl.DDLModelDataBinding;
import org.plasma.text.ddl.DDLOperation;
import org.plasma.text.ddl.DDLStreamAssembler;
import org.plasma.text.ddl.DefaultDDLFactory;
import org.plasma.text.ddl.MySQLFactory;
import org.plasma.text.ddl.OracleFactory;
import org.plasma.xml.uml.UMLModelAssembler;
import org.xml.sax.SAXException;

public class RDBTool
extends ProvisioningTool
implements RDBConstants {
    private static Log log = LogFactory.getLog(RDBTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws JAXBException, SAXException, IOException {
        if (args.length < 1) {
            RDBTool.printUsage();
            return;
        }
        if (!args[0].startsWith("-")) {
            RDBTool.printUsage();
            return;
        }
        RDBToolAction command = null;
        try {
            command = RDBToolAction.valueOf(args[0].substring(1));
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < RDBToolAction.values().length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(RDBToolAction.values()[i].name());
            }
            throw new IllegalArgumentException("'" + args[0].substring(1) + "' - expected one of [" + buf.toString() + "]");
        }
        switch (command) {
            case create: 
            case drop: 
            case truncate: {
                if (args.length == 3) break;
                RDBTool.printUsage();
                return;
            }
            case reverse: {
                if (args.length == 4 || args.length == 5) break;
                RDBTool.printUsage();
                return;
            }
        }
        RDBDialect dialect = null;
        try {
            String dialectArg = args[1];
            if (dialectArg.startsWith("-")) {
                dialectArg = dialectArg.substring(1);
            }
            dialect = RDBDialect.valueOf(dialectArg);
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < RDBDialect.values().length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(RDBDialect.values()[i].name());
            }
            throw new IllegalArgumentException("'" + args[1] + "' - expected one of [" + buf.toString() + "]");
        }
        File dest = new File(args[2]);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        switch (command) {
            case create: 
            case drop: 
            case truncate: {
                DDLOperation operation = DDLOperation.valueOf(command.name());
                DDLModelAssembler modelAssembler = new DDLModelAssembler();
                DDLModelDataBinding binding = new DDLModelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
                if (log.isDebugEnabled()) {
                    File file = new File(dest.getParentFile(), "ddl-model.xml");
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        binding.marshal(modelAssembler.getSchemas(), fos);
                        fos.flush();
                    }
                    finally {
                        fos.close();
                    }
                }
                DefaultDDLFactory factory = null;
                switch (dialect) {
                    case oracle: {
                        factory = new OracleFactory();
                        break;
                    }
                    case mysql: {
                        factory = new MySQLFactory();
                        break;
                    }
                    default: {
                        throw new RDBException("unknown dialect, '" + dialect.name() + "'");
                    }
                }
                FileOutputStream stream = new FileOutputStream(dest);
                DDLStreamAssembler ddlAssembler = new DDLStreamAssembler(modelAssembler.getSchemas(), (DDLFactory)((Object)factory), operation, stream);
                ddlAssembler.start();
                stream.flush();
                break;
            }
            case reverse: {
                String[] schemaNames = null;
                String[] namespaces = null;
                if (args.length == 5) {
                    namespaces = args[3].split(",");
                    if (namespaces.length != (schemaNames = args[4].split(",")).length) {
                        throw new RDBException("expected 'schemaNames' and 'namespaces' arguments with equal number of comma seperated  values");
                    }
                } else {
                    schemaNames = args[3].split(",");
                    namespaces = new String[schemaNames.length];
                    for (int i = 0; i < schemaNames.length; ++i) {
                        namespaces[i] = "http://" + schemaNames[i];
                    }
                }
                PlasmaRepository.getInstance();
                Model model = null;
                switch (dialect) {
                    case oracle: {
                        RDBTool.loadDynamicArtifact("Plasma_RDB_Oracle.mdxml");
                        RDBTool.loadDynamicNamespace("http://org.plasma/sdo/oracle/any/sys", Version.class.getPackage(), "Plasma_RDB_Oracle.mdxml");
                        OracleVersionFinder versionFinder = new OracleVersionFinder();
                        OracleVersion version = versionFinder.findVersion();
                        log.info((Object)("detected version '" + (Object)((Object)version) + "'"));
                        ConverterSupport converter = null;
                        switch (version) {
                            case _9i: 
                            case _10g: 
                            case _11g: {
                                RDBTool.loadDynamicNamespace("http://org.plasma/sdo/oracle/11g/sys", org.plasma.provisioning.rdb.oracle.g11.sys.Version.class.getPackage(), "Plasma_RDB_Oracle.mdxml");
                                converter = new Oracle11GConverter(schemaNames, namespaces);
                                break;
                            }
                            default: {
                                log.warn((Object)"unknown Oracle version - using 11g metamodel");
                                RDBTool.loadDynamicNamespace("http://org.plasma/sdo/oracle/11g/sys", org.plasma.provisioning.rdb.oracle.g11.sys.Version.class.getPackage(), "Plasma_RDB_Oracle.mdxml");
                                converter = new Oracle11GConverter(schemaNames, namespaces);
                            }
                        }
                        model = converter.buildModel();
                        break;
                    }
                    case mysql: {
                        RDBTool.loadDynamicArtifact("Plasma_RDB_MySql.mdxml");
                        RDBTool.loadDynamicNamespace("http://org.plasma/sdo/mysql/any", GlobalVariable.class.getPackage(), "Plasma_RDB_MySql.mdxml");
                        MySqlVersionFinder mysqlVersionFinder = new MySqlVersionFinder();
                        MySqlVersion mysqlVersion = mysqlVersionFinder.findVersion();
                        log.info((Object)("detected version '" + (Object)((Object)mysqlVersion) + "'"));
                        ConverterSupport converter = null;
                        switch (mysqlVersion) {
                            case _5_5: {
                                RDBTool.loadDynamicNamespace("http://org.plasma/sdo/mysql/5_5", org.plasma.provisioning.rdb.mysql.v5_5.GlobalVariable.class.getPackage(), "Plasma_RDB_MySql.mdxml");
                                converter = new MySql55Converter(schemaNames, namespaces);
                                break;
                            }
                            default: {
                                log.warn((Object)"unknown MySql version - using 5.5 metamodel");
                                RDBTool.loadDynamicNamespace("http://org.plasma/sdo/mysql/5_5", org.plasma.provisioning.rdb.mysql.v5_5.GlobalVariable.class.getPackage(), "Plasma_RDB_MySql.mdxml");
                                converter = new MySql55Converter(schemaNames, namespaces);
                            }
                        }
                        model = converter.buildModel();
                        break;
                    }
                    default: {
                        throw new RDBException("unknown dialect, '" + dialect.name() + "'");
                    }
                }
                if (log.isDebugEnabled()) {
                    ProvisioningModelDataBinding provBinding = new ProvisioningModelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
                    String xml = provBinding.marshal(model);
                    File outFile = new File(dest.getParentFile(), "technical-model.xml");
                    FileOutputStream stream = new FileOutputStream(outFile);
                    stream.write(xml.getBytes());
                    stream.flush();
                    stream.close();
                    log.debug((Object)("wrote merged model file to: " + outFile.getAbsoluteFile()));
                    log.debug((Object)("reading merged model file: " + outFile.getAbsoluteFile()));
                    model = (Model)provBinding.unmarshal(new FileInputStream(outFile));
                }
                ModelAdapter helper = new ModelAdapter(model);
                UMLModelAssembler umlAssembler = new UMLModelAssembler(model, namespaces[0], "tns");
                umlAssembler.setDerivePackageNamesFromURIs(false);
                Document document = umlAssembler.getDocument();
                log.info((Object)("marshaling XMI model to file, '" + dest.getName() + "'"));
                try {
                    FileOutputStream os = new FileOutputStream(dest);
                    XMLOutputter outputter = new XMLOutputter();
                    outputter.output(document, (OutputStream)os);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new ProvisioningException(e);
                }
                catch (IOException e) {
                    throw new ProvisioningException(e);
                }
            }
            default: {
                throw new RDBException("unknown command '" + command.toString() + "'");
            }
        }
    }

    private static void loadDynamicNamespace(String namespace, Package pkg, String artifactResourceName) {
        NamespaceProvisioning provisioning = new NamespaceProvisioning();
        provisioning.setPackageName(pkg.getName());
        PlasmaConfig.getInstance().addDynamicSDONamespace(namespace, artifactResourceName, provisioning);
    }

    private static void loadDynamicArtifact(String artifactResourceName) {
        InputStream stream = RDBTool.class.getClassLoader().getResourceAsStream(artifactResourceName);
        if (log.isDebugEnabled()) {
            log.info((Object)"loading UML/XMI model");
        }
        Fuml.load((ResourceArtifact)new ResourceArtifact(artifactResourceName, artifactResourceName, stream));
    }

    private static void printUsage() {
        log.info((Object)"Usage: java org.plasma.provisioning.cli.RDBTool [-command <create | drop | truncate | reverse>] [dialect <oracle | mysql>] [dest-file] [dest-namespace-URI][schema-name]* ");
    }
}

