/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.provisioning.Model;
import org.plasma.provisioning.ProvisioningModelDataBinding;
import org.plasma.provisioning.SchemaProvisioningModelAssembler;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.ProvisioningTarget;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.XSDToolAction;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaDataBinding;
import org.plasma.xml.uml.UMLModelAssembler;
import org.xml.sax.SAXException;

public class XSDTool
extends ProvisioningTool {
    private static Log log = LogFactory.getLog(XSDTool.class);

    public static void main(String[] args) throws TransformerConfigurationException, IOException, TransformerException, ClassNotFoundException {
        if (args.length < 6) {
            XSDTool.printUsage();
            return;
        }
        if (!args[0].startsWith("-")) {
            XSDTool.printUsage();
            return;
        }
        XSDToolAction command = null;
        try {
            command = XSDToolAction.valueOf(args[0].substring(1));
        }
        catch (IllegalArgumentException e) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < XSDToolAction.values().length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(XSDToolAction.values()[i].name());
            }
            throw new IllegalArgumentException("'" + args[0].substring(1) + "' - expected one of [" + buf.toString() + "]");
        }
        File sourceFile = new File(args[1]);
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("given source file '" + args[1] + "' does not exist");
        }
        File destFile = new File(args[2]);
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("directory path cannot be created for given dest file '" + args[2] + "' ");
        }
        String destFileType = args[3];
        if (destFileType == null || destFileType.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument, destFileType");
        }
        ProvisioningTarget targetType = null;
        try {
            targetType = ProvisioningTarget.valueOf(destFileType);
        }
        catch (IllegalArgumentException e) {
            ArrayList<String> displayValues = new ArrayList<String>();
            for (ProvisioningTarget v : ProvisioningTarget.values()) {
                displayValues.add(v.name());
            }
            throw new IllegalArgumentException("unknown target type '" + destFileType + "' - expected one of " + displayValues + "");
        }
        String destNamespaceURI = args[4];
        if (destNamespaceURI == null || destNamespaceURI.trim().length() == 0) {
            throw new IllegalArgumentException("expected argument, destNamespaceURI");
        }
        String destNamespacePrefix = args[5];
        if (destNamespacePrefix == null || destNamespacePrefix.trim().length() == 0) {
            destNamespacePrefix = "tns";
        }
        long lastExecution = 0L;
        if (args.length >= 7) {
            try {
                lastExecution = Long.valueOf(args[6]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(XSDTool.getUsage());
            }
        }
        block3 : switch (command) {
            case convert: {
                if (sourceFile.lastModified() < lastExecution) {
                    log.info((Object)"skipping conversion - no stale source XSD detected");
                    return;
                }
                switch (targetType) {
                    case xmi: {
                        log.info((Object)"compiling Schema into UML/XMI model");
                        XSDTool.generateUMLModel(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                        break block3;
                    }
                }
                throw new IllegalArgumentException("unknown target type '" + targetType.name() + "'");
            }
            default: {
                throw new IllegalArgumentException("unknown command '" + command.toString() + "'");
            }
        }
    }

    private static void generateUMLModel(File schemaFile, File destFile, String destNamespaceURI, String destNamespacePrefix) throws FileNotFoundException {
        String namespacePrefix;
        log.info((Object)("unmarshaling schema file '" + schemaFile.getName() + "'"));
        Schema schema = XSDTool.unmarshalSchema(new FileInputStream(schemaFile));
        String namespaceURI = destNamespaceURI;
        if (namespaceURI == null) {
            namespaceURI = schema.getTargetNamespace();
        }
        if ((namespacePrefix = destNamespacePrefix) == null) {
            namespacePrefix = "tns";
        }
        SchemaProvisioningModelAssembler stagingAssembler = new SchemaProvisioningModelAssembler(schema, namespaceURI, namespacePrefix);
        Model stagingModel = stagingAssembler.getModel();
        if (log.isDebugEnabled()) {
            String schemaName = schema.getId();
            if (schemaName == null || schemaName.trim().length() == 0) {
                schemaName = schemaFile.getName();
            }
            XSDTool.writeSchemaStagingModel(stagingModel, ".", XSDTool.class.getSimpleName() + "-" + schemaName + "-model.xml");
        }
        ModelAdapter helper = new ModelAdapter(stagingModel);
        UMLModelAssembler assembler = new UMLModelAssembler(stagingModel, namespaceURI, namespacePrefix);
        Document document = assembler.getDocument();
        log.info((Object)("marshaling XMI model to file, '" + destFile.getName() + "'"));
        try {
            FileOutputStream os = new FileOutputStream(destFile);
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private static void writeSchemaStagingModel(Model stagingModel, String location, String fileName) {
        try {
            BindingValidationEventHandler debugHandler = new BindingValidationEventHandler(){

                public int getErrorCount() {
                    return 0;
                }

                public boolean handleEvent(ValidationEvent ve) {
                    ValidationEventLocator vel = ve.getLocator();
                    String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
                    switch (ve.getSeverity()) {
                        default: 
                    }
                    return true;
                }
            };
            ProvisioningModelDataBinding binding = new ProvisioningModelDataBinding(debugHandler);
            String xml = binding.marshal(stagingModel);
            binding.validate(xml);
            File provDebugFile = null;
            provDebugFile = location != null ? new File(location, fileName) : File.createTempFile(fileName, "");
            FileOutputStream provDebugos = new FileOutputStream(provDebugFile);
            log.debug((Object)("Writing provisioning model to: " + provDebugFile.getAbsolutePath()));
            binding.marshal(stagingModel, provDebugos);
        }
        catch (JAXBException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static Schema unmarshalSchema(InputStream stream) {
        try {
            SchemaDataBinding binding = new SchemaDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            return (Schema)binding.unmarshal(stream);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    private static String getUsage() {
        return "usage: -action sourceFile destFile destFileType destNamespaceURI destNamespacePrefix  [last-execution-time]";
    }

    private static void printUsage() {
        log.info((Object)XSDTool.getUsage());
    }
}

