/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.plasma.provisioning.xsd.AbstractCollector;
import org.plasma.xml.schema.AbstractSimpleType;
import org.plasma.xml.schema.List;
import org.plasma.xml.schema.Restriction;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SimpleType;
import org.plasma.xml.schema.SimpleTypeVisitor;

public class DatatypeCollector
extends AbstractCollector
implements SimpleTypeVisitor {
    private Schema schema;
    private Map<String, SimpleType> simpleTypeMap;
    private java.util.List<QName> result = new ArrayList<QName>();
    private boolean isListType = false;

    public DatatypeCollector(Schema schema, Map<String, SimpleType> simpleTypeMap) {
        this.schema = schema;
        this.simpleTypeMap = simpleTypeMap;
    }

    public java.util.List<QName> getResult() {
        return this.result;
    }

    public boolean isListType() {
        return this.isListType;
    }

    @Override
    public void visit(AbstractSimpleType target, AbstractSimpleType source, int level) {
        Restriction restriction = target.getRestriction();
        if (restriction != null) {
            QName typeName = restriction.getBase();
            if (typeName != null && typeName.getNamespaceURI() != null && typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                this.result.add(typeName);
            }
        } else if (target.getList() != null) {
            this.isListType = true;
            List typeList = target.getList();
            QName typeName = typeList.getItemType();
            if (typeName != null && typeName.getNamespaceURI() != null && typeName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                this.result.add(typeName);
            }
        }
    }

    @Override
    public SimpleType getTopLevelSimpleType(QName name) {
        return this.simpleTypeMap.get(name.getLocalPart());
    }

    @Override
    public String getTargetNamespace() {
        return this.schema.getTargetNamespace();
    }
}

