/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.CommitCollector;
import org.plasma.sdo.access.provider.common.SimpleCollector;

public class CreatedObjectCollector
extends SimpleCollector
implements CommitCollector {
    private static Log log = LogFactory.getFactory().getInstance(CreatedObjectCollector.class);

    private CreatedObjectCollector() {
    }

    public CreatedObjectCollector(DataGraph dataGraph) {
        this.changeSummary = (PlasmaChangeSummary)dataGraph.getChangeSummary();
        this.collect();
    }

    private void collect() {
        List<DataObject> list = this.changeSummary.getChangedDataObjects();
        for (DataObject changed : list) {
            if (!this.changeSummary.isCreated(changed)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing changed object: " + changed.toString()));
            }
            PlasmaType changedType = (PlasmaType)changed.getType();
            int changedDepth = this.changeSummary.getPathDepth(changed);
            DataObject[] resultArray = super.toArray();
            boolean childFound = false;
            for (int i = 0; i < resultArray.length; ++i) {
                PlasmaType resultType = (PlasmaType)resultArray[i].getType();
                boolean prepend = false;
                if (resultType.getQualifiedName() != changedType.getQualifiedName()) {
                    if (this.isRelation(resultArray[i], changed, AssociationPath.singular)) {
                        prepend = true;
                    }
                } else if (this.hasChildLink(resultArray[i], changed)) {
                    prepend = true;
                } else {
                    int resultDepth = this.changeSummary.getPathDepth(resultArray[i]);
                    if (changedDepth < resultDepth) {
                        prepend = true;
                    }
                }
                if (super.contains(changed)) {
                    throw new DataAccessException("unexpected changed object: " + changed.toString());
                }
                if (!prepend) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("prepending changed object: " + changed.toString() + " at position " + i));
                }
                super.add(i, (PlasmaDataObject)changed);
                childFound = true;
                break;
            }
            if (childFound) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("appending changed object: " + changed.toString()));
            }
            super.add((PlasmaDataObject)changed);
        }
    }
}

