/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.CopyHelper;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.helper.DataGraphCopyVisitor;
import org.plasma.sdo.helper.PlasmaDataFactory;

public class PlasmaCopyHelper
implements CopyHelper {
    public static PlasmaCopyHelper INSTANCE = PlasmaCopyHelper.initializeInstance();

    private PlasmaCopyHelper() {
    }

    public static PlasmaCopyHelper instance() {
        if (INSTANCE == null) {
            PlasmaCopyHelper.initializeInstance();
        }
        return INSTANCE;
    }

    private static synchronized PlasmaCopyHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaCopyHelper();
        }
        return INSTANCE;
    }

    @Override
    public DataObject copyShallow(DataObject dataObject) {
        CoreDataObject result = (CoreDataObject)PlasmaDataFactory.INSTANCE.create(dataObject.getType());
        Object value = null;
        for (Property property : dataObject.getType().getProperties()) {
            value = dataObject.get(property);
            if (value == null || !property.getType().isDataType()) continue;
            if (!property.isReadOnly()) {
                result.set(property, value);
                continue;
            }
            result.getValueObject().put(property.getName(), value);
        }
        return result;
    }

    @Override
    public DataObject copy(DataObject dataObject) {
        DataGraphCopyVisitor visitor = new DataGraphCopyVisitor();
        ((PlasmaDataObject)dataObject).accept(visitor);
        return visitor.getResult();
    }

    public DataObject copy(DataObject dataObject, Type[] referenceTypes) {
        DataGraphCopyVisitor visitor = new DataGraphCopyVisitor(referenceTypes);
        ((PlasmaDataObject)dataObject).accept(visitor);
        return visitor.getResult();
    }
}

