/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import commonj.sdo.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.ClassRef;
import org.plasma.provisioning.DataTypeRef;
import org.plasma.provisioning.Package;
import org.plasma.provisioning.Property;
import org.plasma.provisioning.TypeRef;
import org.plasma.provisioning.adapter.FieldAdapter;
import org.plasma.sdo.DataType;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.text.lang3gl.ClassFactory;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.SDOClassNameResolver;
import org.plasma.text.lang3gl.java.SDODefaultFactory;
import org.plasma.text.lang3gl.java.SDOInterfaceNameResolver;
import org.plasma.text.lang3gl.java.TypeClassInfo;

public class SDOClassFactory
extends SDODefaultFactory
implements ClassFactory {
    public SDOClassFactory(Lang3GLContext context) {
        super(context);
    }

    @Override
    public String createFileName(org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        SDOClassNameResolver resolver = new SDOClassNameResolver();
        String name = resolver.getName(clss);
        buf.append(name);
        buf.append(".java");
        return buf.toString();
    }

    @Override
    public String createContent(Package pkg, org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.createPackageDeclaration(pkg));
        buf.append(LINE_SEP);
        buf.append(this.createThirdPartyImportDeclarations(pkg, clss));
        SDOInterfaceNameResolver resolver = new SDOInterfaceNameResolver();
        Map<String, String> importMap = this.createFieldImportMap(pkg, clss, resolver);
        this.collectSuperClassNames(pkg, clss, importMap, resolver);
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(pkg.getUri());
        String interfacePackageName = sdoNamespace.getProvisioning().getPackageName();
        String packageName = this.createPackageName(pkg);
        if (!packageName.equals(interfacePackageName)) {
            String qualifiedName = interfacePackageName + "." + resolver.getName(clss);
            importMap.put(qualifiedName, qualifiedName);
        }
        buf.append(this.createImportDeclarations(importMap));
        buf.append(LINE_SEP);
        buf.append(LINE_SEP);
        buf.append(this.createTypeDeclaration(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.createStaticFieldDeclarations(clss));
        buf.append(LINE_SEP);
        buf.append(this.createConstructors(pkg, clss));
        for (Property field : clss.getProperties()) {
            buf.append(this.createPrivateFieldDeclaration(clss, field));
        }
        TreeMap<String, FieldAdapter> fields = new TreeMap<String, FieldAdapter>();
        this.collectProvisioningFields(pkg, clss, pkg, clss, fields);
        for (String name : fields.keySet()) {
            FieldAdapter adapter = (FieldAdapter)fields.get(name);
            buf.append(LINE_SEP);
            buf.append(this.createOperations(adapter.getFieldPackage(), adapter.getFieldClass(), adapter.getField()));
        }
        buf.append(LINE_SEP);
        buf.append(this.endBody());
        return buf.toString();
    }

    protected String createTypeDeclaration(Package pkg, org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.createTypeDeclarationJavadoc(pkg, clss));
        buf.append(this.newline(0));
        buf.append("public class ");
        buf.append(this.getImplementationClassName(clss));
        buf.append(" extends ");
        buf.append(CoreDataObject.class.getSimpleName());
        buf.append(" implements Serializable, ");
        buf.append(this.interfaceResolver.getName(clss));
        return buf.toString();
    }

    private String createTypeDeclarationJavadoc(Package pkg, org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append("/**");
        String docs = this.getWrappedDocmentations(clss.getDocumentations(), 0);
        if (docs.trim().length() > 0) {
            buf.append(docs);
            buf.append(this.newline(0));
            buf.append(" * <p></p>");
        }
        buf.append(this.newline(0));
        buf.append(" * Generated implementation class representing the domain model entity <b>");
        buf.append(clss.getName());
        buf.append("</b>.");
        if (clss.getAlias() != null && clss.getAlias().getPhysicalName() != null) {
            buf.append(this.newline(0));
            buf.append(" *");
            buf.append(this.newline(0));
            buf.append(" * <p></p>");
            buf.append(this.newline(0));
            buf.append(" * <b>Data Store Mapping:</b>");
            buf.append(this.newline(0));
            buf.append(" * Corresponds to the physical data store entity <b>");
            buf.append(clss.getAlias().getPhysicalName());
            buf.append("</b>.");
            buf.append(this.newline(0));
            buf.append(" * <p></p>");
            buf.append(this.newline(0));
            buf.append(" *");
        }
        buf.append(this.newline(0));
        buf.append(" */");
        return buf.toString();
    }

    protected String createStaticFieldDeclarations(org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getContext().getIndentationToken());
        buf.append("private static final long serialVersionUID = 1L;");
        buf.append(this.newline(1));
        buf.append("/** The SDO namespace URI associated with the SDO Type for this class */");
        buf.append(this.newline(1));
        buf.append("public static final String NAMESPACE_URI = \"");
        buf.append(clss.getUri());
        buf.append("\";");
        return buf.toString();
    }

    protected String createPrivateFieldDeclaration(org.plasma.provisioning.Class clss, Property field) {
        return "";
    }

    protected String createConstructors(Package pkg, org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.newline(1));
        buf.append("/**");
        buf.append(this.newline(1));
        buf.append(" * Default No-arg constructor required for serialization operations. This method");
        buf.append(this.newline(1));
        buf.append(" * is NOT intended to be used within application source code.");
        buf.append(this.newline(1));
        buf.append(" */");
        buf.append(this.newline(1));
        buf.append("public ");
        buf.append(this.getImplementationClassName(clss));
        buf.append("() {");
        buf.append(this.newline(2));
        buf.append("super();");
        buf.append(this.newline(1));
        buf.append("}");
        buf.append(this.newline(1));
        buf.append("public ");
        buf.append(this.getImplementationClassName(clss));
        buf.append("(");
        buf.append(Type.class.getName());
        buf.append(" type) {");
        buf.append(this.newline(2));
        buf.append("super(type);");
        buf.append(this.newline(1));
        buf.append("}");
        return buf.toString();
    }

    protected String createOperations(Package pkg, org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        if (clss.getSuperClasses() != null) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.provisioning.Class sclss = this.context.findClass(cref);
                for (Property field : sclss.getProperties()) {
                    String sclassOpers = this.createOperations(pkg, sclss, field);
                    buf.append(sclassOpers);
                }
                Package spkg = this.context.findPackage(cref);
                buf.append(this.createOperations(spkg, sclss));
            }
        }
        return buf.toString();
    }

    protected String createOperations(Package pkg, org.plasma.provisioning.Class clss, Property field) {
        StringBuilder buf = new StringBuilder();
        TypeClassInfo typeClassName = this.getTypeClassName(field.getType());
        buf.append(LINE_SEP);
        this.createIsSet(pkg, clss, field, typeClassName, buf);
        buf.append(LINE_SEP);
        this.createUnsetter(pkg, clss, field, typeClassName, buf);
        if (field.getType() instanceof ClassRef) {
            org.plasma.provisioning.Class targetClass = this.context.findClass((ClassRef)field.getType());
            if (!targetClass.isAbstract()) {
                buf.append(LINE_SEP);
                this.createCreator(null, clss, field, typeClassName, buf);
            } else {
                buf.append(LINE_SEP);
                this.createCreatorByAbstractClass(null, clss, field, typeClassName, buf);
            }
        }
        if (!field.isMany()) {
            buf.append(LINE_SEP);
            this.createSingularGetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createSingularSetter(pkg, clss, field, typeClassName, buf);
        } else {
            buf.append(LINE_SEP);
            this.createManyGetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyIndexGetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyCount(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManySetter(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyAdder(pkg, clss, field, typeClassName, buf);
            buf.append(LINE_SEP);
            this.createManyRemover(pkg, clss, field, typeClassName, buf);
        }
        return buf.toString();
    }

    private void createSingularGetter(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createSingularGetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createSingularGetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createSingularGetterBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.indent(2));
        TypeRef typeRef = field.getType();
        if (typeRef instanceof DataTypeRef) {
            DataType sdoType = DataType.valueOf(typeRef.getName());
            Class<?> typeClass = this.getTypeClass(sdoType);
            if (typeClass.isPrimitive() && this.context.usePrimitives()) {
                Class<?> objectPrimitiveClass = this.getTypeClass(sdoType, false);
                buf.append(objectPrimitiveClass.getSimpleName());
                buf.append(" result = (");
                buf.append(objectPrimitiveClass.getSimpleName());
                buf.append(")");
                buf.append("super.get(");
                buf.append(this.toQualifiedPropertyNameReference(clss, field));
                buf.append(");");
                buf.append(this.newline(2));
                buf.append("if (result != null)");
                buf.append(this.newline(3));
                buf.append("return result.");
                buf.append(typeClass.getSimpleName());
                buf.append("Value();");
                buf.append(this.newline(2));
                buf.append("else return ");
                buf.append(this.getPrimitiveTypeDefault(sdoType));
                buf.append(";");
            } else {
                buf.append("return (");
                buf.append(typeClassName.getSimpleName());
                buf.append(")");
                buf.append("super.get(");
                buf.append(this.toQualifiedPropertyNameReference(clss, field));
                buf.append(");");
            }
        } else {
            buf.append("return (");
            buf.append(typeClassName.getSimpleName());
            buf.append(")");
            buf.append("super.get(");
            buf.append(this.toQualifiedPropertyNameReference(clss, field));
            buf.append(");");
        }
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createSingularSetter(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createSingularSetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createSingularSetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createSingularSetterBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("super.set(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(", value);");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createUnsetter(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createUnsetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createUnsetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createUnsetterBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("super.unset(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createIsSet(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createIsSetDeclaration(pkg, clss, field, typeClassName, buf);
        this.createIsSetBody(pkg, clss, field, typeClassName, buf);
    }

    private void createIsSetBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("return super.isSet(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createCreator(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createCreatorDeclaration(pkg, clss, field, typeClassName, buf);
        this.createCreatorBody(pkg, clss, field, typeClassName, buf);
    }

    private void createCreatorBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("return (");
        buf.append(typeClassName.getSimpleName());
        buf.append(")super.createDataObject(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createCreatorByAbstractClass(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        this.createCreatorByAbstractClassDeclaration(pkg, clss, field, typeClassName, buf);
        this.createCreatorByAbstractClassBody(pkg, clss, field, typeClassName, buf);
    }

    private void createCreatorByAbstractClassBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append(Type.class.getName());
        buf.append(" classType = ");
        buf.append(PlasmaTypeHelper.class.getName());
        buf.append(".INSTANCE.getType(clss);");
        buf.append(this.newline(2));
        buf.append("return (");
        buf.append(typeClassName.getSimpleName());
        buf.append(")super.createDataObject(this.getType().getProperty(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append("), classType);");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createManyGetter(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.newline(1));
        buf.append("@SuppressWarnings(\"unchecked\")");
        this.createManyGetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyGetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyGetterBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append("> list = (List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">)super.get(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(2));
        buf.append("if (list != null) {");
        buf.append(this.newline(3));
        buf.append(typeClassName.getSimpleName());
        buf.append("[] array = new ");
        buf.append(typeClassName.getSimpleName());
        buf.append("[list.size()];");
        buf.append(this.newline(3));
        buf.append("for (int i = 0; i < list.size(); i++)");
        buf.append(this.newline(4));
        buf.append("array[i] = list.get(i);");
        buf.append(this.newline(3));
        buf.append("return array;");
        buf.append(this.newline(2));
        buf.append("}");
        buf.append(this.newline(2));
        buf.append("else");
        buf.append(this.newline(3));
        buf.append("return new ");
        buf.append(typeClassName.getSimpleName());
        buf.append("[0];");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createManyIndexGetter(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.newline(1));
        buf.append("@SuppressWarnings(\"unchecked\")");
        this.createManyIndexGetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyIndexGetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyIndexGetterBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append("> list = (List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">)super.get(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(2));
        buf.append("if (list != null) {");
        buf.append(this.newline(3));
        buf.append("return (");
        buf.append(typeClassName.getSimpleName());
        buf.append(")list.get(idx);");
        buf.append(this.newline(2));
        buf.append("}");
        buf.append(this.newline(2));
        buf.append("else");
        buf.append(this.newline(3));
        buf.append("throw new ArrayIndexOutOfBoundsException(idx);");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createManyCount(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.newline(1));
        buf.append("@SuppressWarnings(\"unchecked\")");
        this.createManyCountDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyCountBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyCountBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append("> list = (List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">)super.get(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(2));
        buf.append("if (list != null) {");
        buf.append(this.newline(3));
        buf.append("return list.size();");
        buf.append(this.newline(2));
        buf.append("}");
        buf.append(this.newline(2));
        buf.append("else");
        buf.append(this.newline(3));
        buf.append("return 0;");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createManySetter(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(LINE_SEP);
        buf.append(this.indent(1));
        buf.append("@SuppressWarnings(\"unchecked\")");
        this.createManySetterDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManySetterBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManySetterBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append("> list = (List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">)super.get(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(2));
        buf.append("if (value != null && value.length > 0) {");
        buf.append(this.newline(3));
        buf.append("if (list == null)");
        buf.append(this.newline(4));
        buf.append("list = new ArrayList<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">();");
        buf.append(this.newline(3));
        buf.append("for (int i = 0; i < value.length; i++)");
        buf.append(this.newline(4));
        buf.append("list.add(value[i]);");
        buf.append(this.newline(3));
        buf.append("super.set(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(", list);");
        buf.append(this.newline(2));
        buf.append("}");
        buf.append(this.newline(2));
        buf.append("else");
        buf.append(this.newline(3));
        buf.append("throw new IllegalArgumentException(\"expected non-null and non-zero length array argument 'value' - use unset");
        buf.append(this.firstToUpperCase(field.getName()));
        buf.append("() method to remove this property\");");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createManyAdder(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.newline(1));
        buf.append("@SuppressWarnings(\"unchecked\")");
        this.createManyAdderDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyAdderBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyAdderBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append("> list = (List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">)super.get(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(2));
        buf.append("if (list == null)");
        buf.append(this.newline(3));
        buf.append("list = new ArrayList<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">();");
        buf.append(this.newline(4));
        buf.append("list.add(value);");
        buf.append(this.newline(2));
        buf.append("// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation");
        buf.append(this.newline(2));
        buf.append("super.setList(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(", list);");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    private void createManyRemover(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.newline(1));
        buf.append("@SuppressWarnings(\"unchecked\")");
        this.createManyRemoverDeclaration(pkg, clss, field, typeClassName, buf);
        this.createManyRemoverBody(pkg, clss, field, typeClassName, buf);
    }

    private void createManyRemoverBody(Package pkg, org.plasma.provisioning.Class clss, Property field, TypeClassInfo typeClassName, StringBuilder buf) {
        buf.append(this.beginBody());
        buf.append(this.newline(2));
        buf.append("List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append("> list = (List<");
        buf.append(typeClassName.getCollectionSimpleName());
        buf.append(">)super.get(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(");");
        buf.append(this.newline(2));
        buf.append("if (list != null)");
        buf.append(this.newline(4));
        buf.append("list.remove(value);");
        buf.append(this.newline(2));
        buf.append("// NOTE: SDO 2.1 spec specifies replacing the whole list on a multi-valued 'set' operation");
        buf.append(this.newline(2));
        buf.append("super.setList(");
        buf.append(this.toQualifiedPropertyNameReference(clss, field));
        buf.append(", list);");
        buf.append(this.newline(1));
        buf.append(this.endBody());
    }

    @Override
    public String createDirectoryName(Package pkg) {
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(pkg.getUri());
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        String subpackage = PlasmaConfig.getInstance().getSDO().getGlobalProvisioning().getImplementation().getChildPackageName();
        if (subpackage != null && subpackage.trim().length() > 0) {
            packageName = packageName + "." + subpackage;
        }
        String packageDir = packageName.replace(".", "/");
        StringBuilder buf = new StringBuilder();
        buf.append(packageDir);
        return buf.toString();
    }

    protected String createPackageName(Package pkg) {
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(pkg.getUri());
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        String subpackage = PlasmaConfig.getInstance().getSDO().getGlobalProvisioning().getImplementation().getChildPackageName();
        if (subpackage != null && subpackage.trim().length() > 0) {
            packageName = packageName + "." + subpackage;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(packageName);
        return buf.toString();
    }

    @Override
    protected String createPackageDeclaration(Package pkg) {
        StringBuilder buf = new StringBuilder();
        buf.append("package " + this.createPackageName(pkg));
        buf.append(";");
        return buf.toString();
    }

    protected String createThirdPartyImportDeclarations(Package pkg, org.plasma.provisioning.Class clss) {
        StringBuilder buf = new StringBuilder();
        buf.append(LINE_SEP);
        buf.append(this.createImportDeclaration(pkg, clss, Serializable.class.getName()));
        buf.append(LINE_SEP);
        buf.append(this.createImportDeclaration(pkg, clss, CoreDataObject.class.getName()));
        if (!this.hasOnlySingilarFieldsDeep(clss)) {
            buf.append(LINE_SEP);
            buf.append(this.createImportDeclaration(pkg, clss, List.class.getName()));
            buf.append(LINE_SEP);
            buf.append(this.createImportDeclaration(pkg, clss, ArrayList.class.getName()));
        }
        return buf.toString();
    }
}

