/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.provisioning.AnnotationMetamodelAssembler;
import org.plasma.provisioning.MetamodelAssembler;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.DSLToolAction;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.ProvisioningToolOption;
import org.plasma.text.lang3gl.DefaultLang3GLContext;
import org.plasma.text.lang3gl.Lang3GLDialect;
import org.plasma.text.lang3gl.Lang3GLOperation;
import org.plasma.text.lang3gl.java.DSLAssembler;
import org.plasma.text.lang3gl.java.DSLFactory;
import org.xml.sax.SAXException;

public class DSLTool
extends ProvisioningTool {
    private static Log log = LogFactory.getLog(DSLTool.class);

    public static void main(String[] args) throws JAXBException, SAXException, IOException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder verboseOpt = parser.accepts(ProvisioningToolOption.verbose.name(), ProvisioningToolOption.verbose.getDescription());
        OptionSpecBuilder silentOpt = parser.accepts(ProvisioningToolOption.silent.name(), ProvisioningToolOption.silent.getDescription());
        OptionSpecBuilder helpOpt = parser.accepts(ProvisioningToolOption.help.name(), ProvisioningToolOption.help.getDescription());
        OptionSpecBuilder commandOpt = parser.accepts(ProvisioningToolOption.command.name(), ProvisioningToolOption.command.getDescription() + " - one of [" + DSLToolAction.asString() + "] is expected");
        commandOpt.withRequiredArg().ofType(DSLToolAction.class);
        ArgumentAcceptingOptionSpec lastExecutionOpt = parser.accepts(ProvisioningToolOption.lastExecution.name(), ProvisioningToolOption.lastExecution.getDescription()).withRequiredArg().ofType(Long.class);
        ArgumentAcceptingOptionSpec destOpt = parser.accepts(ProvisioningToolOption.dest.name(), ProvisioningToolOption.dest.getDescription()).withOptionalArg().ofType(File.class);
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            DSLTool.printUsage(parser, log);
            return;
        }
        if (!options.has(ProvisioningToolOption.command.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                DSLTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.command.name() + "'");
        }
        DSLToolAction command = (DSLToolAction)options.valueOf(ProvisioningToolOption.command.name());
        Lang3GLDialect dialect = Lang3GLDialect.java;
        File destDir = new File("./target/");
        if (options.has((OptionSpec)destOpt)) {
            destDir = (File)destOpt.value(options);
        }
        if (!destDir.exists()) {
            if (!options.has((OptionSpec)silentOpt)) {
                log.debug((Object)("given destination dir '" + destDir.getName() + "' does not exist"));
            }
            if (!destDir.mkdirs()) {
                throw new IllegalArgumentException("given destination dir '" + destDir.getName() + "' could not be created");
            }
        }
        switch (command) {
            case create: {
                Lang3GLOperation operation = Lang3GLOperation.valueOf(command.name());
                long lastExecution = 0L;
                if (options.has((OptionSpec)lastExecutionOpt)) {
                    lastExecution = (Long)lastExecutionOpt.value(options);
                }
                if (!DSLTool.regenerate(lastExecution)) {
                    if (!options.has((OptionSpec)silentOpt)) {
                        log.info((Object)"skipping DSL creation - no stale artifacts detected");
                    }
                    return;
                }
                AnnotationMetamodelAssembler annotationAssembler = new AnnotationMetamodelAssembler();
                if (annotationAssembler.hasAnnotatedClasses()) {
                    DSLTool.loadAnnotationModel(annotationAssembler, destDir, options, silentOpt);
                }
                MetamodelAssembler modelAssembler = new MetamodelAssembler();
                ModelAdapter validator = new ModelAdapter(modelAssembler.getModel());
                DefaultLang3GLContext factoryContext = new DefaultLang3GLContext(validator);
                DSLFactory factory = null;
                switch (dialect) {
                    case java: {
                        factory = new DSLFactory(factoryContext);
                        break;
                    }
                    default: {
                        throw new ProvisioningException("unknown 3GL language dialect, '" + dialect.name() + "'");
                    }
                }
                DSLAssembler assembler = new DSLAssembler(validator, factory, operation, destDir);
                assembler.start();
                if (options.has((OptionSpec)silentOpt)) break;
                log.info((Object)("generated " + assembler.getResultClassesCount() + " classes to output to directory: " + destDir.getAbsolutePath()));
                break;
            }
            default: {
                throw new ProvisioningException("unknown command '" + command.toString() + "'");
            }
        }
    }
}

