/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.PlasmaNode;

public class DataObjectCommitCollector
implements PlasmaDataGraphVisitor {
    private static Log log = LogFactory.getFactory().getInstance(DataObjectCommitCollector.class);
    private DataGraph dataGraph;
    private List<DataObject> createdList = new ArrayList<DataObject>();
    private List<DataObject> modifiedList = new ArrayList<DataObject>();
    private List<DataObject> deletedList = new ArrayList<DataObject>();

    private DataObjectCommitCollector() {
    }

    public DataObjectCommitCollector(DataGraph dataGraph) {
        this.dataGraph = dataGraph;
        PlasmaDataObject root = (PlasmaDataObject)this.dataGraph.getRootObject();
        root.accept(this);
    }

    @Override
    public void visit(DataObject target, DataObject source, String sourceKey, int level) {
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)target.getChangeSummary();
        int targetDepth = changeSummary.getPathDepth(target);
        int sourceDepth = changeSummary.getPathDepth(source);
    }

    public int compare(DataObject target, DataObject source) {
        if (target.getDataGraph() == null) {
            throw new IllegalArgumentException("target data-object has no data-graph - data-objects compared for commit operations must have a data graph");
        }
        if (source.getDataGraph() == null) {
            throw new IllegalArgumentException("source data-object has no data-graph - data-objects compared for commit operations must have a data graph");
        }
        PlasmaChangeSummary changeSummary = (PlasmaChangeSummary)target.getChangeSummary();
        int targetDepth = changeSummary.getPathDepth(target);
        int sourceDepth = changeSummary.getPathDepth(source);
        if ("ProjectElement".equals(target.getType().getName())) {
            int lll = 34;
            ++lll;
        }
        int result = 0;
        result = changeSummary.isCreated(target) ? (changeSummary.isCreated(source) ? (this.isChild(target, source) ? 1 : (this.isChild(source, target) ? -1 : (targetDepth > sourceDepth ? 1 : (sourceDepth > targetDepth ? -1 : 0)))) : -1) : (changeSummary.isModified(target) ? (changeSummary.isCreated(source) ? 1 : (changeSummary.isModified(source) ? (targetDepth > sourceDepth ? 1 : (sourceDepth > targetDepth ? -1 : 0)) : -1)) : (changeSummary.isDeleted(source) ? (this.isChild(target, source) ? -1 : (this.isChild(source, target) ? 1 : (targetDepth > sourceDepth ? -1 : (sourceDepth > targetDepth ? 1 : 0)))) : 1));
        return result;
    }

    private boolean isChild(DataObject target, DataObject source) {
        return this.hasChildProperty(target, source);
    }

    private boolean hasChildLink(DataObject target, DataObject source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing " + target.getType().getName() + "/" + source.getType().getName()));
        }
        List settings = target.getDataGraph().getChangeSummary().getOldValues(target);
        for (ChangeSummary.Setting setting : settings) {
            Property property = setting.getProperty();
            if (property.getType().isDataType() || !property.getType().getName().equals(source.getType().getName())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking property " + target.getType().getName() + "." + property.getName()));
            }
            if (!this.isLinked(source, setting.getValue()) || property.isMany()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("found child data link " + target.getType().getName() + "." + property.getName() + "->" + source.getType().getName()));
            }
            if (target.getType().getName().equals(source.getType().getName())) {
                throw new IllegalStateException("potential circular reference");
            }
            return true;
        }
        return false;
    }

    private boolean hasChildProperty(DataObject target, DataObject source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing " + target.getType().getName() + "/" + source.getType().getName()));
        }
        for (Property p : target.getType().getDeclaredProperties()) {
            Property property = p;
            if (property.getType().isDataType() || !property.getType().getName().equals(source.getType().getName()) || property.isMany()) continue;
            if (target.getType().getName().equals(source.getType().getName())) {
                throw new IllegalStateException("potential circular reference");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("found child link property " + target.getType().getName() + "." + property.getName() + "->" + source.getType().getName()));
            }
            return true;
        }
        return false;
    }

    private boolean isLinked(DataObject other, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            for (DataObject dataObject : list) {
                PlasmaNode dataNode = (PlasmaNode)dataObject;
                if (!dataNode.getUUIDAsString().equals(((PlasmaNode)other).getUUIDAsString())) continue;
                return true;
            }
        } else {
            DataObject dataObject = (DataObject)value;
            PlasmaNode dataNode = (PlasmaNode)dataObject;
            if (dataNode.getUUIDAsString().equals(((PlasmaNode)other).getUUIDAsString())) {
                return true;
            }
        }
        return false;
    }
}

