/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.atteo.classindex.ClassIndex;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.annotation.NamespaceProvisioning;
import org.plasma.metamodel.Body;
import org.plasma.metamodel.ClassProvisioning;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.ConcurentDataFlavor;
import org.plasma.metamodel.ConcurrencyType;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.EnumerationLiteral;
import org.plasma.metamodel.EnumerationRef;
import org.plasma.metamodel.Key;
import org.plasma.metamodel.KeyType;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Property;
import org.plasma.metamodel.PropertyProvisioning;
import org.plasma.metamodel.Sort;
import org.plasma.metamodel.TypeRef;
import org.plasma.metamodel.VisibilityType;
import org.plasma.metamodel.XmlNodeType;
import org.plasma.metamodel.XmlProperty;
import org.plasma.provisioning.AnnotationConverter;
import org.plasma.provisioning.InvalidAnnotationException;
import org.plasma.provisioning.MissingAnnotationException;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.common.NameUtils;
import org.plasma.sdo.DataType;
import org.plasma.sdo.annotation.Alias;
import org.plasma.sdo.annotation.Comment;
import org.plasma.sdo.annotation.Concurrent;
import org.plasma.sdo.annotation.DataProperty;
import org.plasma.sdo.annotation.EnumConstraint;
import org.plasma.sdo.annotation.Enumeration;
import org.plasma.sdo.annotation.Namespace;
import org.plasma.sdo.annotation.ReferenceProperty;
import org.plasma.sdo.annotation.Type;
import org.plasma.sdo.annotation.ValueConstraint;

public class AnnotationMetamodelAssembler
implements AnnotationConverter {
    private static final String DERIVED_ARTIFACT_URI_PREFIX = "http://derived-artifact/";
    private static Log log = LogFactory.getLog(AnnotationMetamodelAssembler.class);
    private Model model;
    private Map<String, org.plasma.metamodel.Package> packageURIMap = new HashMap<String, org.plasma.metamodel.Package>();
    private Map<String, org.plasma.metamodel.Class> classMap = new HashMap<String, org.plasma.metamodel.Class>();
    private Map<String, org.plasma.metamodel.Enumeration> enumerationMap = new HashMap<String, org.plasma.metamodel.Enumeration>();
    private List<Class<?>> dataObjectClasses = new ArrayList();

    public AnnotationMetamodelAssembler() {
        for (Class c : ClassIndex.getAnnotated(Type.class)) {
            if (!c.isEnum()) {
                throw new InvalidAnnotationException("annotation " + Type.class.getName() + " may only be applied to java enumeration (enum) classes");
            }
            this.dataObjectClasses.add(c);
        }
    }

    @Override
    public boolean hasAnnotatedClasses() {
        return this.dataObjectClasses.size() > 0;
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = this.buildModel();
        }
        return this.model;
    }

    @Override
    public Model buildModel() {
        org.plasma.metamodel.Package packg;
        Package javaPkg;
        this.createPachageHierarchy();
        for (Class<?> c : this.dataObjectClasses) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("discovered " + c.getName()));
            }
            javaPkg = c.getPackage();
            packg = this.packageURIMap.get(javaPkg.getName());
            Type type = c.getAnnotation(Type.class);
            org.plasma.metamodel.Class clss = this.createClass(type.name(), type.isAbstract(), c, type.superTypes(), packg);
            String qualifiedName = packg.getUri() + "#" + clss.getName();
            log.debug((Object)("initializing class: " + qualifiedName));
            assert (clss.getUri().equals(packg.getUri()));
            this.classMap.put(qualifiedName, clss);
        }
        for (Class<?> c : this.dataObjectClasses) {
            javaPkg = c.getPackage();
            packg = this.packageURIMap.get(javaPkg.getName());
            Type dataObject = c.getAnnotation(Type.class);
            String qualifiedName = packg.getUri() + "#" + dataObject.name();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing class: " + qualifiedName));
            }
            org.plasma.metamodel.Class clss = this.classMap.get(qualifiedName);
            try {
                for (Object o : c.getEnumConstants()) {
                    Enum enm = (Enum)o;
                    Field field = c.getField(enm.name());
                    DataProperty dataProperty = field.getAnnotation(DataProperty.class);
                    if (dataProperty != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("processing data field: " + qualifiedName + "." + enm.name()));
                        }
                        this.createDataProperty(dataProperty, field, enm, clss, packg);
                        continue;
                    }
                    ReferenceProperty referenceProperty = field.getAnnotation(ReferenceProperty.class);
                    if (referenceProperty != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("processing reference field: " + qualifiedName + "." + enm.name()));
                        }
                        this.createReferenceProperty(referenceProperty, field, enm, clss, packg);
                        continue;
                    }
                    throw new MissingAnnotationException("expected either " + DataProperty.class.getName() + " or " + ReferenceProperty.class.getName() + " annotation for enum field " + clss.getName() + "." + enm.name());
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new ProvisioningException(e);
            }
        }
        return this.model;
    }

    private void createPachageHierarchy() {
        HashMap<String, org.plasma.metamodel.Package> map = new HashMap<String, org.plasma.metamodel.Package>();
        for (Class<?> c : this.dataObjectClasses) {
            Package javaPkg = c.getPackage();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing package " + javaPkg.getName()));
            }
            Namespace namespace = javaPkg.getAnnotation(Namespace.class);
            String[] tokens = javaPkg.getName().split("\\.");
            StringBuilder key = new StringBuilder();
            org.plasma.metamodel.Package parent = null;
            for (int i = 0; i < tokens.length; ++i) {
                boolean isLeaf;
                boolean bl = isLeaf = i + 1 == tokens.length;
                if (i > 0) {
                    key.append(".");
                }
                key.append(tokens[i]);
                org.plasma.metamodel.Package pkg = (org.plasma.metamodel.Package)map.get(key.toString());
                if (pkg != null) {
                    parent = pkg;
                    continue;
                }
                if (this.model == null) {
                    pkg = this.createPackage(tokens[i], namespace, javaPkg, isLeaf, true);
                    this.model = (Model)pkg;
                    this.model.setUri(DERIVED_ARTIFACT_URI_PREFIX + UUID.randomUUID().toString());
                } else {
                    pkg = this.createPackage(tokens[i], namespace, javaPkg, isLeaf, false);
                }
                map.put(key.toString(), pkg);
                if (parent != null) {
                    parent.getPackages().add(pkg);
                }
                if (isLeaf) {
                    String uri = null;
                    uri = namespace != null ? namespace.uri() : this.deriveUri(javaPkg);
                    this.packageURIMap.put(uri, pkg);
                    this.packageURIMap.put(javaPkg.getName(), pkg);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("created leaf package " + javaPkg.getName() + " as " + uri));
                    }
                }
                parent = pkg;
            }
        }
    }

    private String deriveUri(Package pkg) {
        String uri = "http://" + pkg.getName();
        return uri;
    }

    private org.plasma.metamodel.Package createPackage(String nameToken, Namespace namespace, Package javaPackage, boolean leafPackage, boolean modelPackage) {
        Object pkg = null;
        pkg = !modelPackage ? new org.plasma.metamodel.Package() : new Model();
        pkg.setName(nameToken);
        pkg.setId(UUID.randomUUID().toString());
        if (leafPackage) {
            if (namespace != null) {
                pkg.setUri(namespace.uri());
            } else {
                pkg.setUri(this.deriveUri(javaPackage));
            }
            org.plasma.metamodel.NamespaceProvisioning nsProv = new org.plasma.metamodel.NamespaceProvisioning();
            pkg.setNamespaceProvisioning(nsProv);
            nsProv.setOriginatingPackageName(javaPackage.getName());
            NamespaceProvisioning nsProvAnnot = javaPackage.getAnnotation(NamespaceProvisioning.class);
            if (nsProvAnnot != null) {
                nsProv.setPackageName(nsProvAnnot.rootPackageName());
            }
        }
        org.plasma.metamodel.Alias alias = null;
        Alias srcAlias = javaPackage.getAnnotation(Alias.class);
        if (srcAlias != null) {
            alias = this.createAlias(srcAlias);
        }
        if (leafPackage) {
            if (alias == null) {
                alias = this.createAlias(nameToken, namespace, javaPackage);
                pkg.setAlias(alias);
            } else {
                if (alias.getLocalName() != null && alias.getLocalName().length() > 0) {
                    log.warn((Object)("alias local name for package should not be used in this context - overwriting local name for " + javaPackage.getName()));
                }
                alias.setLocalName(javaPackage.getName());
            }
            Comment srcComment = javaPackage.getAnnotation(Comment.class);
            Documentation doc = new Documentation();
            doc.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            doc.setBody(body);
            pkg.getDocumentations().add(doc);
            if (srcComment != null && srcComment.body().length() > 0) {
                body.setValue(srcComment.body());
            } else {
                body.setValue("Derived from package " + javaPackage.getName());
            }
        }
        return pkg;
    }

    private org.plasma.metamodel.Class createClass(String name, boolean isAbstract, Class<?> javaClass, Class<?>[] generalizations, org.plasma.metamodel.Package pkg) {
        org.plasma.metamodel.Alias alias;
        org.plasma.metamodel.Class clss = new org.plasma.metamodel.Class();
        pkg.getClazzs().add(clss);
        clss.setId(UUID.randomUUID().toString());
        clss.setName(name);
        clss.setUri(pkg.getUri());
        clss.setAbstract(Boolean.valueOf(isAbstract));
        ClassProvisioning classProv = new ClassProvisioning();
        clss.setClassProvisioning(classProv);
        classProv.setOriginatingClassName(javaClass.getSimpleName());
        Alias srcAlias = javaClass.getAnnotation(Alias.class);
        if (srcAlias != null) {
            alias = this.createAlias(srcAlias);
            if (alias != null) {
                clss.setAlias(alias);
                if (alias.getLocalName() != null && alias.getLocalName().length() > 0) {
                    log.warn((Object)("alias local name for property should not be used in this context - overwriting local name for " + clss.getName()));
                }
                alias.setLocalName(javaClass.getSimpleName());
            }
        } else {
            alias = new org.plasma.metamodel.Alias();
            clss.setAlias(alias);
            alias.setLocalName(javaClass.getSimpleName());
        }
        String localName = pkg.getAlias().getLocalName() + "." + clss.getAlias().getLocalName();
        String targetName = pkg.getNamespaceProvisioning().getPackageName() + "." + clss.getName();
        if (localName.equals(targetName)) {
            log.warn((Object)("potential unresolvable name collision: " + targetName));
        }
        for (Class<?> gen : generalizations) {
            Package genJavaPkg = gen.getPackage();
            org.plasma.metamodel.Package genPkg = this.packageURIMap.get(genJavaPkg.getName());
            Type genDataObject = gen.getAnnotation(Type.class);
            if (genDataObject == null) {
                throw new MissingAnnotationException("expected " + Type.class.getName() + " annotation for enum class " + gen.getName());
            }
            ClassRef ref = new ClassRef();
            ref.setName(genDataObject.name());
            ref.setUri(genPkg.getUri());
            clss.getSuperClasses().add(ref);
        }
        Comment srcComment = javaClass.getAnnotation(Comment.class);
        Documentation doc = new Documentation();
        doc.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        doc.setBody(body);
        clss.getDocumentations().add(doc);
        if (srcComment != null && srcComment.body().length() > 0) {
            body.setValue(srcComment.body());
        } else {
            body.setValue("Derived from class " + javaClass.getName());
        }
        return clss;
    }

    private Property createDataProperty(DataProperty dataProperty, Field javaField, Enum sourceEnum, org.plasma.metamodel.Class clss, org.plasma.metamodel.Package pkg) throws NoSuchFieldException, SecurityException {
        EnumConstraint srcEnumerationConstraint;
        ValueConstraint srcValueConstraint;
        org.plasma.sdo.annotation.XmlProperty srcXmlProperty;
        Concurrent srcConcurrent;
        Property property = this.createProperty(javaField, sourceEnum, dataProperty.isNullable(), dataProperty.isMany(), dataProperty.isReadOnly(), clss, pkg);
        clss.getProperties().add(property);
        DataType sdoType = dataProperty.dataType();
        DataTypeRef type = this.createDatatype(sdoType.name());
        property.setType((TypeRef)type);
        org.plasma.sdo.annotation.Key srcKey = javaField.getAnnotation(org.plasma.sdo.annotation.Key.class);
        if (srcKey != null) {
            Key key = new Key();
            key.setType(KeyType.valueOf((String)srcKey.type().name().toUpperCase()));
            property.setKey(key);
        }
        if ((srcConcurrent = javaField.getAnnotation(Concurrent.class)) != null) {
            org.plasma.metamodel.Concurrent conc = new org.plasma.metamodel.Concurrent();
            conc.setType(ConcurrencyType.valueOf((String)srcConcurrent.type().name().toUpperCase()));
            conc.setDataFlavor(ConcurentDataFlavor.valueOf((String)srcConcurrent.dataFlavor().name().toUpperCase()));
            property.setConcurrent(conc);
        }
        if ((srcXmlProperty = javaField.getAnnotation(org.plasma.sdo.annotation.XmlProperty.class)) != null) {
            XmlProperty xmlProp = new XmlProperty();
            xmlProp.setNodeType(XmlNodeType.valueOf((String)srcXmlProperty.nodeType().name().toUpperCase()));
            property.setXmlProperty(xmlProp);
        }
        if ((srcValueConstraint = javaField.getAnnotation(ValueConstraint.class)) != null) {
            org.plasma.metamodel.ValueConstraint valueConstraint = new org.plasma.metamodel.ValueConstraint();
            if (srcValueConstraint.fractionDigits() != null && srcValueConstraint.fractionDigits().length() > 0) {
                valueConstraint.setFractionDigits(srcValueConstraint.fractionDigits());
            }
            if (srcValueConstraint.maxExclusive() != null && srcValueConstraint.maxExclusive().length() > 0) {
                valueConstraint.setMaxExclusive(srcValueConstraint.maxExclusive());
            }
            if (srcValueConstraint.maxInclusive() != null && srcValueConstraint.maxInclusive().length() > 0) {
                valueConstraint.setMaxInclusive(srcValueConstraint.maxInclusive());
            }
            if (srcValueConstraint.maxLength() != null && srcValueConstraint.maxLength().length() > 0) {
                valueConstraint.setMaxLength(srcValueConstraint.maxLength());
            }
            if (srcValueConstraint.minExclusive() != null && srcValueConstraint.minExclusive().length() > 0) {
                valueConstraint.setMinExclusive(srcValueConstraint.minExclusive());
            }
            if (srcValueConstraint.minInclusive() != null && srcValueConstraint.minInclusive().length() > 0) {
                valueConstraint.setMinInclusive(srcValueConstraint.minInclusive());
            }
            if (srcValueConstraint.minLength() != null && srcValueConstraint.minLength().length() > 0) {
                valueConstraint.setMinLength(srcValueConstraint.minLength());
            }
            if (srcValueConstraint.pattern() != null && srcValueConstraint.pattern().length() > 0) {
                valueConstraint.setPattern(srcValueConstraint.pattern());
            }
            property.setValueConstraint(valueConstraint);
        }
        if ((srcEnumerationConstraint = javaField.getAnnotation(EnumConstraint.class)) != null) {
            String enumKey = clss.getUri() + "#" + srcEnumerationConstraint.targetEnum().getSimpleName();
            org.plasma.metamodel.Enumeration enumeration = this.enumerationMap.get(enumKey);
            if (enumeration == null) {
                enumeration = this.createEnumeration(clss, srcEnumerationConstraint.targetEnum());
                pkg.getEnumerations().add(enumeration);
                this.enumerationMap.put(enumKey, enumeration);
            }
            EnumerationConstraint enumConstraint = new EnumerationConstraint();
            EnumerationRef enumRef = new EnumerationRef();
            enumRef.setName(enumeration.getName());
            enumRef.setUri(enumeration.getUri());
            enumConstraint.setValue(enumRef);
            property.setEnumerationConstraint(enumConstraint);
        }
        return property;
    }

    private Property createReferenceProperty(ReferenceProperty referenceProperty, Field javaField, Enum sourceEnum, org.plasma.metamodel.Class clss, org.plasma.metamodel.Package pkg) {
        Property property = this.createProperty(javaField, sourceEnum, referenceProperty.isNullable(), referenceProperty.isMany(), referenceProperty.readOnly(), clss, pkg);
        clss.getProperties().add(property);
        String qualifiedName = null;
        Class targetJavaClass = referenceProperty.targetClass();
        Package targetJavaPkg = targetJavaClass.getPackage();
        org.plasma.metamodel.Package targetPackage = this.packageURIMap.get(targetJavaPkg.getName());
        Type targetDataObject = targetJavaClass.getAnnotation(Type.class);
        qualifiedName = targetPackage.getUri() + "#" + targetDataObject.name();
        org.plasma.metamodel.Class targetPropertyClass = this.classMap.get(qualifiedName);
        if (targetPropertyClass == null) {
            throw new ProvisioningException("could not find class, " + qualifiedName);
        }
        ClassRef ref = new ClassRef();
        ref.setName(targetPropertyClass.getName());
        ref.setUri(targetPropertyClass.getUri());
        property.setType((TypeRef)ref);
        property.setOpposite(referenceProperty.targetProperty());
        return property;
    }

    private Property createProperty(Field javaField, Enum sourceEnum, boolean isNullable, boolean isMany, boolean isReadOnly, org.plasma.metamodel.Class clss, org.plasma.metamodel.Package pkg) {
        org.plasma.metamodel.Alias alias;
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        property.setName(NameUtils.toCamelCase(sourceEnum.name()));
        property.setNullable(isNullable);
        property.setReadOnly(Boolean.valueOf(isReadOnly));
        property.setMany(isMany);
        property.setVisibility(VisibilityType.PUBLIC);
        PropertyProvisioning propProv = new PropertyProvisioning();
        property.setPropertyProvisioning(propProv);
        propProv.setOriginatingPropertyName(sourceEnum.name());
        Alias srcAlias = javaField.getAnnotation(Alias.class);
        if (srcAlias != null) {
            alias = this.createAlias(srcAlias);
            if (alias != null) {
                property.setAlias(alias);
                if (alias.getLocalName() != null && alias.getLocalName().length() > 0) {
                    log.warn((Object)("alias local name for property should not be used in this context - overwriting local name for " + property.getName()));
                }
                alias.setLocalName(sourceEnum.name());
            }
        } else {
            alias = new org.plasma.metamodel.Alias();
            property.setAlias(alias);
            alias.setLocalName(sourceEnum.name());
        }
        org.plasma.sdo.annotation.Sort srcSort = javaField.getAnnotation(org.plasma.sdo.annotation.Sort.class);
        if (srcSort != null) {
            Sort sequence = new Sort();
            sequence.setKey(srcSort.key());
            property.setSort(sequence);
        }
        Comment srcComment = javaField.getAnnotation(Comment.class);
        Documentation doc = new Documentation();
        doc.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        doc.setBody(body);
        property.getDocumentations().add(doc);
        if (srcComment != null && srcComment.body().length() > 0) {
            body.setValue(srcComment.body());
        } else {
            body.setValue("Derived from field " + javaField.getName());
        }
        return property;
    }

    private org.plasma.metamodel.Enumeration createEnumeration(org.plasma.metamodel.Class clss, Class<?> srcEnumClass) throws NoSuchFieldException, SecurityException {
        org.plasma.metamodel.Alias alias;
        Enumeration dataEnumeration = srcEnumClass.getAnnotation(Enumeration.class);
        if (dataEnumeration == null) {
            throw new MissingAnnotationException("expected " + Enumeration.class.getName() + " annotation for enum class " + srcEnumClass.getName());
        }
        org.plasma.metamodel.Enumeration enumeration = new org.plasma.metamodel.Enumeration();
        enumeration.setName(dataEnumeration.name());
        enumeration.setUri(clss.getUri());
        enumeration.setId(UUID.randomUUID().toString());
        Alias srcAlias = srcEnumClass.getAnnotation(Alias.class);
        if (srcAlias != null && (alias = this.createAlias(srcAlias)) != null) {
            enumeration.setAlias(alias);
        }
        for (Object o : srcEnumClass.getEnumConstants()) {
            org.plasma.metamodel.Alias alias2;
            Enum enm = (Enum)o;
            Field field = srcEnumClass.getField(enm.name());
            EnumerationLiteral literal = new EnumerationLiteral();
            literal.setName(enm.name());
            literal.setValue(enm.name());
            Alias fieldAlias = field.getAnnotation(Alias.class);
            if (fieldAlias != null && (alias2 = this.createAlias(fieldAlias)) != null) {
                literal.setAlias(alias2);
            }
            Comment srcComment = field.getAnnotation(Comment.class);
            Documentation doc = new Documentation();
            doc.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            doc.setBody(body);
            literal.getDocumentations().add(doc);
            if (srcComment != null && srcComment.body().length() > 0) {
                body.setValue(srcComment.body());
            } else {
                body.setValue("Derived from field " + field.getName());
            }
            enumeration.getEnumerationLiterals().add(literal);
        }
        return enumeration;
    }

    private org.plasma.metamodel.Alias createAlias(String nameToken, Namespace namespace, Package javaPackage) {
        org.plasma.metamodel.Alias alias = new org.plasma.metamodel.Alias();
        alias.setPhysicalName(nameToken);
        alias.setLocalName(javaPackage.getName());
        return alias;
    }

    private org.plasma.metamodel.Alias createAlias(Alias srcAlias) {
        org.plasma.metamodel.Alias alias = null;
        if (srcAlias.physicalName() != null && srcAlias.physicalName().trim().length() > 0) {
            if (alias == null) {
                alias = new org.plasma.metamodel.Alias();
            }
            alias.setPhysicalName(srcAlias.physicalName());
        }
        if (srcAlias.localName() != null && srcAlias.localName().trim().length() > 0) {
            if (alias == null) {
                alias = new org.plasma.metamodel.Alias();
            }
            alias.setLocalName(srcAlias.localName());
        }
        if (srcAlias.businessName() != null && srcAlias.businessName().trim().length() > 0) {
            if (alias == null) {
                alias = new org.plasma.metamodel.Alias();
            }
            alias.setBusinessName(srcAlias.businessName());
        }
        return alias;
    }

    private DataTypeRef createDatatype(String name) {
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(name);
        dataTypeRef.setUri(PlasmaConfig.getInstance().getSDODataTypesNamespace().getUri());
        return dataTypeRef;
    }
}

