/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import commonj.sdo.DataGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.metamodel.Model;
import org.plasma.provisioning.MetamodelAssembler;
import org.plasma.provisioning.MetamodelDataBinding;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.ProvisioningTarget;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.ProvisioningToolOption;
import org.plasma.provisioning.cli.QueryToolAction;
import org.plasma.query.Query;
import org.plasma.query.bind.PlasmaQueryDataBinding;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.access.client.SDODataAccessClient;
import org.plasma.sdo.core.CoreXMLDocument;
import org.plasma.sdo.helper.PlasmaXSDHelper;
import org.plasma.sdo.xml.MarshallerException;
import org.plasma.sdo.xml.StreamMarshaller;
import org.plasma.xml.uml.MDModelAssembler;
import org.xml.sax.SAXException;

public class QueryTool
extends ProvisioningTool {
    private static Log log = LogFactory.getLog(QueryTool.class);

    public static void main(String[] args) throws TransformerConfigurationException, IOException, TransformerException, ClassNotFoundException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder verboseOpt = parser.accepts(ProvisioningToolOption.verbose.name(), ProvisioningToolOption.verbose.getDescription());
        OptionSpecBuilder silentOpt = parser.accepts(ProvisioningToolOption.silent.name(), ProvisioningToolOption.silent.getDescription());
        OptionSpecBuilder helpOpt = parser.accepts(ProvisioningToolOption.help.name(), ProvisioningToolOption.help.getDescription());
        OptionSpecBuilder commandOpt = parser.accepts(ProvisioningToolOption.command.name(), ProvisioningToolOption.command.getDescription() + " - one of [" + QueryToolAction.asString() + "] is expected");
        commandOpt.withRequiredArg().ofType(QueryToolAction.class);
        ArgumentAcceptingOptionSpec srcOpt = parser.accepts(ProvisioningToolOption.source.name(), ProvisioningToolOption.source.getDescription()).withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec destOpt = parser.accepts(ProvisioningToolOption.dest.name(), ProvisioningToolOption.dest.getDescription()).withOptionalArg().ofType(File.class);
        OptionSpecBuilder destTypeOpt = parser.accepts(ProvisioningToolOption.destType.name(), ProvisioningToolOption.destType.getDescription() + " - one of [" + ProvisioningTarget.asString() + "] is expected");
        destTypeOpt.withRequiredArg().ofType(ProvisioningTarget.class);
        ArgumentAcceptingOptionSpec namespaceOpt = parser.accepts(ProvisioningToolOption.namespace.name(), ProvisioningToolOption.namespace.getDescription()).withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec namespacePrefixOpt = parser.accepts(ProvisioningToolOption.namespacePrefix.name(), ProvisioningToolOption.namespacePrefix.getDescription()).withOptionalArg().ofType(String.class);
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            QueryTool.printUsage(parser, log);
            return;
        }
        if (!options.has(ProvisioningToolOption.command.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                QueryTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.command.name() + "'");
        }
        QueryToolAction command = (QueryToolAction)options.valueOf(ProvisioningToolOption.command.name());
        File sourceFile = null;
        if (!options.has((OptionSpec)srcOpt)) {
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.source.name() + "'");
        }
        sourceFile = (File)srcOpt.value(options);
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("given source file '" + sourceFile.getName() + "' does not exist");
        }
        File destFile = new File("./target/" + QueryTool.class.getSimpleName() + ".out");
        if (options.has((OptionSpec)destOpt)) {
            destFile = (File)destOpt.value(options);
        }
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("directory path cannot be created for given dest file '" + destFile.getAbsolutePath() + "' ");
        }
        if (!options.has(ProvisioningToolOption.destType.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                QueryTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.destType.name() + "'");
        }
        ProvisioningTarget targetType = (ProvisioningTarget)options.valueOf(ProvisioningToolOption.destType.name());
        if (!options.has(ProvisioningToolOption.namespace.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                QueryTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.namespace.name() + "'");
        }
        String destNamespaceURI = (String)options.valueOf(ProvisioningToolOption.namespace.name());
        String destNamespacePrefix = "tns";
        if (options.has(ProvisioningToolOption.namespacePrefix.name())) {
            destNamespacePrefix = (String)options.valueOf(ProvisioningToolOption.namespacePrefix.name());
        }
        block0 : switch (command) {
            case compile: {
                File baseTempDir = new File(System.getProperty("java.io.tmpdir"));
                switch (targetType) {
                    case xsd: {
                        log.info((Object)"compiling query into XML Schema model");
                        QueryTool.generateXMLSchemaModel(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                        break block0;
                    }
                    case xmi: {
                        log.info((Object)"compiling query into UML/XMI model");
                        QueryTool.generateUMLModel(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("unknown target type '" + targetType.name() + "'");
            }
            case run: {
                log.info((Object)"running query");
                QueryTool.run(sourceFile, destFile, destNamespaceURI, destNamespacePrefix);
                log.info((Object)("successfully provisioned XML to, " + destFile.getName()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown command '" + command.toString() + "'");
            }
        }
    }

    private static void run(File queryFile, File destFile, String destNamespaceURI, String destNamespacePrefix) {
        FileOutputStream xmlos;
        log.info((Object)("unmarshaling query file '" + queryFile.getName() + "'"));
        String rootElementName = "Data";
        Query query = QueryTool.unmarshalQuery(queryFile);
        SDODataAccessClient service = new SDODataAccessClient();
        DataGraph[] results = service.find(query);
        try {
            xmlos = new FileOutputStream(destFile);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        for (int i = 0; i < results.length; ++i) {
            PlasmaDataObject dataObject = (PlasmaDataObject)results[i].getRootObject();
            CoreXMLDocument doc = new CoreXMLDocument(dataObject, destNamespaceURI, rootElementName);
            StreamMarshaller assembler = new StreamMarshaller(doc);
            try {
                assembler.marshal(xmlos);
                continue;
            }
            catch (XMLStreamException e) {
                throw new PlasmaRuntimeException((Throwable)e);
            }
            catch (MarshallerException e) {
                throw new PlasmaRuntimeException((Throwable)e);
            }
        }
    }

    private static void generateUMLModel(File queryFile, File destFile, String destNamespaceURI, String destNamespacePrefix) {
        log.info((Object)("unmarshaling query file '" + queryFile.getName() + "'"));
        Query query = QueryTool.unmarshalQuery(queryFile);
        MetamodelAssembler stagingAssembler = new MetamodelAssembler(query, destNamespaceURI, destNamespacePrefix);
        Model model = stagingAssembler.getModel();
        try {
            FileOutputStream os = new FileOutputStream(new File(destFile.getParentFile(), "query-pim.xml"));
            MetamodelDataBinding binding = new MetamodelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            binding.marshal(model, os);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        ModelAdapter validator = new ModelAdapter(model);
        log.info((Object)"assembling XMI model");
        MDModelAssembler modelAssembler = new MDModelAssembler(query, destNamespaceURI, destNamespacePrefix);
        Document document = modelAssembler.getDocument();
        log.info((Object)("marshaling XMI model to file, '" + destFile.getName() + "'"));
        try {
            FileOutputStream os = new FileOutputStream(destFile);
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateXMLSchemaModel(File queryFile, File destFile, String destNamespaceURI, String destNamespacePrefix) {
        FileOutputStream ouputStream;
        log.info((Object)("unmarshaling query file '" + queryFile.getName() + "'"));
        Query query = QueryTool.unmarshalQuery(queryFile);
        try {
            ouputStream = new FileOutputStream(destFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            log.info((Object)("marshaling XML schema to file, '" + destFile.getName() + "'"));
            PlasmaXSDHelper.INSTANCE.generate(query, destNamespaceURI, destNamespacePrefix, null, ouputStream);
        }
        finally {
            try {
                ouputStream.flush();
                ouputStream.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Query unmarshalQuery(File queryFile) {
        String queryXml = null;
        try {
            byte[] queryBytes = QueryTool.readContent(new FileInputStream(queryFile));
            queryXml = new String(queryBytes);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new PlasmaRuntimeException((Throwable)e);
        }
        Query query = null;
        try {
            PlasmaQueryDataBinding binding = new PlasmaQueryDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            if (log.isDebugEnabled()) {
                log.debug((Object)("query: " + queryXml));
            }
            query = (Query)binding.validate(queryXml);
        }
        catch (JAXBException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return query;
    }
}

